/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.ConverIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class ConversationItemIQHandler
extends IQHandler {
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/getConversationItem");
    private static final String NAMESPACE = "http://weaver.com.cn/getConversationItem";
    private static final Logger Log = LoggerFactory.getLogger(ConversationItemIQHandler.class);

    public ConversationItemIQHandler() {
        super("ConversationItemIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID from = packet.getFrom();
        if (from == null) {
            Log.error("ConversationItemIQHandler,iq from is null .Packet:{}", (Object)packet.toString());
            return null;
        }
        if (IQ.Type.get.equals((Object)packet.getType())) {
            try {
                String[] list;
                String elementText = packet.getElement().elementText("query");
                JSONObject json = JSON.parseObject((String)elementText);
                if (json == null) {
                    Log.error("ConversationItemIQHandler ,iq param is null .packet:{}", (Object)packet.toString());
                    return null;
                }
                String targetIds = null;
                if (json.containsKey((Object)"targetIds")) {
                    targetIds = json.getString("targetIds");
                }
                HashMap resultList = new HashMap();
                String userId = this.getUserIDByUsername(from.getNode());
                for (String targetId : list = targetIds.split(",")) {
                    Map<Object, Object> resultMap = new HashMap();
                    String redisKey = ConversationItemIQHandler.getRedisKey(userId, targetId);
                    RedisPoolMgr redis = RedisPoolMgr.getInstance();
                    if (redis != null) {
                        resultMap = redis.hgetall(redisKey);
                    }
                    if (resultMap == null || resultMap.isEmpty()) {
                        resultMap = this.getConverItem(userId, targetId);
                    }
                    resultList.put("targetId", resultMap);
                }
                IQ reply = IQ.createResultIQ((IQ)packet);
                Element elereply = reply.getElement();
                Element ele = elereply.addElement("query");
                String str = JSON.toJSONString(resultList).toString();
                ele.addText(str);
                Log.info("ConversationItemIQHandler ,result :{} ,json :{} ", (Object)str, (Object)json);
                return reply;
            }
            catch (Exception e) {
                Log.error("ConversationItemIQHandler ,error : {} ,packet :{} ", (Object)e.getMessage(), (Object)packet.toString());
            }
        } else {
            Log.error("ConversationItemIQHandler,iq type is not get .packet:{}", (Object)packet.toString());
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getConverItem(String userId, String targetId) {
        HashMap<String, String> obMap = null;
        String groupId = ConversationItemIQHandler.getConver(userId, targetId);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select t2.userid,t2.targetid,targettype,targetname,t1.istop,t1.isdel,t1.unreadcount,lasttime,msgcontent,msgid,t3.description as groupName,t3.groupIconUrl as groupIconUrlfrom social_IMConversation t2 left join social_IMRecentConver t1 on t2.targetid = t1.targetid left join ofgroup t3 on t1.targetId = t3.groupName where t2.targetid = ? AND t1.userid = ? ");
            pstmt.setString(1, groupId);
            pstmt.setString(2, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String targetid = rs.getString("targetid");
                if (targetid == null || targetid.isEmpty()) {
                    targetid = "";
                }
                if (!"1".equals(rs.getString("targettype")) && !Arrays.asList(targetid.split(",")).contains(userId) && !targetid.equals("bing_" + userId)) continue;
                obMap = new HashMap<String, String>(){

                    @Override
                    public boolean equals(Object o) {
                        try {
                            return ((String)this.get("targetid")).equals(((Map)o).get("targetid"));
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                };
                String userid = rs.getString("userid");
                if (userid == null || userid.isEmpty()) {
                    userid = "";
                }
                obMap.put("userid", userid);
                obMap.put("targetid", targetid);
                String targettype = rs.getString("targettype");
                if (targettype == null || targettype.isEmpty()) {
                    targettype = "";
                }
                obMap.put("targettype", targettype);
                String targetname = rs.getString("targetname");
                if (targetname == null || targetname.isEmpty()) {
                    targetname = "";
                }
                obMap.put("targetname", targetname);
                String istop = rs.getString("istop");
                if (istop == null || istop.isEmpty()) {
                    istop = "0";
                }
                obMap.put("istop", istop);
                String isdel = rs.getString("isdel");
                if (isdel == null || isdel.isEmpty()) {
                    isdel = "0";
                }
                obMap.put("isdel", isdel);
                String lasttime = rs.getString("lasttime");
                if (lasttime == null || lasttime.isEmpty()) continue;
                obMap.put("lasttime", lasttime);
                String msgcontent = rs.getString("msgcontent");
                if (msgcontent == null || msgcontent.isEmpty()) {
                    msgcontent = "";
                }
                obMap.put("msgcontent", msgcontent);
                String unreadcount = rs.getString("unreadcount");
                if (unreadcount == null || unreadcount.isEmpty()) {
                    unreadcount = "0";
                }
                obMap.put("unreadcount", unreadcount);
                String groupName = rs.getString("groupName");
                if (groupName == null || groupName.isEmpty()) {
                    groupName = "";
                }
                obMap.put("groupName", groupName);
                String groupIconUrl = rs.getString("groupIconUrl");
                if (groupIconUrl != null && !groupIconUrl.isEmpty()) continue;
                groupIconUrl = "";
            }
        }
        catch (Exception e) {
            try {
                Log.error("getConverItem ,error :{} ,userId : {} ,targetId : {} ", new Object[]{e.getMessage(), userId, targetId});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return obMap;
    }

    private static String getRedisKey(String userId, String targetId) {
        return "conversation:itmes:" + ConversationItemIQHandler.getConver(userId, targetId) + ":" + userId;
    }

    private static String getConver(String userId, String targetId) {
        String result = null;
        result = targetId != null && targetId.contains("bing_") ? targetId : (targetId != null && (targetId.startsWith("s_notice") || targetId.startsWith("s_assist") || targetId.startsWith("s_phone") || targetId.startsWith("a_") || ConversationItemIQHandler.isNumber(targetId)) ? ConverIDUtil.genaralTargetId(userId, targetId) : targetId);
        Log.info("getConver,userId:{},targetId:{},result:{}", new Object[]{userId, targetId, result});
        return result;
    }

    public static boolean isNumber(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    private String getUserIDByUsername(String username) {
        if (username.contains("|")) {
            int index = username.indexOf("|");
            return username.substring(0, index);
        }
        return username;
    }
}

