/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.cache.ConversationRedisCacheUtil;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class ConversationPageIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(ConversationPageIQHandler.class);
    private static final String CONVERSATION_NAMESPACE = "http://weaver.com.cn/getConversationPage";
    private static String QUERY_IMCONVERSATION = "SELECT userid,targetid,targettype,targetname,t1.istop,isdel,unreadcount,lasttime,msgcontent,msgid,sendid,objectname,content,sharetypename,sharetype,isAt, t3.description AS groupName,t3.groupIconUrl AS groupIconUrl,t3.groupType AS groupType,t3.isTop AS groupTop,t3.secretGroupType as secretGroupType from social_IMRecentConver t1 left join ofGroup t3 on t1.targetid = t3.groupName where userid= ?";
    private static String QUERY_IMCONVERSATION_LASTTIME = " and ( t1.updatetime < ? or t2.lasttime < ? ) ";
    private static String QUERY_IMCONVERSATION_ISDEL = " and (t1.isdel != '1' or t1.isdel is null) ";
    private static String QUERY_IMCONVERSATION_ORDERBY = " order by t1.istop desc ,lasttime desc  ";
    public static final String CONVERSATION_ITMES = "conversation:itmes:";
    public static final String CONVERSATION_RIGHT_HAD_INIT = "conversation:itmes:-1";
    private static final String CONVERSATION_RIGHT = "conversation:right:";
    private static final String CONVERSATION_TOP = "conversation:top:";
    private RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
    public static final int MAX_CONVERSATION_COUNT = 300;
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/getConversationPage");

    public ConversationPageIQHandler() {
        super("ConversationPageIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID fromJID = packet.getFrom();
        if (fromJID == null) {
            Log.warn("ConversationPageIQHandler.from is null.packet:{}", (Object)packet.toString());
            return null;
        }
        if (!IQ.Type.get.equals((Object)packet.getType())) {
            Log.warn("ConversationPageIQHandler.type is not get.packet:{}", (Object)packet.toString());
        }
        long startTime = System.currentTimeMillis();
        String userid = this.getUserIDByUsername(fromJID.getNode());
        String elementText = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)elementText);
        int pageSize = 300;
        if (json != null && json.containsKey((Object)"pageSize")) {
            pageSize = json.getIntValue("pageSize");
        }
        Long lasttime = null;
        if (json != null && json.containsKey((Object)"lasttime")) {
            lasttime = json.getLong("lasttime");
        }
        Map<String, Object> result = null;
        result = this.getIMConversation(userid, pageSize, lasttime);
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        String str = JSON.toJSONString(result).toString();
        ele.addText(str);
        long endTime = System.currentTimeMillis();
        Log.info("ConversationPageIQHandler success.fromJID:{},pageSize:{},lasttime:{},result:{},cost:{} ms", new Object[]{fromJID, pageSize, lasttime, str, endTime - startTime});
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    private String getUserIDByUsername(String username) {
        if (username.contains("|")) {
            int index = username.indexOf("|");
            return username.substring(0, index);
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getIMConversation(String userid, int pageSize, Long lastTime) {
        int pageSizeCopy = pageSize;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Object> reList = new ArrayList();
        long realLasttime = lastTime == null ? 0L : lastTime;
        Map<String, Object> redisResult = this.getIMConversationRedis(userid, pageSize, lastTime);
        if (redisResult != null) {
            reList = (List)redisResult.get("reList");
            if ("0".equals(redisResult.get("reload"))) {
                result.put("userid", userid);
                result.put("conversations", reList);
                return result;
            }
            pageSize = 300;
            lastTime = null;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Map<String, String>> dbToReids = new ArrayList<Map<String, String>>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(this.getIMConversationSQL(pageSize, lastTime));
            pstmt.setString(1, userid);
            if (lastTime != null && lastTime != 0L) {
                pstmt.setLong(2, lastTime);
                pstmt.setLong(3, lastTime);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String targettype;
                String targetid = rs.getString("targetid");
                if (targetid == null || targetid.isEmpty()) {
                    targetid = "";
                }
                if ((targettype = rs.getString("targettype")) == null || targettype.isEmpty()) {
                    targettype = rs.getString("targettype2");
                    targettype = (String)StringUtils.defaultIfEmpty((CharSequence)targettype, (CharSequence)"");
                }
                if (!"1".equals(targettype) && !Arrays.asList(targetid.split(",")).contains(userid) && !targetid.equals("bing_" + userid)) continue;
                HashMap<String, String> obMap = new HashMap<String, String>(){

                    @Override
                    public boolean equals(Object o) {
                        try {
                            return ((String)this.get("targetid")).equals(((Map)o).get("targetid"));
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                };
                String userId = rs.getString("userid");
                if (userId == null || userId.isEmpty()) {
                    userId = "";
                }
                obMap.put("userid", userId);
                obMap.put("targetid", targetid);
                obMap.put("targettype", targettype);
                String targetname = rs.getString("targetname");
                if (targetname == null || targetname.isEmpty()) {
                    targetname = (String)StringUtils.defaultIfEmpty((CharSequence)targetname, (CharSequence)"");
                }
                obMap.put("targetname", targetname);
                String istop = rs.getString("istop");
                if (istop == null || istop.isEmpty()) {
                    istop = "0";
                }
                obMap.put("istop", istop);
                String isdel = rs.getString("isdel");
                if (isdel == null || isdel.isEmpty()) {
                    isdel = "0";
                }
                obMap.put("isdel", isdel);
                String lasttime = rs.getString("lasttime");
                if (!(lasttime != null && !lasttime.isEmpty() || lasttime != null && !lasttime.isEmpty())) continue;
                obMap.put("lasttime", lasttime);
                String msgcontent = rs.getString("msgcontent");
                if (msgcontent == null || msgcontent.isEmpty()) {
                    msgcontent = (String)StringUtils.defaultIfEmpty((CharSequence)msgcontent, (CharSequence)"");
                }
                obMap.put("msgcontent", msgcontent);
                String unreadcount = rs.getString("unreadcount");
                if (unreadcount == null || unreadcount.isEmpty()) {
                    unreadcount = "0";
                }
                obMap.put("unreadcount", unreadcount);
                String groupName = rs.getString("groupName");
                if (groupName == null || groupName.isEmpty()) {
                    groupName = "";
                }
                obMap.put("groupName", groupName);
                String groupIconUrl = rs.getString("groupIconUrl");
                if (groupIconUrl == null || groupIconUrl.isEmpty()) {
                    groupIconUrl = "";
                }
                obMap.put("groupIconUrl", groupIconUrl);
                String groupType = rs.getString("groupType");
                obMap.put("groupType", (String)StringUtils.defaultIfEmpty((CharSequence)groupType, (CharSequence)"0"));
                String secretGroupType = rs.getString("secretGroupType");
                obMap.put("secretGroupType", (String)StringUtils.defaultIfEmpty((CharSequence)secretGroupType, (CharSequence)"0"));
                if ("1".equals(secretGroupType)) {
                    DatabaseUtil db = new DatabaseUtil();
                    obMap.put("secretGroupTargetId", db.getSecretChatTargetId(userId, targetid));
                }
                String groupTop = rs.getString("groupTop");
                obMap.put("groupTop", (String)StringUtils.defaultIfEmpty((CharSequence)groupTop, (CharSequence)"0"));
                String msgId = rs.getString("msgid");
                if (msgId != null && !msgId.isEmpty()) {
                    obMap.put("msgid", (String)StringUtils.defaultIfEmpty((CharSequence)msgId, (CharSequence)""));
                }
                String sendid = rs.getString("sendid");
                obMap.put("sendId", (String)StringUtils.defaultIfEmpty((CharSequence)sendid, (CharSequence)""));
                String objectName = rs.getString("objectname");
                obMap.put("objectName", (String)StringUtils.defaultIfEmpty((CharSequence)objectName, (CharSequence)""));
                String content = rs.getString("content");
                obMap.put("content", (String)StringUtils.defaultIfEmpty((CharSequence)content, (CharSequence)""));
                String sharetypename = rs.getString("sharetypename");
                obMap.put("sharetypename", (String)StringUtils.defaultIfEmpty((CharSequence)sharetypename, (CharSequence)""));
                String sharetype = rs.getString("sharetype");
                obMap.put("sharetype", (String)StringUtils.defaultIfEmpty((CharSequence)sharetype, (CharSequence)""));
                String isAt = rs.getString("isAt");
                obMap.put("isAt", (String)StringUtils.defaultIfEmpty((CharSequence)isAt, (CharSequence)"0"));
                if (reList.contains(obMap)) continue;
                if (Long.parseLong(lasttime) >= realLasttime) {
                    reList.add(obMap);
                }
                dbToReids.add((Map<String, String>)obMap);
            }
        }
        catch (Exception e) {
            try {
                Log.error("getIMConversation,userid:{},error:{}", (Object)userid, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        result.put("userid", userid);
        reList = ConversationPageIQHandler.sortConversationList(reList, pageSizeCopy);
        result.put("conversations", reList);
        try {
            if (ConversationRedisCacheUtil.getInstance() != null) {
                ConversationRedisCacheUtil.getInstance().batchSaveConv(userid, dbToReids, lastTime == null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static List<Map<String, String>> sortConversationList(List<Map<String, String>> list, int pageSize) {
        Collections.sort(list, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                long t1 = 0L;
                long t2 = 0L;
                String isGroupTop1 = o1.get("groupTop");
                String isGroupTop2 = o2.get("groupTop");
                if ("1".equals(isGroupTop1) && !"1".equals(isGroupTop2)) {
                    return -1;
                }
                if ("1".equals(isGroupTop2) && !"1".equals(isGroupTop1)) {
                    return 1;
                }
                String istop1 = o1.get("istop");
                String istop2 = o2.get("istop");
                if ("1".equals(istop1) && !"1".equals(istop2)) {
                    return -1;
                }
                if ("1".equals(istop2) && !"1".equals(istop1)) {
                    return 1;
                }
                try {
                    t1 = Long.parseLong(o1.get("lasttime"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    t2 = Long.parseLong(o2.get("lasttime"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (t2 > t1) {
                    return 1;
                }
                if (t2 == t1) {
                    return 0;
                }
                return -1;
            }
        });
        return pageSize < list.size() ? list.subList(0, pageSize) : list;
    }

    private String getConversationRightKey(String userId) {
        return CONVERSATION_RIGHT + userId;
    }

    private Map<String, Object> getIMConversationRedis(String userId, int pageSize, Long lastTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String key = this.getConversationRightKey(userId);
        List<Map<String, String>> reList = new ArrayList<Map<String, String>>();
        HashSet<String> set = new HashSet<String>();
        Set convRight = this.redisPoolMgr.zrevrangeByScore(key, Long.valueOf(0L), lastTime, 0, pageSize * 2);
        for (String rightKey : convRight) {
            if (!CONVERSATION_RIGHT_HAD_INIT.equals(rightKey)) {
                Map<String, String> rightMap = this.redisPoolMgr.hgetall(rightKey);
                if (rightMap != null && rightMap.containsKey("lasttime")) {
                    String isdel = (String)rightMap.get("isdel");
                    if ("1".equals(isdel)) continue;
                    reList.add(rightMap);
                    continue;
                }
                rightMap = this.getTopConversation(userId, this.getTargetIdByRedisKey(rightKey), rightKey);
                if (rightMap == null || !rightMap.containsKey("lasttime")) continue;
                reList.add(rightMap);
                continue;
            }
            result.put("reload", "0");
        }
        if (this.redisPoolMgr.zscore(key, CONVERSATION_RIGHT_HAD_INIT) != null) {
            result.put("reload", "0");
        }
        Iterator it = reList.iterator();
        while (it.hasNext()) {
            Map temp = (Map)it.next();
            String targetidTemp = (String)temp.get("targetid");
            if (temp.isEmpty() || targetidTemp == null) {
                it.remove();
                continue;
            }
            if (!("1".equals(temp.get("targettype")) || Arrays.asList(targetidTemp.split(",")).contains(userId) || targetidTemp.equals("bing_" + userId))) {
                it.remove();
                continue;
            }
            set.remove(this.getConversationItmesKeyHead(targetidTemp) + userId);
            temp.remove("recivesids");
            if (temp.containsKey("groupType") || !"1".equals(temp.get("targettype"))) continue;
            temp.put("groupType", "0");
        }
        if (set.size() > reList.size()) {
            result.remove("reload");
            this.delInvalidTargetId(key, set);
            if (lastTime == 0L) {
                this.delInvalidTargetId(this.getConversationTopKey(userId), set);
            }
        } else {
            reList = ConversationRedisCacheUtil.sortConversationList(reList, pageSize);
        }
        result.put("reList", reList);
        return result;
    }

    private String getConversationTopKey(String userId) {
        return CONVERSATION_TOP + userId;
    }

    private String getTargetIdByRedisKey(String redisKey) {
        String[] s = redisKey.split(":");
        return s[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getTopConversation(String userid, String targetId, String redisKey) {
        map = new HashMap<String, String>();
        con = null;
        pstmt = null;
        rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("SELECT userid,targetid,targettype,targetname,t1.istop,isdel,unreadcount,lasttime,msgcontent,msgid,sendid,objectname,content,sharetypename,sharetype,isAt,t3.description AS groupName,t3.groupIconUrl AS groupIconUrl, t3.groupType AS groupType,t3.isTop AS groupTop,t3.secretGroupType AS secretGroupType from social_IMRecentConver  t1 left join ofGroup t3 on t1.targetid = t3.groupName where t1.userid= ? and t1.targetid = ?");
            pstmt.setString(1, userid);
            pstmt.setString(2, targetId);
            rs = pstmt.executeQuery();
lbl11:
            // 3 sources

            while (rs.next()) {
                targetid = rs.getString("targetid");
                if (targetid == null || targetid.isEmpty()) {
                    targetid = "";
                }
                if ((targettype = rs.getString("targettype")) == null || targettype.isEmpty()) {
                    targettype = (String)StringUtils.defaultIfEmpty((CharSequence)targettype, (CharSequence)"");
                }
                if ((userId = rs.getString("userid")) == null || userId.isEmpty()) {
                    userId = "";
                }
                map.put("userid", userId);
                map.put("targetid", targetid);
                map.put("targettype", targettype);
                targetname = rs.getString("targetname");
                if (targetname == null || targetname.isEmpty()) {
                    targetname = (String)StringUtils.defaultIfEmpty((CharSequence)targetname, (CharSequence)"");
                }
                map.put("targetname", targetname);
                istop = rs.getString("istop");
                if (istop == null || istop.isEmpty()) {
                    istop = "0";
                }
                map.put("istop", istop);
                isdel = rs.getString("isdel");
                if (isdel == null || isdel.isEmpty()) {
                    isdel = "0";
                }
                if (!"1".equals(isdel)) ** GOTO lbl-1000
                var14_15 = null;
                ** GOTO lbl49
            }
            ** GOTO lbl116
        }
        catch (SQLException e) {
            try {
                ConversationPageIQHandler.Log.error("getTopConversation,userid:{},targetId:{},error:{}", new Object[]{userid, targetId, e.getMessage()});
            }
            catch (Throwable var30_31) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw var30_31;
            }
lbl49:
            // 1 sources

            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return var14_15;
lbl-1000:
            // 1 sources

            {
                map.put("isdel", isdel);
                lasttime = rs.getString("lasttime");
                if (lasttime != null && !lasttime.isEmpty() || lasttime != null && !lasttime.isEmpty()) ** GOTO lbl-1000
                ConversationPageIQHandler.Log.warn("getTopConversation,lasttime is null,userId:{},targetid:{},targetType:{},targetname:{}", new Object[]{userId, targetid, targettype, targetname});
                var15_16 = null;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return var15_16;
lbl-1000:
            // 1 sources

            {
                map.put("lasttime", lasttime);
                msgcontent = rs.getString("msgcontent");
                if (msgcontent == null || msgcontent.isEmpty()) {
                    msgcontent = (String)StringUtils.defaultIfEmpty((CharSequence)msgcontent, (CharSequence)"");
                }
                map.put("msgcontent", msgcontent);
                unreadcount = rs.getString("unreadcount");
                if (unreadcount == null || unreadcount.isEmpty()) {
                    unreadcount = "0";
                }
                map.put("unreadcount", unreadcount);
                groupName = rs.getString("groupName");
                if (groupName == null || groupName.isEmpty()) {
                    groupName = "";
                }
                map.put("groupName", groupName);
                groupIconUrl = rs.getString("groupIconUrl");
                if (groupIconUrl == null || groupIconUrl.isEmpty()) {
                    groupIconUrl = "";
                }
                map.put("groupIconUrl", groupIconUrl);
                groupType = rs.getString("groupType");
                map.put("groupType", (String)StringUtils.defaultIfEmpty((CharSequence)groupType, (CharSequence)"0"));
                groupTop = rs.getString("groupTop");
                map.put("groupTop", (String)StringUtils.defaultIfEmpty((CharSequence)groupTop, (CharSequence)"0"));
                msgId = rs.getString("msgid");
                map.put("msgid", (String)StringUtils.defaultIfEmpty((CharSequence)msgId, (CharSequence)""));
                sendid = rs.getString("sendid");
                map.put("sendId", (String)StringUtils.defaultIfEmpty((CharSequence)sendid, (CharSequence)""));
                objectName = rs.getString("objectname");
                map.put("objectName", (String)StringUtils.defaultIfEmpty((CharSequence)objectName, (CharSequence)""));
                content = rs.getString("content");
                map.put("content", (String)StringUtils.defaultIfEmpty((CharSequence)content, (CharSequence)""));
                sharetypename = rs.getString("sharetypename");
                map.put("sharetypename", (String)StringUtils.defaultIfEmpty((CharSequence)sharetypename, (CharSequence)""));
                sharetype = rs.getString("sharetype");
                map.put("sharetype", (String)StringUtils.defaultIfEmpty((CharSequence)sharetype, (CharSequence)""));
                isAt = rs.getString("isAt");
                map.put("isAt", (String)StringUtils.defaultIfEmpty((CharSequence)isAt, (CharSequence)""));
                secretGroupType = rs.getString("secretGroupType");
                map.put("secretGroupType", (String)StringUtils.defaultIfEmpty((CharSequence)secretGroupType, (CharSequence)"0"));
                if (!"1".equals(secretGroupType)) ** GOTO lbl11
                db = new DatabaseUtil();
                map.put("secretGroupTargetId", db.getSecretChatTargetId(userId, targetId));
                ** GOTO lbl11
            }
lbl116:
            // 1 sources

            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        if (map != null && !map.isEmpty()) {
            this.redisPoolMgr.batchHset(redisKey, map, 2592000);
        }
        return map;
    }

    private String getConversationItmesKeyHead(String targetId) {
        return CONVERSATION_ITMES + targetId + ":";
    }

    private boolean delInvalidTargetId(String key, Set<String> set) {
        Log.info("delInvalidTargetId,key:{},set={}", (Object)key, set);
        boolean result = true;
        try {
            this.redisPoolMgr.zrem(key, set.toArray(new String[set.size()]));
        }
        catch (Exception e) {
            result = false;
            Log.error("ConversationRedisCacheUtil ->delInvalidTargetId  error,key:{},set:{}, err msg:{}", new Object[]{key, set, e.getMessage()});
        }
        return result;
    }

    private String getIMConversationSQL(int pageSize, Long lasttime) {
        String querySQL = QUERY_IMCONVERSATION;
        querySQL = lasttime != null && lasttime != 0L ? querySQL + QUERY_IMCONVERSATION_LASTTIME : querySQL + QUERY_IMCONVERSATION_ISDEL;
        String sql = "select top " + pageSize + " * from ( " + querySQL + " ) A " + QUERY_IMCONVERSATION_ORDERBY;
        if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sql = "select * from (select A.*, rownum rn from (" + querySQL + QUERY_IMCONVERSATION_ORDERBY + " ) A where rownum <= " + pageSize + ") where rn >= 1 ";
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = querySQL + QUERY_IMCONVERSATION_ORDERBY + "limit 0 ," + pageSize;
        } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = querySQL + QUERY_IMCONVERSATION_ORDERBY + "limit " + pageSize;
        }
        return sql;
    }
}

