/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class DeleteConversationIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(DeleteConversationIQHandler.class);
    private static final String DELETECONVERSATION_NAMESPACE = "http://weaver.com.cn/deleteConversation";
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/deleteConversation");

    public DeleteConversationIQHandler() {
        super("DeleteConversationIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID fromJID = packet.getFrom();
        if (fromJID == null) {
            Log.warn("DeleteConversationIQHandler from is null.packet:{}", (Object)packet.toString());
            return null;
        }
        if (!IQ.Type.set.equals((Object)packet.getType())) {
            Log.warn("DeleteConversationIQHandler type is not set.packet:{}", (Object)packet.toString());
            return null;
        }
        String userid = this.getUserIDByUsername(fromJID.getNode());
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        String data = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)data);
        String targetid = null;
        if (json != null && json.containsKey((Object)"targetid")) {
            targetid = json.getString("targetid");
        }
        DatabaseUtil db = new DatabaseUtil();
        db.deleteOFConversation(userid, targetid);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("result", 0);
        ele.addText(JSON.toJSONString(result).toString());
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    private String getUserIDByUsername(String username) {
        if (username.contains("|")) {
            int index = username.indexOf("|");
            return username.substring(0, index);
        }
        return username;
    }
}

