/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.emessage.multirouter.messagemanager.UsernameUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.ThreadPoolFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.MultiRouterPlugin;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.DingUtil;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.ComponentManagerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class DingIQHandler
extends IQHandler
implements Component {
    private IQHandlerInfo info;
    private UserManager userManager;
    private ComponentManager componentManager;
    private static final String DING_XMLNS = "http://weaver.com.cn/ding";
    private static final Logger Log = LoggerFactory.getLogger(DingIQHandler.class);
    private String XMPPDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();

    public DingIQHandler() {
        super(DingIQHandler.class.getName());
        this.info = new IQHandlerInfo("query", DING_XMLNS);
        this.userManager = UserManager.getInstance();
        this.componentManager = ComponentManagerFactory.getComponentManager();
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        Map<Object, Object> result = new HashMap<String, Object>();
        JID fromJID = packet.getFrom();
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elementReply = reply.getElement();
        Element ele = elementReply.addElement("query");
        if (fromJID == null) {
            Log.error("DingIQHandler,fromJID is null,packt ={}", (Object)packet.toString());
        } else {
            JSONObject json = JSONObject.parseObject((String)packet.getElement().elementText("query"));
            String method = (String)json.get((Object)"method");
            DatabaseUtil du = new DatabaseUtil();
            if (IQ.Type.get.equals((Object)packet.getType())) {
                String userid = JIDUtil.conNodeToID(fromJID.getNode());
                Long lastTime = json.containsKey((Object)"lastTime") ? Long.valueOf(Long.parseLong(json.getString("lastTime"))) : Long.valueOf(System.currentTimeMillis() * 2L);
                if ("getDingList".equals(method)) {
                    String content = json.getString("content") == null ? "" : json.getString("content");
                    String sendOrReceive = json.getString("sendOrReceive") == null ? "all" : json.getString("sendOrReceive");
                    result = du.getDingList(userid, lastTime, sendOrReceive, content, json.getString("confirm"), json.getIntValue("pageSize") == 0 ? 10 : json.getIntValue("pageSize"));
                } else if ("getDingReplyDetail".equals(method)) {
                    result = du.getDingReplyDetailById(json.getString("dingId"), lastTime, json.getIntValue("pageSize") == 0 ? 10 : json.getIntValue("pageSize"), userid);
                } else if ("getDingConfirmDetail".equals(method)) {
                    result = du.getDingConfirmDetailById(json.getIntValue("dingId"), userid);
                } else if ("getDingDetail".equals(method)) {
                    int ding_id = json.getIntValue("ding_id");
                    result = du.getDingInfoByDingId(ding_id, false, userid);
                }
            } else if (IQ.Type.set.equals((Object)packet.getType())) {
                int dingId = json.getIntValue("dingId");
                String userId = JIDUtil.conNodeToID(fromJID.getNode());
                if ("confirm".equals(method)) {
                    if (du.updateDingConfirm(dingId, userId)) {
                        Map<String, Object> dingMap = du.getDingInfoByDingId(dingId, false);
                        dingMap.put("replyUpdate", "false");
                        dingMap.put("confirmUpdate", "true");
                        String displayedContent = (String)dingMap.get("content");
                        String dingSendid = (String)dingMap.get("sendid");
                        try {
                            User user = UserManager.getInstance().getUser(fromJID.getNode());
                            displayedContent = String.format(LocaleUtils.getLocalizedString((String)"ding.message.confirm", (String)"multirouter"), UsernameUtil.getUserName(user.getUsername(), user.getName()), displayedContent);
                        }
                        catch (UserNotFoundException e) {
                            Log.error("DingIQHandler.confirm: could not find user:{},error:{}", (Object)userId, (Object)e.getMessage());
                        }
                        HashSet<String> receiveridSet = new HashSet<String>();
                        receiveridSet.add(userId);
                        ArrayList<String> toUserIds = new ArrayList<String>();
                        String dingsendid = (String)dingMap.get("sendid");
                        if (dingsendid != null && !dingsendid.equals(userId)) {
                            toUserIds.add(dingSendid);
                            this.sendDingMessage(this.getMessageByDingConfirm(dingMap, userId), toUserIds, false);
                        }
                        if (!"".equals(dingMap.get("messageid")) && "true".equals(dingMap.get("confirmUpdate"))) {
                            dingMap.put("displayedContent", displayedContent);
                            JSONObject contentObject = new JSONObject();
                            JSONObject paraObject = new JSONObject();
                            contentObject.put("vibrate", (Object)"1");
                            contentObject.put("sound", (Object)"default");
                            contentObject.put("alert", (Object)"\u76ef\u529e");
                            contentObject.put("badge", (Object)"1");
                            paraObject.put("ding", dingMap);
                            contentObject.put("para", (Object)paraObject);
                            new DatabaseUtil().updateDingClassName((String)dingMap.get("messageid"), contentObject.toJSONString());
                        }
                        result.put("result", JSON.toJSONString(du.getDingSingleById(userId, dingId)));
                        result.put("success", 1);
                    } else {
                        result.put("result", "");
                        result.put("success", 0);
                    }
                } else if ("reply".equals(method)) {
                    String content;
                    String string = content = json.getString("content") == null ? "" : json.getString("content");
                    if (du.insertDingReply(dingId, userId, content)) {
                        Map<String, Object> dingMap = du.getDingInfoByDingId(dingId, false);
                        String dingSendid = (String)dingMap.get("sendid");
                        String displayedContent = (String)dingMap.get("content");
                        try {
                            User user = UserManager.getInstance().getUser(fromJID.getNode());
                            displayedContent = String.format(LocaleUtils.getLocalizedString((String)"ding.message.reply", (String)"multirouter"), user.getName(), displayedContent);
                        }
                        catch (UserNotFoundException e) {
                            Log.error("DingIQHandler.confirm: could not find user:{},error:{}", (Object)userId, (Object)e.getMessage());
                        }
                        HashSet<String> receiveridList = new HashSet<String>();
                        receiveridList.add(userId);
                        HashSet<String> dingSendidList = new HashSet<String>();
                        dingSendidList.add(dingSendid);
                        dingMap.put("displayedContent", displayedContent);
                        dingMap.put("replyUpdate", "true");
                        dingMap.put("confirmUpdate", "false");
                        ArrayList<String> toUserIds = new ArrayList<String>();
                        String dingsendid = (String)dingMap.get("sendid");
                        if (dingsendid != null && !dingsendid.equals(userId)) {
                            toUserIds.add(dingsendid);
                            this.sendDingMessage(this.getMessageByDingReply(dingMap, userId, content), toUserIds, false);
                        }
                        if (!"".equals(dingMap.get("messageid")) && "true".equals(dingMap.get("confirmUpdate"))) {
                            JSONObject contentObject = new JSONObject();
                            JSONObject paraObject = new JSONObject();
                            contentObject.put("vibrate", (Object)"1");
                            contentObject.put("sound", (Object)"default");
                            contentObject.put("alert", (Object)"\u76ef\u529e");
                            contentObject.put("badge", (Object)"1");
                            paraObject.put("ding", dingMap);
                            contentObject.put("para", (Object)paraObject);
                            new DatabaseUtil().updateDingClassName((String)dingMap.get("messageid"), contentObject.toJSONString());
                        }
                        result.put("success", 1);
                    } else {
                        result.put("success", 0);
                    }
                } else if ("delete".equals(method)) {
                    if (du.deleteDing(dingId)) {
                        DingUtil dingUtil = new DingUtil();
                        dingUtil.deleteDingUtil(dingId, userId);
                        result.put("success", 1);
                    } else {
                        result.put("success", 0);
                    }
                }
            }
            ele.addText(JSON.toJSONString(result).toString());
            Log.info("DingIQHandler\uff0cmethod:{},result:{}.packet:{},Completed", new Object[]{method, JSON.toJSONString(result).toString(), packet.toString()});
        }
        return reply;
    }

    private void sendDingMessage(Message message, List<String> toUserIds, final boolean isDelDing) {
        for (int i = 0; i < toUserIds.size(); ++i) {
            toUserIds.set(i, this.getNodeID(toUserIds.get(i)));
        }
        final List<String> toUserIdsFinal = toUserIds;
        final Message messageFinal = message;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                if (toUserIdsFinal != null && toUserIdsFinal.size() > 0) {
                    for (int i = 0; i < toUserIdsFinal.size(); ++i) {
                        if (i != 0 && i % 200 == 0) {
                            if (isDelDing) {
                                Log.info("sendDelMessage,sendMessageNumber is {} ,and now thread sleep,msgid={}", (Object)i, (Object)messageFinal.getID());
                            } else {
                                Log.info("sendConfirmMessage,sendMessageNumber is {} ,and now thread sleep,msgid={}", (Object)i, (Object)messageFinal.getID());
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                if (isDelDing) {
                                    Log.error("sendDelMessage,sendMessageThread sleep msgid={}, error={},", (Object)messageFinal.getID(), (Object)e.getMessage());
                                }
                                Log.error("sendConfirmMessage,sendMessageThread sleep msgid={}, error={},", (Object)messageFinal.getID(), (Object)e.getMessage());
                            }
                        }
                        Message messageCopy = messageFinal.createCopy();
                        String toUserId = ((String)toUserIdsFinal.get(i)).toLowerCase();
                        messageCopy.setTo(new JID(toUserId, DingIQHandler.this.XMPPDomain, null, true));
                        MultiRouterPlugin.serverPlugin.sendPacket((Packet)messageCopy);
                    }
                }
            }
        });
    }

    private Message getMessageByDingConfirm(Map<String, Object> dingMap, String userId) {
        Message message = new Message();
        JSONObject dingMessage = new JSONObject();
        dingMessage.put("objectName", (Object)"FW:CountMsg");
        dingMessage.put("content", (Object)"ding");
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("ding_id", dingMap.get("id"));
        extra.put("messageid", (String)dingMap.get("messageid"));
        dingMessage.put("extra", extra);
        message.setType(Message.Type.chat);
        message.setBody(dingMessage.toJSONString());
        message.setFrom(new JID(userId + "|" + ServerInfo.SYSTEM_UDID.toLowerCase(), this.XMPPDomain, "sys", true));
        message.setID(StringUtils.randomString((int)8));
        Log.info("getMessageByDingConfirm :{} ", (Object)message.toString());
        return message;
    }

    private Message getMessageByDingReply(Map<String, Object> dingMap, String userId, String replyContent) {
        Message message = new Message();
        JSONObject dingMessage = new JSONObject();
        dingMessage.put("objectName", (Object)"RC:TxtMsg");
        dingMessage.put("content", (Object)replyContent);
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("msg_id", UUID.randomUUID().toString());
        extra.put("receiverid", dingMap.get("sendid"));
        extra.put("senderid", userId);
        HashMap<String, Object> ding_info = new HashMap<String, Object>();
        ding_info.put("id", dingMap.get("id"));
        ding_info.put("title", dingMap.get("content"));
        ding_info.put("sender", dingMap.get("sendid"));
        ding_info.put("messageid", (String)dingMap.get("messageid"));
        extra.put("ding_info", ding_info);
        dingMessage.put("extra", extra);
        message.setType(Message.Type.chat);
        message.setBody(dingMessage.toJSONString());
        message.setFrom(new JID(userId + "|" + ServerInfo.SYSTEM_UDID.toLowerCase(), this.XMPPDomain, "sys", true));
        message.setID(StringUtils.randomString((int)8));
        Log.info("getDingReplyContent,message:{}", (Object)message.toString());
        return message;
    }

    private Message getDeleteMessage(Map<String, Object> dingMap) {
        Message message = new Message();
        JSONObject dingMessage = new JSONObject();
        JSONObject contentObject = new JSONObject();
        JSONObject paraObject = new JSONObject();
        contentObject.put("vibrate", (Object)"1");
        contentObject.put("sound", (Object)"default");
        contentObject.put("alert", (Object)"\u5220\u9664\u5fc5\u8fbe");
        contentObject.put("badge", (Object)"1");
        paraObject.put("ding", dingMap);
        contentObject.put("para", (Object)paraObject);
        contentObject.put("type", (Object)"delete");
        dingMessage.put("objectName", (Object)"FW:CMDMsg");
        dingMessage.put("content", (Object)contentObject.toJSONString());
        message.setType(Message.Type.chat);
        message.setBody(dingMessage.toJSONString());
        message.setFrom(new JID(ServerInfo.SYSTEM_UDID + "|ding", this.XMPPDomain, null, true));
        message.setID(StringUtils.randomString((int)8));
        return message;
    }

    private String getNodeID(String userid) {
        if (userid.indexOf("|") < 0) {
            userid = userid + "|" + ServerInfo.SYSTEM_UDID;
        }
        return userid;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    public String getRealUserId(String jidNode) {
        if (jidNode.indexOf("|") > 0) {
            jidNode = jidNode.substring(0, jidNode.indexOf("|"));
        }
        return jidNode;
    }

    public String getDescription() {
        return null;
    }

    public void processPacket(Packet packet) {
    }

    public void initialize(JID jid, ComponentManager componentManager) throws ComponentException {
    }

    public void shutdown() {
    }
}

