/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class GetTopConversationsIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(GetTopConversationsIQHandler.class);
    private String GETTOPCONVERSATION_XMLNS = "http://weaver.com.cn/getTopConversation";
    private IQHandlerInfo info = new IQHandlerInfo("query", this.GETTOPCONVERSATION_XMLNS);

    public GetTopConversationsIQHandler() {
        super("GetTopConversationsIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        long startTime = System.currentTimeMillis();
        JID fromJID = packet.getFrom();
        if (fromJID == null || fromJID.getResource() == null) {
            Log.warn("GetTopConversationsIQHandler .packet from is invalid . packet : {} ", (Object)packet.toString());
            return null;
        }
        if (!IQ.Type.get.equals((Object)packet.getType())) {
            Log.warn("GetTopConversationsIQHandler . packet type is not get .packet : {} ", (Object)packet.toString());
            return null;
        }
        String data = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)data);
        String targetId = null;
        if (json.containsKey((Object)"targteId")) {
            targetId = json.getString("targetId");
        }
        Map<Object, Object> result = new HashMap();
        String userid = JIDUtil.conNodeToID(fromJID.getNode());
        DatabaseUtil db = new DatabaseUtil();
        result = targetId != null ? db.getTopConversation(userid, targetId, true) : db.getTopConversation(userid, targetId, false);
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        ele.addText(JSON.toJSONString(result).toString());
        long endTime = System.currentTimeMillis();
        Log.info("GetTopConversationsIQHandler success.cost : {} ms .result :{} ", (Object)(endTime - startTime), (Object)JSON.toJSONString(result).toString());
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

