/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PresenceManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;

public class GetUserOnlineIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(GetUserOnlineIQHandler.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/ClientOnline");
    private static final String ELEMENT = "query";
    private static final String NAMESPACE = "http://weaver.com.cn/ClientOnline";
    private PresenceManager presenceManager = XMPPServer.getInstance().getPresenceManager();
    private UserManager userManager = XMPPServer.getInstance().getUserManager();

    public GetUserOnlineIQHandler() {
        super("GetUserOnlineIQHandler");
        Log.debug("GetUserOnlineIQHandler init");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        if (packet.getFrom() == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        DatabaseUtil db = new DatabaseUtil();
        IQ reply = IQ.createResultIQ((IQ)packet);
        String username = packet.getFrom().getNode();
        Element eleReply = reply.getElement();
        Element eleResult = eleReply.addElement(ELEMENT);
        String data = packet.getElement().elementText(ELEMENT);
        String followUsername = null;
        JSONObject json = JSON.parseObject((String)data);
        followUsername = (String)json.get((Object)"username");
        boolean isFriend = false;
        try {
            Roster cachedRoster = this.userManager.getUser(username).getRoster();
            Collection rosterItems = cachedRoster.getRosterItems();
            for (RosterItem roster : rosterItems) {
                if (!roster.getJid().getNode().equals(followUsername)) continue;
                isFriend = true;
            }
        }
        catch (UserNotFoundException e) {
            Log.error("GetUserOnlineIQHandler,username={}, user not found", (Object)username);
        }
        boolean isOnline = this.isOnline(followUsername);
        result.put("isOnline", String.valueOf(isOnline));
        if (isFriend) {
            if (packet.getType().equals((Object)IQ.Type.get)) {
                eleResult.addText(JSONObject.toJSONString(result).toString());
                return reply;
            }
            if (packet.getType().equals((Object)IQ.Type.set)) {
                return reply;
            }
        }
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    private boolean isOnline(String username) {
        try {
            return this.presenceManager.isAvailable(this.userManager.getUser(username));
        }
        catch (UserNotFoundException e) {
            Log.error("isOnline:error", (Object)e.getMessage());
            return false;
        }
    }
}

