/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class HistoryIQHandle
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(HistoryIQHandle.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", this.HISTORY_XMLNS);
    private String HISTORY_XMLNS = "http://weaver.com.cn/history";

    public HistoryIQHandle() {
        super("HistoryIQHandle");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        Long endTime;
        int pageSize;
        Long lastTime;
        String targetId;
        boolean isEM7;
        int targetType;
        JID fromJID = packet.getFrom();
        if (fromJID == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        long startTime = System.currentTimeMillis();
        String username = fromJID.getNode();
        String fromUserId = JIDUtil.conNodeToID(username);
        HashMap<String, Object> result = new HashMap<String, Object>();
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        String data = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)data);
        if (packet.getType().equals((Object)IQ.Type.get)) {
            targetType = json.getIntValue("targetType");
            isEM7 = json.get((Object)"isEM7") != null;
            targetId = json.getString("targetId");
            if (targetId != null && targetId.contains("s_assist") && targetType == 102) {
                targetType = 0;
            }
            lastTime = Long.parseLong(json.getString("lastTime"));
            pageSize = 10;
            endTime = 0L;
            if (json.containsKey((Object)"endTime")) {
                endTime = Long.parseLong(json.getString("endTime"));
            } else {
                pageSize = json.getIntValue("pageSize");
            }
        } else {
            Log.error("invalid iq type ,packet:{}", (Object)packet.toString());
            return null;
        }
        DatabaseUtil du = new DatabaseUtil();
        Map<String, Object> map = null;
        map = json.containsKey((Object)"endTime") ? du.getHisttroyMsgList(targetType, fromUserId, targetId, lastTime, endTime) : du.getHisttroyMsgList(targetType, fromUserId, targetId, lastTime, pageSize, fromJID.getResource());
        result.put("lastTime", map.get("lastTime"));
        result.put("history", du.reprocessHistoryMsgList(fromUserId, (List)map.get("history"), isEM7, fromJID.getResource()));
        ele.addText(JSON.toJSONString(result).toString());
        long endTime2 = System.currentTimeMillis();
        if (JiveGlobals.getBooleanProperty((String)"xmpp.recordMsgLog.enable", (boolean)false)) {
            Log.info("getHistoryMsg.success:fromUserId:{},params:{},result:{},cost:{} ms", new Object[]{fromJID, json, reply.toString(), endTime2 - startTime});
        }
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

