/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;

public class HistoryItemIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(HistoryItemIQHandler.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/historyitem");
    private final String HistoryItemNAMESPACE = "http://weaver.com.cn/historyitem";

    public HistoryItemIQHandler() {
        super("HistoryItemIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        if (packet.getFrom() == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        String data = packet.getElement().elementText("query");
        if (IQ.Type.get.equals((Object)packet.getType())) {
            JSONObject json = JSON.parseObject((String)data);
            String userId = JIDUtil.conNodeToID(packet.getFrom().getNode());
            String msgIds = null;
            if (json != null && json.containsKey((Object)"msgIds")) {
                msgIds = json.getString("msgIds");
            }
            ArrayList<String> msgIdList = new ArrayList<String>();
            if (msgIds != null && msgIds.contains(",")) {
                String[] jsonList;
                for (String s : jsonList = msgIds.split(",")) {
                    msgIdList.add(s);
                }
            } else {
                msgIdList.add(msgIds);
            }
            DatabaseUtil db = new DatabaseUtil();
            ArrayList<Map<String, String>> msgList = new ArrayList<Map<String, String>>();
            for (String msgId : msgIdList) {
                Map<String, String> resultMap = db.getMsgById(msgId, userId, true, packet.getFrom().getResource());
                if (resultMap == null || resultMap.isEmpty()) continue;
                msgList.add(resultMap);
            }
            IQ reply = IQ.createResultIQ((IQ)packet);
            Element elereply = reply.getElement();
            Element ele = elereply.addElement("query");
            HashMap<String, ArrayList<Map<String, String>>> result = new HashMap<String, ArrayList<Map<String, String>>>();
            result.put("history", msgList);
            ele.addText(JSON.toJSONString(result).toString());
            return reply;
        }
        return null;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

