/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cust.qmx.QMXUtil;
import com.weaver.util.WeiSouPropertiesUtil;
import com.weaver.util.emoji.WeiSouDataDecryptUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.dao.HistorySearchIQDao;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.DingUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import weaver.fullsearch.interfaces.service.MegSearch;

public class HistorySearchIQHandler
extends IQHandler {
    private static final Logger logger = LoggerFactory.getLogger(HistorySearchIQHandler.class);
    private IQHandlerInfo iqHandlerInfo = new IQHandlerInfo("query", this.namespace);
    private String namespace = "http://weaver.com.cn/history/search";
    public static final List<String> GRAY_BAR_TYPE = new ArrayList<String>();
    public static final List<String> FULL_AMOUNT_TYPE;

    public HistorySearchIQHandler() {
        super("HistorySearchIQHandler");
    }

    public IQHandlerInfo getInfo() {
        return this.iqHandlerInfo;
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        Map<Object, Object> map;
        JID fromJID = packet.getFrom();
        if (fromJID == null) {
            return null;
        }
        String userName = fromJID.getNode();
        String loginUserId = "";
        if (userName.contains("|")) {
            loginUserId = userName.substring(0, userName.indexOf("|"));
        }
        String elementText = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)elementText);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (packet.getType().equals((Object)IQ.Type.get)) {
            Integer pageSize;
            String fromUserId = json.getString("fromUserId");
            String targetId = json.getString("targetId");
            Integer targetType = json.getInteger("targetType");
            Integer pageNumber = json.getInteger("pageNumber");
            if (null == pageNumber) {
                pageNumber = 1;
            }
            if (null == (pageSize = json.getInteger("pageSize"))) {
                pageSize = 10;
            }
            if (targetId != null && targetId.contains("s_assist") && targetType == 102) {
                targetType = 1;
            }
            String groupId = "";
            if (targetType == 1 || targetType == 8 || targetType == 101 || targetType == 102 || targetType == 103 || targetType == 111) {
                groupId = fromUserId.compareToIgnoreCase(targetId) >= 0 ? targetId + "-" + fromUserId : fromUserId + "-" + targetId;
                if (targetType == 8 || targetType == 101 || targetType == 102 || targetType == 103 || targetType == 111) {
                    targetType = targetType + 1;
                }
            } else if (targetType == 2) {
                groupId = targetId;
            }
            String startTime = json.getString("startTime");
            String endTime = json.getString("endTime");
            if (endTime != null && !endTime.contains("23:59:59") && !endTime.isEmpty() && endTime.length() <= 12) {
                endTime = endTime + " 23:59:59";
            }
            String keyword = json.getString("keyword");
            String msgType = json.getString("msgType");
            if (msgType != null && !msgType.isEmpty() && msgType.contains("FW:LinkMsg") && !msgType.contains("FW:CustomShareMsg")) {
                msgType = msgType.endsWith(",") ? msgType + "FW:CustomShareMsg" : msgType + ",FW:CustomShareMsg";
            }
            String dataId = json.getString("dataId");
            String msgId = null;
            if (json != null && json.containsKey((Object)"msgId") && (dataId == null || dataId.isEmpty())) {
                msgId = json.getString("msgId");
                DatabaseUtil db = new DatabaseUtil();
                dataId = db.getDataIdByMsgId(msgId);
            }
            String orderType = json.getString("orderType");
            String senderId = null;
            if (json != null && json.containsKey((Object)"senderId")) {
                senderId = json.getString("senderId");
            }
            Long totalCount = null;
            map = new HashMap();
            WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
            boolean weiSouEnable = w.isWeiSouEnable();
            boolean msgSearchValidate = false;
            if (weiSouEnable) {
                msgSearchValidate = MegSearch.searchValidate((String)"MSGSEARCH");
            }
            if (weiSouEnable && msgSearchValidate) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("schemaType", "MSGSEARCH");
                if (StringUtils.isNotBlank((CharSequence)groupId)) {
                    paramMap.put("groupId", groupId);
                }
                if (null != pageNumber) {
                    paramMap.put("pageNumber", pageNumber);
                }
                if (null != pageSize) {
                    paramMap.put("pageSize", pageSize);
                }
                if (senderId != null && !senderId.isEmpty()) {
                    paramMap.put("fromUserId", senderId);
                }
                if (StringUtils.isNotBlank((CharSequence)startTime)) {
                    paramMap.put("startTime", startTime);
                }
                if (StringUtils.isNotBlank((CharSequence)endTime)) {
                    paramMap.put("endTime", endTime);
                }
                if (StringUtils.isNotBlank((CharSequence)keyword)) {
                    if (keyword.length() > 50) {
                        keyword = keyword.substring(0, 50);
                    }
                    paramMap.put("keyword", keyword);
                }
                paramMap.put("userid", loginUserId);
                if (StringUtils.isBlank((CharSequence)msgType)) {
                    msgType = StringUtils.isBlank((CharSequence)keyword) ? "RC:TxtMsg,RC:ImgMsg,RC:VcMsg,RC:LBSMsg,FW:attachmentMsg,FW:PersonCardMsg,FW:CMDMsg,FW:richTextMsg,FW:LinkMsg,FW:NewsMsg,FW:CustomShareMsg,FW:VoIPMsg,FW:Extension_Msg,RC:PublicNoticeMsg,FW:UniteMsg,RC:ExpMsg" : "RC:TxtMsg,FW:attachmentMsg,FW:CustomShareMsg";
                }
                paramMap.put("Classname", msgType);
                if (StringUtils.isNotBlank((CharSequence)dataId)) {
                    paramMap.put("dataId", dataId);
                    paramMap.put("pageNumber", 1);
                }
                HashMap<String, String> sortMap = new HashMap<String, String>();
                if (StringUtils.isNotBlank((CharSequence)orderType) && orderType.equals("1")) {
                    sortMap.put("Datetime", "true");
                } else {
                    sortMap.put("Datetime", "false");
                }
                HashMap aggMap = new HashMap();
                Map weiSouMap = MegSearch.search(paramMap, sortMap, aggMap);
                if (weiSouMap == null || !weiSouMap.containsKey("result")) {
                    logger.info("searchedHistory ,weiSouMap :{} ", (Object)weiSouMap);
                    if (weiSouMap != null && weiSouMap.containsKey("pageNumber")) {
                        pageNumber = (Integer)weiSouMap.get("pageNumber");
                        dataId = null;
                    }
                    if (weiSouMap != null && weiSouMap.containsKey("pageSize")) {
                        pageSize = (Integer)weiSouMap.get("pageSize");
                    }
                    if (weiSouMap != null && weiSouMap.containsKey("count")) {
                        totalCount = Long.parseLong(weiSouMap.get("count").toString());
                    }
                    if (totalCount == null || totalCount != 0L) {
                        logger.info("==============HistorySeach\u5fae\u641c\u5df2\u5f00\u542f\uff0c\u8d85\u8fc7\u5fae\u641c\u7d22\u5f15\u9650\u5236\u3002===================");
                        if (JiveGlobals.getBooleanProperty((String)"searchChatMsg", (boolean)true)) {
                            HistorySearchIQDao historySearchIQDao = new HistorySearchIQDao();
                            map = historySearchIQDao.searchHistoryMsg(loginUserId, fromUserId, targetId, targetType, pageNumber, pageSize, startTime, endTime, keyword, msgType, dataId, orderType, senderId, totalCount, fromJID.getResource());
                        } else {
                            map.put("pageNumber", weiSouMap.get("pageNumber"));
                            map.put("pageSize", weiSouMap.get("pageSize"));
                            map.put("totalCount", weiSouMap.get("count"));
                            map.put("searchedHistory", new ArrayList());
                        }
                    } else {
                        map.put("pageNumber", weiSouMap.get("pageNumber"));
                        map.put("pageSize", weiSouMap.get("pageSize"));
                        map.put("totalCount", weiSouMap.get("count"));
                        map.put("searchedHistory", new ArrayList());
                    }
                } else {
                    List<Map<String, Object>> searchedHistory = this.convertWeiSouToClient(weiSouMap, loginUserId, fromJID.getResource());
                    map.put("searchedHistory", searchedHistory);
                    map.put("pageNumber", weiSouMap.get("pageNumber"));
                    map.put("pageSize", weiSouMap.get("pageSize"));
                    map.put("totalCount", weiSouMap.get("count"));
                }
            } else {
                if (weiSouEnable && !msgSearchValidate) {
                    logger.info("==============HistorySeach\u5fae\u641c\u5df2\u5f00\u542f\uff0c\u5fae\u641c\u7d22\u5f15\u4e0d\u53ef\u7528\u3002===================");
                }
                HistorySearchIQDao historySearchIQDao = new HistorySearchIQDao();
                map = historySearchIQDao.searchHistoryMsg(loginUserId, fromUserId, targetId, targetType, pageNumber, pageSize, startTime, endTime, keyword, msgType, dataId, orderType, senderId, totalCount, fromJID.getResource());
            }
        } else {
            logger.error("\u975e\u6cd5\u7684iq\u8bf7\u6c42\u7c7b\u578b\uff0c\u5305\u5185\u5bb9\u4e3a\uff1a", (Object)packet.toString());
            return null;
        }
        result.put("searchedHistory", map.get("searchedHistory"));
        result.put("pageNumber", map.get("pageNumber"));
        result.put("pageSize", map.get("pageSize"));
        result.put("totalCount", map.get("totalCount"));
        IQ resultIq = IQ.createResultIQ((IQ)packet);
        Element element = resultIq.getElement().addElement("query");
        element.addText(JSON.toJSONString(result));
        if (JiveGlobals.getBooleanProperty((String)"xmpp.recordMsgLog.enable", (boolean)false)) {
            logger.info("HistorySearchIQHandler ,fromJID :{},json :{} ,resultIq:{} ", new Object[]{fromJID, json, resultIq});
        }
        return resultIq;
    }

    public List<Map<String, Object>> convertWeiSouToClient(Map<String, Object> weiSouMap, String loginUserId, String fromResource) {
        ArrayList<Map<String, Object>> searchedHistory = new ArrayList<Map<String, Object>>();
        List listResult = (List)weiSouMap.get("result");
        SimpleDateFormat SDF_SIMPLE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat SDF_ALL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (null != listResult) {
            for (int i = 0; i < listResult.size(); ++i) {
                String fullAmount;
                int ding_id;
                DingUtil dingUtil;
                Map mapWei = (Map)listResult.get(i);
                JSONObject mapAddIn = new JSONObject();
                mapAddIn.put("imgUrl", mapWei.get("imageUrl"));
                mapAddIn.put("msgType", (Object)this.getMsgTypeValueByName(mapWei.get("classname") == null ? "" : mapWei.get("classname").toString()));
                mapAddIn.put("targetid", mapWei.get("targetid"));
                mapAddIn.put("chatdivid", mapWei.get("targetid"));
                String extra = WeiSouDataDecryptUtil.parseToUnicode((String)((String)mapWei.get("extra")));
                mapAddIn.put("extra", (Object)extra);
                String objectName = (String)mapWei.get("objectName");
                mapAddIn.put("objectName", mapWei.get("objectName"));
                mapAddIn.put("targetType", (Object)String.valueOf(Integer.parseInt((String)mapWei.get("targetType")) - 1));
                mapAddIn.put("toUserid", mapWei.get("fromUserId"));
                String msgContent = WeiSouDataDecryptUtil.parseToUnicode((String)((String)mapWei.get("content")));
                mapAddIn.put("content", (Object)msgContent);
                mapAddIn.put("dataId", mapWei.get("dataId"));
                mapAddIn.put("timestamp", mapWei.get("msg_id"));
                if ("FW:CMDMsg".equals(objectName) && !(dingUtil = new DingUtil()).chechUserDing(loginUserId, ding_id = dingUtil.getDingIdByMessageContent(msgContent))) {
                    String newContent = dingUtil.getDingContent(msgContent);
                    mapAddIn.put("content", (Object)newContent);
                    mapAddIn.put("objectName", (Object)"RC:TxtMsg");
                }
                if (QMXUtil.isEnable((String)loginUserId) && "mobile".equals(fromResource)) {
                    JSONObject jsonExtra;
                    if ("RC:ImgMsg".equals(objectName)) {
                        mapAddIn.put("objectName", (Object)"RC:TxtMsg");
                        mapAddIn.put("content", (Object)QMXUtil.imgContent);
                        mapAddIn.put("imgUrl", (Object)"");
                        jsonExtra = JSONObject.parseObject((String)extra);
                        jsonExtra.put("imgUrl", (Object)"");
                        jsonExtra.put("fileid", (Object)"");
                        mapAddIn.put("extra", (Object)JSON.toJSONString((Object)jsonExtra));
                    }
                    if ("FW:attachmentMsg".equals(objectName)) {
                        mapAddIn.put("objectName", (Object)"RC:TxtMsg");
                        mapAddIn.put("content", (Object)QMXUtil.fileContent);
                        mapAddIn.put("imgUrl", (Object)"");
                        jsonExtra = JSONObject.parseObject((String)extra);
                        jsonExtra.put("imgUrl", (Object)"");
                        jsonExtra.put("fileid", (Object)"");
                        mapAddIn.put("extra", (Object)JSON.toJSONString((Object)jsonExtra));
                    }
                }
                if ((GRAY_BAR_TYPE.contains(objectName) || FULL_AMOUNT_TYPE.contains(objectName)) && (fullAmount = WeiSouDataDecryptUtil.parseToUnicode((String)((String)mapWei.get("fullAmount")))) != null && !fullAmount.isEmpty()) {
                    JSONObject fullAmountObj = JSONObject.parseObject((String)fullAmount);
                    for (String key : fullAmountObj.keySet()) {
                        if (mapAddIn.containsKey((Object)key)) continue;
                        mapAddIn.put(key, (Object)fullAmountObj.getString(key));
                    }
                }
                Long sendTime = null;
                if (null != mapWei.get("dateTime")) {
                    try {
                        String dateTime = mapWei.get("dateTime").toString();
                        sendTime = StringUtils.isNumeric((CharSequence)dateTime) ? Long.parseLong(dateTime) : (dateTime.length() == 19 ? SDF_SIMPLE.parse(dateTime).getTime() : SDF_ALL.parse(dateTime).getTime());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                HashMap<String, Object> mapAddOut = new HashMap<String, Object>();
                mapAddOut.put("opBody", mapAddIn.toString());
                mapAddOut.put("sendTime", sendTime);
                mapAddOut.put("targetId", mapWei.get("targetid"));
                mapAddOut.put("fromUserId", mapWei.get("fromUserId"));
                searchedHistory.add(mapAddOut);
            }
        }
        return searchedHistory;
    }

    private int getMsgTypeValueByName(String name) {
        int result = 6;
        if ("RC:TxtMsg".equals(name)) {
            result = 1;
        } else if ("RC:ImgMsg".equals(name)) {
            result = 2;
        } else if ("RC:VcMsg".equals(name)) {
            result = 3;
        } else if ("RC:LBSMsg".equals(name)) {
            result = 8;
        }
        return result;
    }

    static {
        GRAY_BAR_TYPE.add("RC:DizNtf");
        GRAY_BAR_TYPE.add("RC:InfoNtf");
        GRAY_BAR_TYPE.add("FW:InfoNtf");
        GRAY_BAR_TYPE.add("RC:InfoNtfVote");
        FULL_AMOUNT_TYPE = new ArrayList<String>();
        FULL_AMOUNT_TYPE.add("RC:VcMsg");
        FULL_AMOUNT_TYPE.add("RC:LBSMsg");
    }
}

