/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class MsgReadIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(MsgReadIQHandler.class);
    private static final String MSGREAD_NAMESPACE = "http://weaver.com.cn/getMsgRead";
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/getMsgRead");

    public MsgReadIQHandler() {
        super("MsgReadIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID fromJID = packet.getFrom();
        if (packet.getFrom() == null) {
            Log.warn("MsgReadIQHandler from is null.packet:{}", (Object)packet.toString());
            return null;
        }
        if (!IQ.Type.get.equals((Object)packet.getType())) {
            Log.warn("MsgReadIQHandler type is not get.packet:{}", (Object)packet.toString());
            return null;
        }
        long startTime = System.currentTimeMillis();
        String data = packet.getElement().elementText("query");
        JSONArray jsonMsgIdArray = JSON.parseArray((String)data);
        DatabaseUtil db = new DatabaseUtil();
        Map<String, Object> result = db.getMsgRead(jsonMsgIdArray);
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        String str = JSON.toJSONString(result).toString();
        ele.addText(str);
        long endTime = System.currentTimeMillis();
        Log.info("MsgReadIQHandler success.fromJID:{},params:{},cost:{} ms", new Object[]{fromJID, jsonMsgIdArray, endTime - startTime});
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

