/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class MsgReadInfoIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(MsgReadInfoIQHandler.class);
    private static final String MSGREAD_NAMESPACE = "http://weaver.com.cn/getMsgReadInfo";
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/getMsgReadInfo");

    public MsgReadInfoIQHandler() {
        super("MsgReadInfoIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        Map<Object, Object> result = new HashMap();
        JID fromJID = packet.getFrom();
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elementReply = reply.getElement();
        Element ele = elementReply.addElement("query");
        if (fromJID == null) {
            ele.addText("fromJID is null");
            Log.error("MsgReadInfoIQHandler,fromJID is null,packt ={}", (Object)packet.toString());
        } else {
            JSONObject json = JSONObject.parseObject((String)packet.getElement().elementText("query"));
            String method = (String)json.get((Object)"method");
            DatabaseUtil du = new DatabaseUtil();
            if (IQ.Type.get.equals((Object)packet.getType())) {
                String userid = JIDUtil.conNodeToID(fromJID.getNode());
                HashSet<String> msgids = new HashSet<String>();
                Object msgidsFromJson = json.get((Object)"msgids");
                if (msgidsFromJson != null) {
                    msgids.addAll(Arrays.asList(json.get((Object)"msgids").toString().split(",")));
                    result = du.getMsgReadInfo(msgids, userid);
                }
            }
            ele.addText(JSON.toJSONString(result).toString());
            if (JiveGlobals.getBooleanProperty((String)"xmpp.recordMsgLog.enable", (boolean)false)) {
                Log.info("MsgReadInfoIQHandler,msgids:{},result:{}.from:{},Completed", new Object[]{json.get((Object)"msgids").toString(), result, fromJID});
            }
        }
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

