/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.Collection;
import java.util.HashMap;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.push.PushDbUtil;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class OnlineStatusIQHandle
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(OnlineStatusIQHandle.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", this.ISONLINE_XMLNS);
    private String ISONLINE_XMLNS = "http://weaver.com.cn/isOnline";

    public OnlineStatusIQHandle() {
        super("OnlineStatusIQHandle");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        boolean routeTargetIsInline;
        if (packet.getFrom() == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        if (packet.getType().equals((Object)IQ.Type.get)) {
            ClusterRedisUtil clusterRedisUtil;
            String pcClusterNode;
            JID fJID = new JID(packet.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            routeTargetIsInline = false;
            Collection sessions = this.sessionManager.getSessions(fJID.getNode());
            for (ClientSession clientSession : sessions) {
                if (!fJID.getResource().equals(clientSession.getAddress().getResource())) continue;
                routeTargetIsInline = true;
                PushDbUtil du = new PushDbUtil();
                PushDevice pd = null;
                pd = JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false) ? du.getRegisterPush(packet.getFrom(), packet.getFrom().getResource()) : du.getRegisterPush(packet.getFrom());
                String pushStatus = null;
                if (pd != null && ((pushStatus = pd.getPushStatus()) == null || pushStatus.equals(""))) {
                    pushStatus = JiveGlobals.getProperty((String)"pushStatus", (String)"0");
                }
                result.put("pushStatus", pushStatus);
            }
            ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
            if (!routeTargetIsInline && clusterPropBeanUtil.isUseCluster() && (pcClusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(fJID)) != null && !pcClusterNode.isEmpty()) {
                routeTargetIsInline = true;
                PushDbUtil du = new PushDbUtil();
                PushDevice pd = null;
                pd = JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false) ? du.getRegisterPush(packet.getFrom(), packet.getFrom().getResource()) : du.getRegisterPush(packet.getFrom());
                String pushStatus = null;
                if (pd != null && ((pushStatus = pd.getPushStatus()) == null || pushStatus.equals(""))) {
                    pushStatus = JiveGlobals.getProperty((String)"pushStatus", (String)"0");
                }
                result.put("pushStatus", pushStatus);
            }
        } else {
            Log.error("handleIQ,packet type is not get ,packet:{}", (Object)packet.toString());
            return null;
        }
        result.put("isOnline", routeTargetIsInline);
        Log.info("OnlineStatusIQHandle,fromJID:{}, :{} ", (Object)packet.getFrom().toString(), (Object)JSON.toJSONString(result).toString());
        ele.addText(JSON.toJSONString(result).toString());
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

