/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import javapns.devices.Device;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.push.PushKitThread;
import org.jivesoftware.openfire.plugin.push.PushMessageForIOS;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class PushKitMessageIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(PushKitMessageIQHandler.class);
    private static final String PUSHKIT_MESSAGE_NAMESPACE = "http://weaver.com.cn/pushKitMessage";
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/pushKitMessage");
    private static long jpushTimeToLive = JiveGlobals.getLongProperty((String)"jpush.time.to.live.second", (long)86400L);

    public PushKitMessageIQHandler() {
        super("PushKitMessageIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID fromJID = packet.getFrom();
        if (fromJID == null) {
            Log.warn("PushKitMessageIQHandler,from is null.packet:{}", (Object)packet.toString());
            return null;
        }
        if (!IQ.Type.set.equals((Object)packet.getType())) {
            Log.warn("PushKitMessageIQHandler,type is not set.packet:{}", (Object)packet.toString());
            return null;
        }
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        String data = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)data);
        String alert = json.getString("alert");
        JSONArray userJSONArray = json.getJSONArray("userList");
        String content = null;
        if (json != null && json.containsKey((Object)"iVContent")) {
            content = json.getString("iVContent");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        PushKitThread p = new PushKitThread(userJSONArray, alert, content);
        p.start();
        result.put("result", "success");
        ele.addText(JSON.toJSONString(result).toString());
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    private static void pushMessageForIOS(JPushClient jpushClient, String deviceToken, String pushContent, String pushType) {
        if (jpushClient == null) {
            jpushClient = PushMessageForIOS.getJpushClient(pushType);
        }
        if (jpushClient == null) {
            Log.warn("unkown pushType no push.pushContent:{},deviceToken:{},pushType:{}", new Object[]{pushContent, deviceToken, pushType});
            return;
        }
        PushResult result = null;
        try {
            PushPayload ppl = PushKitMessageIQHandler.getPushPayload(deviceToken, pushContent);
            if ("101".equals(pushType) && PushMessageForIOS.jpushClientForCustomized != null) {
                PushMessageForIOS.jpushClientForCustomized.sendPush(ppl);
            }
            result = jpushClient.sendPush(ppl);
            Log.info("pushMessageForIOS,pushContent:{},pushType:{},result:{}", new Object[]{pushContent, pushType, JSON.toJSON((Object)result).toString()});
        }
        catch (Exception e) {
            Log.error("pushMessageForIOS,pushContent:{},pushType:{},error:{}", new Object[]{pushContent, pushType, e.getMessage()});
        }
    }

    private static String getVoipPayLoad(String deviceToken, String pushContent) {
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        ArrayList<String> platform = new ArrayList<String>();
        platform.add("ios");
        map.put("platform", platform);
        ArrayList<String> registration_id = new ArrayList<String>();
        registration_id.add(deviceToken);
        HashMap<String, ArrayList<String>> audience = new HashMap<String, ArrayList<String>>();
        audience.put("registration_id", registration_id);
        map.put("audience", audience);
        HashMap<String, Object> ios = new HashMap<String, Object>();
        ios.put("alert", pushContent);
        ios.put("sound", "call.caf");
        ios.put("content-available", true);
        ios.put("mutable-content", true);
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("key1", "value1");
        ios.put("extras", extras);
        HashMap notification = new HashMap();
        notification.put("ios", ios);
        HashMap<String, String> voip = new HashMap<String, String>();
        voip.put("key", "value");
        notification.put("voip", voip);
        map.put("notification", notification);
        HashMap<String, Constable> options = new HashMap<String, Constable>();
        options.put("time_to_live", Long.valueOf(jpushTimeToLive));
        options.put("apns_production", Boolean.valueOf(false));
        map.put("options", options);
        return JSON.toJSONString(map);
    }

    private static PushPayload getPushPayload(String deviceToken, String pushContent) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("isVibrate", "1");
        boolean apnsProduction = JiveGlobals.getBooleanProperty((String)"apnsProduction", (boolean)true);
        PushPayload payload = null;
        payload = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.registrationId((String[])new String[]{deviceToken})).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)pushContent).setSound("call.caf").addExtras(para)).setMutableContent(true).setContentAvailable(true).build()).build()).setOptions(Options.newBuilder().setApnsProduction(apnsProduction).setTimeToLive(jpushTimeToLive).build()).build();
        return payload;
    }

    public static void main(String[] args) {
    }

    private static boolean pushToPushKitForEmobile7AppStore(String alert, PushDevice pd) {
        String certificatePath = JiveGlobals.getHomeDirectory() + File.separator + "plugins" + File.separator + "multirouter" + File.separator + "voip" + File.separator + "101" + File.separator + "voip.p12";
        String certificatePassword = "weaverqaz";
        PushNotificationManager pushManager = new PushNotificationManager();
        PushNotificationPayload payLoad = new PushNotificationPayload();
        try {
            pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)certificatePath, certificatePassword, true));
            payLoad.addAlert(alert);
            payLoad.addBadge(1);
            payLoad.addSound("default");
            BasicDevice device = new BasicDevice();
            device.setToken(pd.getPushKitDeviceToken());
            PushedNotification notification = pushManager.sendNotification((Device)device, (Payload)payLoad, true);
            Log.info("push result:{}", (Object)notification.toString());
            pushManager.stopConnection();
        }
        catch (Exception e) {
            Log.error("pushToPushKitForEmobile7AppStore,error:{},pushConent:{}", (Object)e.getMessage(), (Object)alert);
            return false;
        }
        return true;
    }

    private static void pushToPushKitForEmobile7AppTest(String alert, PushDevice pd) {
        String certificatePath = JiveGlobals.getHomeDirectory() + File.separator + "plugins" + File.separator + "multirouter" + File.separator + "voip" + File.separator + "106" + File.separator + "voip.p12";
        String certificatePassword = "weaverqaz";
        PushNotificationManager pushManager = new PushNotificationManager();
        PushNotificationPayload payLoad = new PushNotificationPayload();
        try {
            pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)certificatePath, certificatePassword, true));
            payLoad.addAlert(alert);
            payLoad.addBadge(1);
            payLoad.addSound("default");
            BasicDevice device = new BasicDevice();
            device.setToken(pd.getPushKitDeviceToken());
            PushedNotification notification = pushManager.sendNotification((Device)device, (Payload)payLoad, true);
            Log.info("push result:{}", (Object)notification.toString());
            pushManager.stopConnection();
        }
        catch (Exception e) {
            Log.error("pushToPushKitForEmobile7AppTest,error:{},pushConent:{}", (Object)e.getMessage(), (Object)alert);
        }
    }

    private static void pushToPushKit(String alert, PushDevice pd) {
        String certificatePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "voip.p12";
        String certificatePassword = JiveGlobals.getProperty((String)"pushKitSecret", (String)"weaverqaz");
        File file = new File(certificatePath);
        if (!file.exists() || certificatePassword == null || certificatePassword.isEmpty()) {
            Log.info("pushToPushKit .p12 file not exists or password is null .alert:{},pd:{}", (Object)alert, (Object)JSON.toJSONString((Object)pd));
            return;
        }
        PushNotificationManager pushManager = new PushNotificationManager();
        PushNotificationPayload payLoad = new PushNotificationPayload();
        try {
            pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)certificatePath, certificatePassword, true));
            payLoad.addAlert(alert);
            payLoad.addBadge(1);
            payLoad.addSound("default");
            BasicDevice device = new BasicDevice();
            device.setToken(pd.getPushKitDeviceToken());
            PushedNotification notification = pushManager.sendNotification((Device)device, (Payload)payLoad, true);
            Log.info("push result:{}", (Object)notification.toString());
            pushManager.stopConnection();
        }
        catch (Exception e) {
            Log.error("pushToPushKit,error:{},pushConent:{}", (Object)e.getMessage(), (Object)alert);
        }
    }
}

