/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.push.PushDbUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class PushRegisterIQHandle
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(PushRegisterIQHandle.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", this.PUSHREGISTER_XMLNS);
    private String PUSHREGISTER_XMLNS = "http://weaver.com.cn/pushRegister";

    public PushRegisterIQHandle() {
        super("PushRegisterIQHandle");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        PushDbUtil du;
        PushDevice pd;
        JID fromJID;
        Log.debug("handlerIQ,packet={}", (Object)packet.toString());
        if (packet.getFrom() == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        IQ reply = IQ.createResultIQ((IQ)packet);
        String data = packet.getElement().elementText("query");
        if (packet.getType().equals((Object)IQ.Type.set)) {
            JSONObject json = JSON.parseObject((String)data);
            fromJID = packet.getFrom();
            String token = (String)json.get((Object)"token");
            if (token == null || token.isEmpty()) {
                token = "-1";
                Log.warn("registerPush, token is empty, from:{}", (Object)fromJID.getNode());
            }
            String type = (String)json.get((Object)"type");
            pd = new PushDevice();
            pd.setToken(token);
            pd.setType(type);
            String language = null;
            if (json.containsKey((Object)"language")) {
                language = json.getString("language");
            }
            String pushKitDeviceToken = null;
            if (json.containsKey((Object)"pushKitDeviceToken")) {
                pushKitDeviceToken = json.getString("pushKitDeviceToken");
            }
            pd.setPushKitDeviceToken(pushKitDeviceToken);
            String mobileVersion = null;
            if (json.containsKey((Object)"mobileVersion")) {
                mobileVersion = json.getString("mobileVersion");
            }
            if (mobileVersion != null && mobileVersion.length() > 2) {
                mobileVersion = "7";
            }
            String isHarmonyOs = null;
            if (json.containsKey((Object)"isHarmonyOs")) {
                isHarmonyOs = json.getString("isHarmonyOs");
            }
            if ("1".equals(isHarmonyOs)) {
                mobileVersion = "0";
            }
            String packageName = null;
            if (json.containsKey((Object)"packageName")) {
                packageName = json.getString("packageName");
            }
            pd.setMobileVersion(mobileVersion);
            pd.setLanguage(language);
            pd.setPackageName(packageName);
            du = new PushDbUtil();
            Log.info("registerPush from:{},json:{}", (Object)fromJID.toString(), (Object)json);
            if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
                pd.setUserType(fromJID.getResource());
            }
        } else {
            Log.error("registerPush type is not set,packet={}", (Object)packet.toString());
            return null;
        }
        du.registerPush(fromJID, pd);
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

