/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.user.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class PushSettingIQHandle
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(PushSettingIQHandle.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", this.PUSHSETTING_XMLNS);
    private String PUSHSETTING_XMLNS = "http://weaver.com.cn/pushSetting";
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    public PushSettingIQHandle() {
        super("PushSettingIQHandle");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        if (packet.getFrom() == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        JID fromJID = packet.getFrom();
        String data = packet.getElement().elementText("query");
        if (packet.getType().equals((Object)IQ.Type.set)) {
            JSONObject json = JSON.parseObject((String)data);
            String targetType = (String)json.get((Object)"targetType");
            String targetId = (String)json.get((Object)"targetId");
            String pushValue = (String)json.get((Object)"pushValue");
            this.setPushValue(targetId, targetType, fromJID, pushValue);
            result.put("targetId", targetId);
            result.put("pushValue", pushValue);
        } else {
            JSONObject json = JSON.parseObject((String)data);
            String targetType = null;
            if (json != null && json.containsKey((Object)"targetType")) {
                targetType = (String)json.get((Object)"targetType");
            }
            String targetId = null;
            if (json != null && json.containsKey((Object)"targetId")) {
                targetId = (String)json.get((Object)"targetId");
            }
            String targetIds = null;
            if (json != null && json.containsKey((Object)"targetIds")) {
                targetIds = json.getString("targetIds");
            }
            if (targetType == null && targetId == null) {
                List<Map<String, String>> list = this.getPushValues(fromJID);
                result.put("nopushUsers", list);
            } else if (targetIds != null) {
                String[] arrTargetIds = targetIds.split(",");
                for (int i = 0; i < arrTargetIds.length; ++i) {
                    String type = "";
                    String string = this.getPushValue(targetId, targetType, fromJID);
                }
            } else {
                String pushValue = this.getPushValue(targetId, targetType, fromJID);
                result.put("pushValue", pushValue);
            }
            result.put("targetId", targetId);
        }
        ele.addText(JSON.toJSONString(result).toString());
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    public void setPushValue(String targetId, String targetType, JID fromJID, String pushValue) {
        DatabaseUtil du = new DatabaseUtil();
        du.setPushSetting(targetId, targetType, fromJID.getNode(), pushValue);
    }

    public String getPushValue(String targetId, String targetType, JID fromJID) {
        DatabaseUtil du = new DatabaseUtil();
        return du.getPushSetting(targetId, targetType, fromJID.getNode());
    }

    public List<Map<String, String>> getPushValues(JID fromJID) {
        ArrayList<Map<String, String>> list = new ArrayList();
        DatabaseUtil du = new DatabaseUtil();
        list = du.getPushSesstings(fromJID.getNode());
        return list;
    }
}

