/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.weaver.cache.redis.RedisPoolMgr;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.push.PushDbUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class PushUnregisterIQHandle
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(PushUnregisterIQHandle.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", this.PUSHREGISTER_XMLNS);
    private String PUSHREGISTER_XMLNS = "http://weaver.com.cn/pushUnregister";

    public PushUnregisterIQHandle() {
        super("PushUnregisterIQHandle");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID fromJID = packet.getFrom();
        if (fromJID == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        IQ reply = IQ.createResultIQ((IQ)packet);
        if (packet.getType().equals((Object)IQ.Type.set)) {
            PushDbUtil du = new PushDbUtil();
            du.unregisterPush(fromJID);
        }
        this.delMobileOnlineStatus(fromJID);
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    private boolean delMobileOnlineStatus(JID jid) {
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr == null) {
            Log.warn("redis is not install or redis error.");
            return false;
        }
        try {
            String key = "mobile_presence_" + jid.toString();
            redisPoolMgr.del(key);
        }
        catch (Exception e) {
            Log.error("delete Mobile Presence error.jid:{}", (Object)jid);
            return false;
        }
        return true;
    }
}

