/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dom4j.Element;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;

public class UniteMsgIQHandler
extends IQHandler {
    private IQHandlerInfo info = new IQHandlerInfo("query", this.UNITEMSG_XMLNS);
    private String UNITEMSG_XMLNS = "http://weaver.com.cn/uniteMsg";
    private static final Logger Log = LoggerFactory.getLogger(UniteMsgIQHandler.class);

    public UniteMsgIQHandler() {
        super("UniteMsgIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        if (packet.getFrom() == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        String data = packet.getElement().elementText("query");
        if (IQ.Type.set.equals((Object)packet.getType())) {
            try {
                JSONObject json = JSON.parseObject((String)data);
                String uniteMsgId = this.uniteMsgIDUtil();
                String msgIds = null;
                if (json != null && json.containsKey((Object)"msgIds")) {
                    msgIds = json.getString("msgIds");
                }
                IQ reply = IQ.createResultIQ((IQ)packet);
                if (uniteMsgId != null && msgIds != null) {
                    while (UniteMsgIQHandler.checkUniteMsgId(uniteMsgId)) {
                        uniteMsgId = this.uniteMsgIDUtil();
                    }
                    boolean result = UniteMsgIQHandler.saveUniteMsgData(uniteMsgId, msgIds);
                    if (result) {
                        Element elereply = reply.getElement();
                        Element ele = elereply.addElement("query");
                        HashMap<String, String> resultMap = new HashMap<String, String>();
                        resultMap.put("code", "200");
                        resultMap.put("uniteMsgId", uniteMsgId);
                        ele.addText(JSON.toJSONString(resultMap).toString());
                        return reply;
                    }
                    Element elereply = reply.getElement();
                    Element ele = elereply.addElement("query");
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("code", "500");
                    ele.addText(JSON.toJSONString(resultMap).toString());
                    return reply;
                }
                Log.info("UniteMsgIQHandler,data is null,data:{}", (Object)data);
                Element elereply = reply.getElement();
                Element ele = elereply.addElement("query");
                reply.setType(IQ.Type.error);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", "404");
                resultMap.put("reason", "UniteMsgIQHandler,data is null");
                ele.addText(JSON.toJSONString(resultMap).toString());
            }
            catch (Exception e) {
                Log.error("UniteMsgIQHandler .error:{} data:{}", (Object)e.getMessage(), (Object)data);
                IQ error = IQ.createResultIQ((IQ)packet);
                Element elereply = error.getElement();
                Element ele = elereply.addElement("query");
                error.setType(IQ.Type.error);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", "500");
                resultMap.put("reason", "service error");
                ele.addText(JSON.toJSONString(resultMap).toString());
                return error;
            }
        } else if (IQ.Type.get.equals((Object)packet.getType())) {
            JSONObject json = JSON.parseObject((String)data);
            String uniteMsgId = null;
            if (json != null && json.containsKey((Object)"uniteMsgId")) {
                uniteMsgId = json.getString("uniteMsgId");
            }
            if (uniteMsgId == null || uniteMsgId.isEmpty()) {
                Log.info("uniteMsgId is null,data:{}", (Object)data);
                IQ reply = IQ.createResultIQ((IQ)packet);
                reply.setType(IQ.Type.error);
                Element elereply = reply.getElement();
                Element ele = elereply.addElement("query");
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", "404");
                resultMap.put("reason", "uniteMsgId is null");
                ele.addText(JSON.toJSONString(resultMap).toString());
                return reply;
            }
            IQ reply = IQ.createResultIQ((IQ)packet);
            Element elereply = reply.getElement();
            Element ele = elereply.addElement("query");
            List<String> msgIdList = UniteMsgIQHandler.getUniteMsgIds(uniteMsgId);
            if (msgIdList == null || msgIdList.size() <= 0) {
                return reply;
            }
            ArrayList<Map<String, String>> msgList = new ArrayList<Map<String, String>>();
            String userId = JIDUtil.conNodeToID(packet.getFrom().getNode());
            DatabaseUtil db = new DatabaseUtil();
            for (String msgId : msgIdList) {
                Map<String, String> resultMap = db.getMsgById(msgId, userId, true, packet.getFrom().getResource());
                if (resultMap == null || resultMap.isEmpty()) continue;
                msgList.add(resultMap);
            }
            Collections.sort(msgList, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> o1, Map<String, String> o2) {
                    long t1 = 0L;
                    long t2 = 0L;
                    try {
                        t1 = Long.parseLong(o1.get("sendTime"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        t2 = Long.parseLong(o2.get("sendTime"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (t2 < t1) {
                        return 1;
                    }
                    if (t2 == t1) {
                        return 0;
                    }
                    return -1;
                }
            });
            HashMap<String, ArrayList<Map<String, String>>> result = new HashMap<String, ArrayList<Map<String, String>>>();
            result.put("history", msgList);
            ele.addText(JSON.toJSONString(result).toString());
            return reply;
        }
        return null;
    }

    private String uniteMsgIDUtil() {
        String uuid = UUID.randomUUID().toString();
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getUniteMsgIds(String uniteMsgId) {
        JSONArray jsonList;
        ArrayList<String> list = new ArrayList<String>();
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        String strValue = null;
        if (redisPoolMgr != null) {
            strValue = redisPoolMgr.get("uinteMsg:" + uniteMsgId);
        }
        if (strValue == null || strValue.isEmpty()) {
            Connection con = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from ofunitemsginfo where uniteMsgId = ? ");
                pstmt.setString(1, uniteMsgId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    strValue = rs.getString("msgIds");
                }
            }
            catch (SQLException e) {
                try {
                    Log.error("getUniteMsgIds .error :{} ,uniteMsgId : {}", (Object)e.getMessage(), (Object)uniteMsgId);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        if ((jsonList = JSONArray.parseArray((String)strValue)) != null) {
            for (Object s : jsonList) {
                list.add((String)s);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkUniteMsgId(String uniteMsgId) {
        boolean uniteMsg = false;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select * from ofunitemsginfo where uniteMsgId = ? ");
            pstmt.setString(1, uniteMsgId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Log.info("checkUniteMsgId uniteMsgId MsgId exist.uniteMsgId :{} ", (Object)uniteMsgId);
                uniteMsg = true;
            }
        }
        catch (SQLException e) {
            try {
                Log.error("checkUniteMsgId .error :{} ,uniteMsgId : {}", (Object)e.getMessage(), (Object)uniteMsgId);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return uniteMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveUniteMsgData(String uniteMsgId, String msgIds) {
        RedisPoolMgr redisPoolMgr;
        Log.info("saveUniteMsgData . uniteMsgId :{} ,msgIds :{} ", (Object)uniteMsgId, (Object)msgIds);
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean needRecordToRedis = false;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("insert into ofunitemsginfo (uniteMsgId,msgIds) values(?,?) ");
            pstmt.setString(1, uniteMsgId);
            pstmt.setString(2, msgIds);
            pstmt.executeUpdate();
            needRecordToRedis = true;
        }
        catch (SQLException e) {
            boolean bl;
            try {
                Log.error("saveUinteMsgDate error: {} ,uniteMsgId : {} ,msgIds : {}", new Object[]{e.getMessage(), uniteMsgId, msgIds});
                bl = false;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            return bl;
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        if (needRecordToRedis && (redisPoolMgr = RedisPoolMgr.getInstance()) != null) {
            Log.info("saveUniteMsgDataToRedis . uniteMsgId :{} ,msgIds :{} ", (Object)uniteMsgId, (Object)msgIds);
            redisPoolMgr.setex("uinteMsg:" + uniteMsgId, msgIds, 172800);
        }
        return true;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

