/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.TimerTaskUtil;

import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.ThreadPrefix;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.jivesoftware.openfire.plugin.push.PushMessageThread;
import org.jivesoftware.openfire.plugin.util.PushMessageInitUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushMessageThreadInitTimerTask
extends TimerTask {
    private static final Logger Log = LoggerFactory.getLogger(PushMessageThreadInitTimerTask.class);
    private ExecutorService fixedThreadPool = ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool();

    @Override
    public void run() {
        Log.info("PushMessageThreadInitTimerTask running.");
        if (!PushMessageInitUtil.isPushMessageThreadRunning) {
            PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
            boolean pushMessageClientInitSuccess = pmiu.initPush();
            if (pushMessageClientInitSuccess) {
                PushMessageInitUtil.isPushMessageThreadRunning = true;
                for (int i = 0; i < JiveGlobals.getIntProperty((String)"pushMessageThreadCount", (int)40); ++i) {
                    this.fixedThreadPool.execute(new PushMessageThread(ThreadPrefix.PUSH_THREAD.toString() + i + "-" + this.getClass().getSimpleName()));
                }
                Log.info("PushMessageThreadInitTimerTask pushSet is open and pushThread is not running.not start push thread.");
                this.cancel();
            } else {
                Log.error("PushMessageThreadInitTimerTask push message client init failed.no push.");
            }
        } else {
            Log.info("PushMessageThreadInitTimerTask. running .not need to check.");
            this.cancel();
        }
        Log.info("PushMessageThreadInitTimerTask end.");
    }
}

