/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.TimerTaskUtil;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransHistoryMsgRecentlyTimerTask
extends TimerTask {
    private static final Logger Log = LoggerFactory.getLogger(TransHistoryMsgRecentlyTimerTask.class);
    private static int id = 0;

    @Override
    public void run() {
        if (!JiveGlobals.getBooleanProperty((String)"xmpp.social_hisotymsgrecentlyright.save", (boolean)false)) {
            id = JiveGlobals.getIntProperty((String)"xmpp.social_hisotymsgrecentlyright.saveId", (int)0);
            List<Object> msgs = new ArrayList();
            while ((msgs = this.getList()).size() > 0) {
                for (Map map : msgs) {
                    String groupId = (String)map.get("msgId");
                    String dateTime = (String)map.get("datetime");
                    String msgId = (String)map.get("msgId");
                    List<String> userIds = this.getUserMsgIdRight(msgId);
                    if (userIds == null || userIds.size() <= 0) continue;
                    this.recordMsgRight(groupId, dateTime, msgId, userIds);
                }
                JiveGlobals.setProperty((String)"xmpp.social_hisotymsgrecentlyright.saveId", (String)String.valueOf(id));
            }
            JiveGlobals.setProperty((String)"xmpp.social_hisotymsgrecentlyright.save", (String)String.valueOf(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordMsgRight(String groupId, String dateTime, String msgId, List<String> userIds) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("INSERT INTO Social_historyMsgRecentlyRight (userId, msgId,isdel,datetime,groupId) VALUES (?,?,?,?,?)");
            for (String userId : userIds) {
                pstmt.setString(1, userId);
                pstmt.setString(2, msgId);
                pstmt.setString(3, "0");
                pstmt.setString(4, dateTime);
                pstmt.setString(5, groupId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
        }
        catch (SQLException e) {
            try {
                Log.error("recordMsgRight ,error :{} .groupId:{},dateTime:{},msgId:{},userIds:{},e :{} ", new Object[]{e.getMessage(), groupId, dateTime, msgId, userIds, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserMsgIdRight(String msgId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> userRight = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select DISTINCT userId from Social_historyMsgRight where msgId = ? and (isdel is null or isdel <> '1') ");
            pstmt.setString(1, msgId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                set.add(rs.getString("userId"));
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getUserMsgIdRight,msgId:{},error:{}", (Object)msgId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        userRight.addAll(set);
        return userRight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> getList() {
        String sql = "";
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        sql = DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) ? " select top(1000) id,fromUserId,targetId,targetType,GroupId,msgId,datetime from historyMsgRecently where id > ? AND targetType in(1,2) order by id " : (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) ? " select id,fromUserId,targetId,targetType,GroupId,msgId,datetime from historyMsgRecently where id > ? AND targetType in(1,2) order by id limit 1000  " : "SELECT * FROM (SELECT id,fromUserId,targetId,targetType,GroupId,msgId,datetime FROM historyMsgRecently WHERE id > ? AND targetType in(1,2) ORDER BY id)a WHERE rownum < 1000 ");
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setInt(1, id);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, String> msgs = new HashMap<String, String>();
                id = rs.getInt("id");
                msgs.put("groupId", rs.getString("GroupId"));
                msgs.put("msgId", rs.getString("msgId"));
                msgs.put("datetime", rs.getString("datetime"));
                result.add(msgs);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getList :{} ,id :{} ,e :{} ", new Object[]{e.getMessage(), id, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }
}

