/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.TimerTaskUtil;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TimerTask;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.cache.MsgReadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransMsgReadFromRedisToDB
extends TimerTask {
    private static final Logger Log = LoggerFactory.getLogger(TransMsgReadFromRedisToDB.class);
    private String SELECT_MSGREADSTATUS = "select id from social_IMMsgRead where msgid = ? and receiverid = ?";
    private String UPDATA_MSGREADSTATUS = "UPDATE social_IMMsgRead set status=0,sendtime= ?  where msgid = ? and receiverid = ?";
    private String INSERT_MSGREADSTATUS = "insert into social_IMMsgRead(msgid,receiverid,status,userid,sendtime) values(?,?,0,?,?)";

    @Override
    public void run() {
        Log.info("TransMsgReadFromRedisToDB timerTask.running...");
        MsgReadUtil msgReadUtil = MsgReadUtil.getInstance();
        if (msgReadUtil == null) {
            Log.warn("redis con not to connection.stop to trans msgread data.");
            return;
        }
        long msgReadCount = msgReadUtil.getMsgReadQueueCount();
        if (msgReadCount == 0L) {
            Log.info("no data need to trans..");
            return;
        }
        Log.info("now start to trans msgread data.conut:{}", (Object)msgReadCount);
        if (msgReadCount <= 100L) {
            Set<String> result = msgReadUtil.getMsgReadQueue(0L, msgReadCount - 1L);
            this.writeMsgReadDataToDb(result);
            msgReadUtil.removeMsgReadQueue(0L, msgReadCount - 1L);
        } else {
            long times = msgReadCount / 100L;
            int i = 0;
            while ((long)i < times) {
                Set<String> result = msgReadUtil.getMsgReadQueue(0L, 99L);
                this.writeMsgReadDataToDb(result);
                msgReadUtil.removeMsgReadQueue(0L, result.size() - 1);
                ++i;
            }
        }
        Log.info("trans msgread data end.msgreadCount:{}", (Object)msgReadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMsgReadDataToDb(Set<String> result) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        SimpleDateFormat SDF_SIMPLE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sendtime = SDF_SIMPLE.format(new Date());
        try {
            con = DbConnectionManager.getConnection();
            for (String jsonStr : result) {
                JSONObject json = JSON.parseObject((String)jsonStr);
                if (!json.containsKey((Object)"msgid") || !json.containsKey((Object)"userid")) continue;
                String msgid = json.getString("msgid");
                int userid = json.getIntValue("userid");
                pstmt = con.prepareStatement(this.SELECT_MSGREADSTATUS);
                pstmt.setString(1, msgid);
                pstmt.setInt(2, userid);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(this.UPDATA_MSGREADSTATUS);
                    pstmt.setString(1, sendtime);
                    pstmt.setString(2, msgid);
                    pstmt.setInt(3, userid);
                    pstmt.execute();
                    continue;
                }
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement(this.INSERT_MSGREADSTATUS);
                pstmt.setString(1, msgid);
                pstmt.setInt(2, userid);
                pstmt.setInt(3, userid);
                pstmt.setString(4, sendtime);
                pstmt.execute();
            }
        }
        catch (Exception e) {
            Log.error("TransMsgReadFromRedisToDB,writeMsgReadDataToDb,result={},err={}", result, (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        }
    }
}

