/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.anyoffice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.jivesoftware.openfire.plugin.anyoffice.MQTTConfBean;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyOfficeConf {
    private static String MQTT_CONFIG_FILENAME = "conf" + File.separator + "MQTTBroker.properties";
    private static final Logger Log = LoggerFactory.getLogger(AnyOfficeConf.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQTTConfBean loadMQTTBrokerConfig() {
        MQTTConfBean mattServer = new MQTTConfBean();
        Properties properties = new Properties();
        String home = JiveGlobals.getHomeDirectory();
        InputStream is = null;
        String configPath = null;
        try {
            configPath = home + File.separator + MQTT_CONFIG_FILENAME;
            Log.info("load mqtt conf file path : {}", (Object)configPath);
            File configFile = new File(configPath);
            if (!configFile.exists()) {
                Log.error("mqtt conf file is not exist.file path is : {} ", (Object)configPath);
                MQTTConfBean mQTTConfBean = null;
                return mQTTConfBean;
            }
            is = new FileInputStream(configFile);
            properties.load(is);
            boolean isSSL = Boolean.valueOf(properties.getProperty("isSSL", "false"));
            mattServer.setSSL(isSSL);
            String KEYSTORE_PATH = properties.getProperty("KEYSTORE_PATH");
            mattServer.setKEYSTORE_PATH(KEYSTORE_PATH);
            String KEYSTORE_PW = properties.getProperty("KEYSTORE_PW");
            mattServer.setKETSTORE_PW(KEYSTORE_PW);
            String ipAddr = properties.getProperty("ipAddr");
            mattServer.setIpAddr(ipAddr);
            int portNum = Integer.valueOf(properties.getProperty("portNum"));
            mattServer.setPortNum(portNum);
            String userName = properties.getProperty("userName");
            mattServer.setUserName(userName);
            String passWord = properties.getProperty("passWord");
            mattServer.setPassWord(passWord);
            String clientID = properties.getProperty("clientID");
            mattServer.setClientID(clientID);
            String topic = properties.getProperty("topic");
            mattServer.setTopic(topic);
            String appname = properties.getProperty("appname");
            try {
                appname = new String(appname.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Log.error("appName is error : appName :{} ,error:{}", (Object)appname, (Object)e.getMessage());
                MQTTConfBean mQTTConfBean = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        Log.error("loadRedisConfig,error={}", (Object)e1.getMessage());
                    }
                }
                return mQTTConfBean;
            }
            mattServer.setAppname(appname);
            String parameter = properties.getProperty("parameter");
            mattServer.setParameter(parameter);
            int target = Integer.valueOf(properties.getProperty("target"));
            mattServer.setTarget(target);
            Log.info("loadMQTTBrokerConfig,mattserver:{}", (Object)mattServer.toString());
        }
        catch (IOException e) {
            Log.error("load mqtt server config file error:" + e.getMessage());
            MQTTConfBean mQTTConfBean = null;
            return mQTTConfBean;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    Log.error("loadRedisConfig,error={}", (Object)e1.getMessage());
                }
            }
        }
        return mattServer;
    }
}

