/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.anyoffice;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.jivesoftware.util.cache.DefaultCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyofficeService {
    private static AnyofficeService instance = null;
    private Cache<String, String> usernameLoginIdCache = CacheFactory.createCache((String)"Username Loginid Cache");
    private final long usernameLoginidCacheLifeTime = 21600000L;
    private static final Logger Log = LoggerFactory.getLogger(AnyofficeService.class);

    private AnyofficeService() {
        if (this.usernameLoginIdCache instanceof DefaultCache) {
            this.usernameLoginIdCache.setMaxLifetime(21600000L);
            Log.info("init Username Loginid Cache, set DefaultCache cache.UsernameLoginidCache.maxLifetime:{}ms", (Object)21600000L);
        } else {
            JiveGlobals.setProperty((String)"cache.UsernameLoginidCache.maxLifetime", (String)Long.toString(21600000L));
            Log.info("init Username Loginid Cache, set ClusteredCache cache.UsernameLoginidCache.maxLifetime:{}ms", (Object)21600000L);
        }
    }

    public static synchronized AnyofficeService getInstance() {
        if (instance == null) {
            instance = new AnyofficeService();
        }
        return instance;
    }

    public boolean sendMsg(String pushContent, String username) throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLoginIdByUsername(String username) {
        String loginId = null;
        String anyoffice_account = "";
        if (username == null) {
            Log.error("getLoginIdByUsername,error,username is null.");
            return null;
        }
        String userId = this.getUserIdByUsername(username);
        if (userId == null) {
            Log.error("getLoginIdByUsername,error,username is invalid.username : {}", (Object)username);
            return null;
        }
        try {
            loginId = (String)this.usernameLoginIdCache.get((Object)username);
        }
        catch (Exception e) {
            Log.error("getLoginIdByUsername from cache error:{},username:{}", (Object)e.getMessage(), (Object)username);
        }
        if (loginId == null || loginId.isEmpty()) {
            Connection con = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select loginid from hrmresource where id = ? ");
                pstmt.setString(1, userId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    loginId = rs.getString("loginid");
                }
                if (loginId != null && !loginId.isEmpty()) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    DbConnectionManager.closeResultSet((ResultSet)rs);
                    pstmt = con.prepareStatement(" select anyoffice_account from uf_anyoffice_accoun where oa_account = ? ");
                    pstmt.setString(1, loginId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        anyoffice_account = anyoffice_account + rs.getString("anyoffice_account") + "|";
                    }
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            catch (SQLException e) {
                Log.error("getLoginIdByUsername,DB error:{}", (Object)e.getMessage());
            }
            finally {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
            }
        }
        if (anyoffice_account != null && !anyoffice_account.isEmpty() && anyoffice_account.endsWith("|")) {
            anyoffice_account = anyoffice_account.substring(0, anyoffice_account.length() - 1);
            this.usernameLoginIdCache.put((Object)username, (Object)anyoffice_account);
            return anyoffice_account;
        }
        this.usernameLoginIdCache.put((Object)username, (Object)loginId);
        return loginId;
    }

    private String getUserIdByUsername(String username) {
        int i = username.indexOf("|");
        if (i > 0) {
            return username.substring(0, i);
        }
        if (i == 0) {
            Log.warn("getUserIdByUsername is invalid.username:{}", (Object)username);
            return null;
        }
        return username;
    }
}

