/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.bean;

import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.ThreadPrefix;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.jivesoftware.openfire.plugin.push.PushMessageThread;
import org.jivesoftware.openfire.plugin.push.weapppush.WeAppPushUtil;
import org.jivesoftware.openfire.plugin.util.PushMessageInitUtil;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyForPush
implements PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(HttpProxyForPush.class);
    private ExecutorService fixedThreadPool = ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool();
    private static HttpProxyForPush instance = null;
    private boolean userProxy = false;
    private String proxyHost;
    private int proxyPort = 0;
    private boolean propxyNeedAuth = false;
    private String proxyUsername;
    private String proxyPassword;

    private HttpProxyForPush() {
        this.loadHttpProxyProperties();
    }

    private void loadHttpProxyProperties() {
        String filePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "httpProxy.properties";
        File file = new File(filePath);
        if (!file.exists()) {
            Log.warn("loadHttpProxyProperties .file :{} is not exist .", (Object)filePath);
            return;
        }
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(file);
            properties.load(is);
            this.userProxy = Boolean.valueOf(properties.getProperty("userProxy"));
            this.proxyHost = properties.getProperty("proxyHost");
            String post = properties.getProperty("proxyPort");
            this.proxyPort = Integer.parseInt(post);
            this.propxyNeedAuth = Boolean.valueOf(properties.getProperty("propxyNeedAuth"));
            this.proxyUsername = properties.getProperty("proxyUsername");
            this.proxyPassword = properties.getProperty("proxyPassword");
            Log.info("userProxy:{},userHost:{},prot:{},needAuth:{},username:{},password:{}", new Object[]{this.userProxy, this.proxyHost, this.proxyPort, this.propxyNeedAuth, this.proxyUsername, this.proxyPassword});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HttpProxyForPush getInstance() {
        if (instance == null) {
            instance = new HttpProxyForPush();
        }
        return instance;
    }

    public boolean isUserProxy() {
        return this.userProxy;
    }

    public void setUserProxy(boolean userProxy) {
        this.userProxy = userProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isPropxyNeedAuth() {
        return this.propxyNeedAuth;
    }

    public void setPropxyNeedAuth(boolean propxyNeedAuth) {
        this.propxyNeedAuth = propxyNeedAuth;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public static void setInstance(HttpProxyForPush instance) {
        HttpProxyForPush.instance = instance;
    }

    public void propertySet(String property, Map<String, Object> params) {
        if ("httpProxyForPushUpdate".equals(property)) {
            this.loadHttpProxyProperties();
            PushMessageInitUtil pushMessageInitUtil = PushMessageInitUtil.getInstance();
            pushMessageInitUtil.initPush();
        }
        if ("pushNetStatus".equals(property)) {
            this.loadHttpProxyProperties();
            if (PushMessageInitUtil.isPushMessageThreadRunning) {
                Log.info("pushMessageThread is Runing.");
            } else {
                boolean signPush = JiveGlobals.getBooleanProperty((String)"signPush", (boolean)false);
                WeAppPushUtil.reloadWeAppPush();
                if (signPush) {
                    Log.info("pushMessage is signPush.");
                    PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                    PushMessageInitUtil.isPushMessageThreadRunning = true;
                    pmiu.initPush();
                    for (int i = 0; i < JiveGlobals.getIntProperty((String)"pushMessageThreadCount", (int)40); ++i) {
                        this.fixedThreadPool.execute(new PushMessageThread(ThreadPrefix.PUSH_THREAD.toString() + i + "-" + this.getClass().getSimpleName()));
                    }
                } else {
                    PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                    boolean pushMessageClientInitSuccess = pmiu.initPush();
                    if (pushMessageClientInitSuccess) {
                        PushMessageInitUtil.isPushMessageThreadRunning = true;
                        Log.info("pushSet is open and pushThread is not running.not start push thread.");
                        for (int i = 0; i < JiveGlobals.getIntProperty((String)"pushMessageThreadCount", (int)40); ++i) {
                            this.fixedThreadPool.execute(new PushMessageThread(ThreadPrefix.PUSH_THREAD.toString() + i + "-" + this.getClass().getSimpleName()));
                        }
                    } else {
                        Log.error("push message client init failed.no push.");
                    }
                }
            }
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
        if ("httpProxyForPushUpdate".equals(property)) {
            this.loadHttpProxyProperties();
        }
        if ("pushNetStatus".equals(property)) {
            this.loadHttpProxyProperties();
            if (PushMessageInitUtil.isPushMessageThreadRunning) {
                Log.info("pushMessageThread is Runing.");
            } else {
                boolean signPush = JiveGlobals.getBooleanProperty((String)"signPush", (boolean)false);
                if (signPush) {
                    Log.info("pushMessage is signPush.");
                    PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                    PushMessageInitUtil.isPushMessageThreadRunning = true;
                    pmiu.initPush();
                } else {
                    PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                    boolean pushMessageClientInitSuccess = pmiu.initPush();
                    if (pushMessageClientInitSuccess) {
                        PushMessageInitUtil.isPushMessageThreadRunning = true;
                        Log.info("pushSet is open and pushThread is not running.not start push thread.");
                    } else {
                        Log.error("push message client init failed.no push.");
                    }
                }
            }
        }
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
        if ("httpProxyForPushUpdate".equals(property)) {
            this.loadHttpProxyProperties();
        }
        if ("pushNetStatus".equals(property)) {
            this.loadHttpProxyProperties();
            if (PushMessageInitUtil.isPushMessageThreadRunning) {
                Log.info("pushMessageThread is Runing.");
            } else {
                boolean signPush = JiveGlobals.getBooleanProperty((String)"signPush", (boolean)false);
                if (signPush) {
                    Log.info("pushMessage is signPush.");
                    PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                    PushMessageInitUtil.isPushMessageThreadRunning = true;
                    pmiu.initPush();
                } else {
                    PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                    boolean pushMessageClientInitSuccess = pmiu.initPush();
                    if (pushMessageClientInitSuccess) {
                        PushMessageInitUtil.isPushMessageThreadRunning = true;
                        Log.info("pushSet is open and pushThread is not running.not start push thread.");
                    } else {
                        Log.error("push message client init failed.no push.");
                    }
                }
            }
        }
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
        if ("httpProxyForPushUpdate".equals(property)) {
            this.loadHttpProxyProperties();
        }
        if ("pushNetStatus".equals(property)) {
            this.loadHttpProxyProperties();
            if (PushMessageInitUtil.isPushMessageThreadRunning) {
                Log.info("pushMessageThread is Runing.");
            } else {
                boolean signPush = JiveGlobals.getBooleanProperty((String)"signPush", (boolean)false);
                if (signPush) {
                    Log.info("pushMessage is signPush.");
                    PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                    PushMessageInitUtil.isPushMessageThreadRunning = true;
                    pmiu.initPush();
                } else {
                    PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                    boolean pushMessageClientInitSuccess = pmiu.initPush();
                    if (pushMessageClientInitSuccess) {
                        PushMessageInitUtil.isPushMessageThreadRunning = true;
                        Log.info("pushSet is open and pushThread is not running.not start push thread.");
                    } else {
                        Log.error("push message client init failed.no push.");
                    }
                }
            }
        }
    }
}

