/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.cache;

import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.emessage.multirouter.messagemanager.UsernameUtil;
import com.weaver.util.LanguageUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.TimerTaskUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.cache.MsgReadUtil;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.LuaFileConfig;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Tuple;

public class ConversationRedisCacheUtil
implements Runnable {
    private static final Logger Log = LoggerFactory.getLogger(ConversationRedisCacheUtil.class);
    public static final int MAX_CONVERSATION_COUNT = 300;
    private static final Long EXISTS = 1L;
    private static final String BATCHEXISTS_FILE_NAME = "batchExists.lua";
    private static ScheduledThreadPoolExecutor scheduled = new ScheduledThreadPoolExecutor(1);
    private static final String CONVERSATION_QUEUE = "conversation:queue";
    public static final String CONVERSATION_ITMES = "conversation:itmes:";
    public static final String CONVERSATION_RIGHT_HAD_INIT = "conversation:itmes:-1";
    private static final String CONVERSATION_RIGHT = "conversation:right:";
    private static final String CONVERSATION_TOP = "conversation:top:";
    private static ConversationRedisCacheUtil instance = null;
    private static RedisPoolMgr redisPoolMgr = null;
    private static final int CONVERSATION_EXPIRE = JiveGlobals.getIntProperty((String)"CONVERSATION_EXPIRE", (int)1296000);
    private static final String DELETE_IMCONVERSATION = "DELETE FROM social_IMConversation WHERE targetid = ? ";
    private static final String INSERT_IMRECENTCONVER = "INSERT INTO social_IMRecentConver (userid,targetid,isdel,istop,unreadcount,updatetime,sendId,targettype,msgId,msgcontent,targetname,lasttime,objectname,content,sharetypename,sharetype,isAt) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT_IMRECENTCONVER = "SELECT userid FROM social_IMRecentConver WHERE targetid = ? ";
    private static final String UPDATE_IMRECENTCONVER = "UPDATE social_IMRecentConver SET isdel =?,unreadcount=? ,istop = ?,updatetime=? WHERE targetid =? AND userid =?";
    private static final String DELETE_IMRECENTCONVER = "DELETE FROM social_IMRecentConver WHERE targetid =? AND userid =?";
    private static final UserManager userManager = UserManager.getInstance();
    private static String sha = "";
    private static boolean needReloadSha = JiveGlobals.getBooleanProperty((String)"multiRouter.conversation.needReloadSha", (boolean)false);
    private static boolean luaMode = JiveGlobals.getBooleanProperty((String)"multiRouter.conversation.luaMode", (boolean)true);

    private ConversationRedisCacheUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ConversationRedisCacheUtil getInstance() {
        if (instance == null) {
            Class<ConversationRedisCacheUtil> clazz = ConversationRedisCacheUtil.class;
            // MONITORENTER : org.jivesoftware.openfire.plugin.cache.ConversationRedisCacheUtil.class
            if (instance == null) {
                instance = new ConversationRedisCacheUtil();
                boolean needRunTimerTaskUtil = TimerTaskUtil.needRunTimerTaskUtil();
                if (needRunTimerTaskUtil) {
                    Log.info("ConversationRedisCacheUtil scheduled start");
                    scheduled.scheduleAtFixedRate(instance, 5L, 300L, TimeUnit.SECONDS);
                }
            }
            // MONITOREXIT : clazz
        }
        if ((redisPoolMgr = RedisPoolMgr.getInstance()) != null) return instance;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean saveConversation(String targetId, String userId, Set<String> receiverIds, boolean needRecordUnreadCount, Map<String, String> map, boolean fromisNumber) {
        long startTime = System.currentTimeMillis();
        Long lastTime = Long.valueOf(map.get("lasttime"));
        String recentConverKey = this.getConversationItmesKeyHead(targetId);
        ArrayList<String> receiverIdsKeysList = new ArrayList<String>();
        HashMap<String, Double> scoreMembers = new HashMap<String, Double>();
        Double time = Double.parseDouble(map.get("lasttime"));
        try {
            int i;
            List keysExisteList;
            ArrayList<String> needInitReceiverIds = new ArrayList<String>();
            for (String str : receiverIds) {
                needInitReceiverIds.add(str);
                str = recentConverKey + str;
                receiverIdsKeysList.add(str);
                scoreMembers.put(str, time);
            }
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList args = new ArrayList();
            String concatKey = StringUtils.join((Object[])receiverIdsKeysList.toArray(), (String)"|");
            keys.add(concatKey);
            if (luaMode && (null == sha || "".equals(sha) || needReloadSha)) {
                String luaScript = new LuaFileConfig().readLuaFromFile(BATCHEXISTS_FILE_NAME);
                if (null == luaScript) {
                    Log.error("luaScript is empty, please check the file:{}", (Object)BATCHEXISTS_FILE_NAME);
                } else {
                    sha = redisPoolMgr.scriptLoad(luaScript);
                }
            }
            if (!luaMode || null == sha || "".equals(sha) || redisPoolMgr.isUserCluster()) {
                keysExisteList = new ArrayList();
                keysExisteList = redisPoolMgr.batchExists(receiverIdsKeysList);
                if (keysExisteList != null) {
                    for (i = 0; i < keysExisteList.size(); ++i) {
                        int o = (Integer)keysExisteList.get(i);
                        if (o != 1) continue;
                        needInitReceiverIds.set(i, null);
                    }
                }
            } else {
                keysExisteList = new ArrayList();
                keysExisteList = (List)redisPoolMgr.eval(sha, keys, args);
                if (keysExisteList != null) {
                    for (i = 0; i < keysExisteList.size(); ++i) {
                        Object o = keysExisteList.get(i);
                        if (null == o || EXISTS.longValue() != ((Long)o).longValue()) continue;
                        needInitReceiverIds.set(i, null);
                    }
                }
            }
            needInitReceiverIds.removeAll(Collections.singleton(null));
            if (needInitReceiverIds.size() > 0) {
                Map<String, Map<String, String>> recentConveMap = this.getRecentConverByTargetId(targetId);
                if (recentConveMap == null) {
                    recentConveMap = new HashMap<String, Map<String, String>>();
                }
                if (recentConveMap.size() == 0 || !recentConveMap.containsKey(userId)) {
                    HashMap<String, String> obMap = new HashMap<String, String>();
                    obMap.putAll(map);
                    obMap.put("istop", "0");
                    obMap.put("isdel", "0");
                    obMap.put("unreadcount", "0");
                    obMap.put("groupName", "");
                    obMap.put("groupIconUrl", "");
                    recentConveMap.put(userId, obMap);
                }
                HashMap<String, Map<String, String>> recentConverToRedis = new HashMap<String, Map<String, String>>();
                for (String string : needInitReceiverIds) {
                    if (recentConveMap.get(string) != null) {
                        recentConverToRedis.put(recentConverKey + string, recentConveMap.get(string));
                        continue;
                    }
                    HashMap<String, String> obMap = new HashMap<String, String>();
                    obMap.putAll(recentConveMap.get(userId));
                    obMap.put("userid", string);
                    obMap.put("istop", "0");
                    obMap.put("isdel", "0");
                    obMap.put("unreadcount", "0");
                    recentConverToRedis.put(recentConverKey + string, obMap);
                }
                for (Map.Entry entry : recentConverToRedis.entrySet()) {
                    String key = (String)entry.getKey();
                    for (Map.Entry kv : ((Map)entry.getValue()).entrySet()) {
                        if (kv.getValue() == null || ((String)kv.getValue()).isEmpty()) continue;
                        redisPoolMgr.hsetnx(key, (String)kv.getKey(), (String)kv.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            Log.error("ConversationRedisCacheUtil -> saveConversation, targetId:{},userId{}, map{},err:{},{}", new Object[]{targetId, userId, map, e.getMessage(), e});
            return false;
        }
        HashMap<String, Map<String, String>> conversation_itmes = new HashMap<String, Map<String, String>>();
        HashMap conversation_right = new HashMap();
        HashMap updateConvUnread = new HashMap();
        String groupIconUrl = "";
        String groupType = "0";
        String string = "0";
        String secretGroupType = "0";
        if ("1".equals(map.get("targettype"))) {
            try {
                groupIconUrl = (String)GroupManager.getInstance().getGroup(targetId).getProperties().getOrDefault((Object)"groupIconUrl", (Object)"");
                groupType = (String)GroupManager.getInstance().getGroup(targetId).getProperties().getOrDefault((Object)"groupType", (Object)"0");
                String string2 = (String)GroupManager.getInstance().getGroup(targetId).getProperties().getOrDefault((Object)"isTop", (Object)"0");
                secretGroupType = (String)GroupManager.getInstance().getGroup(targetId).getProperties().getOrDefault((Object)"secretGroupType", (Object)"0");
            }
            catch (GroupNotFoundException groupNotFoundException) {
                // empty catch block
            }
        }
        HashMap updateConvAt = new HashMap();
        for (String str : receiverIds) {
            HashMap<String, String> mapTemp = new HashMap<String, String>(map);
            String msg_at_userid = (String)mapTemp.get("msg_at_userid");
            mapTemp.remove("msg_at_userid");
            mapTemp.put("msgcontent", map.get("msgcontent"));
            mapTemp.put("msgid", map.get("msgid"));
            mapTemp.put("userid", str);
            mapTemp.put("lasttime", String.valueOf(lastTime));
            if ("0".equals(map.get("targettype"))) {
                if (userId.equals(str)) {
                    mapTemp.put("targetname", map.get("targetname"));
                } else {
                    mapTemp.put("targetname", this.getUserName(userId));
                }
            }
            if ("1".equals(map.get("targettype"))) {
                void var21_32;
                mapTemp.put("groupName", map.get("targetname"));
                mapTemp.put("groupIconUrl", groupIconUrl);
                mapTemp.put("groupType", groupType);
                mapTemp.put("groupTop", (String)var21_32);
                mapTemp.put("secretGroupType", secretGroupType);
                if ("1".equals(secretGroupType)) {
                    DatabaseUtil db = new DatabaseUtil();
                    mapTemp.put("secretGroupTargetId", db.getSecretChatTargetId(str, targetId));
                }
                if ("1".equals(secretGroupType) || "2".equals(secretGroupType)) {
                    mapTemp.put("msgcontent", LanguageUtil.getInstance().getLanguage("zh", "receive.a.message"));
                }
            }
            mapTemp.put("isdel", "0");
            conversation_itmes.put(recentConverKey + str, mapTemp);
            HashMap<String, Long> updateConvMemberTemp = new HashMap<String, Long>();
            updateConvMemberTemp.put(recentConverKey + str, lastTime);
            conversation_right.put(this.getConversationRightKey(str), updateConvMemberTemp);
            if (!(!needRecordUnreadCount || userId.equals(str) && fromisNumber)) {
                updateConvMemberTemp = new HashMap();
                updateConvMemberTemp.put("unreadcount", 1L);
                updateConvUnread.put(recentConverKey + str, updateConvMemberTemp);
            }
            if (str.equals(userId) || !this.msgAtUtil(str, msg_at_userid)) continue;
            HashMap<String, Long> updateConvIsAtTemp = new HashMap<String, Long>();
            updateConvIsAtTemp.put("isAt", 1L);
            updateConvAt.put(recentConverKey + str, updateConvIsAtTemp);
        }
        if (updateConvAt != null && updateConvAt.size() > 0) {
            redisPoolMgr.batchHincrBy(updateConvAt);
        }
        this.batchSaveConvRight(conversation_itmes);
        redisPoolMgr.batchzaddKey(conversation_right);
        if (needRecordUnreadCount) {
            redisPoolMgr.batchHincrBy(updateConvUnread);
        }
        if (scoreMembers.size() > 0) {
            redisPoolMgr.zadd(CONVERSATION_QUEUE, scoreMembers, 5184000);
        }
        return true;
    }

    private boolean msgAtUtil(String userId, String msg_at_userid) {
        boolean result;
        block5: {
            result = false;
            try {
                if (msg_at_userid == null || msg_at_userid.isEmpty()) {
                    result = false;
                    break block5;
                }
                if ("msg_at_all".equals(msg_at_userid)) {
                    result = true;
                    break block5;
                }
                String[] msgAtStr = msg_at_userid.split(",");
                for (int i = 0; i < msgAtStr.length; ++i) {
                    String s = msgAtStr[i];
                    if (s == null || !s.equals(userId)) continue;
                    result = true;
                    break;
                }
            }
            catch (Exception e) {
                Log.error("msgAtUtil ,userId:{},msg_at_userid:{},error:{}", new Object[]{userId, msg_at_userid, e.getMessage()});
            }
        }
        return result;
    }

    public boolean updateConTargetname(String targetId, String targetName, Set<String> receiverIds) {
        boolean result = true;
        String keyHead = this.getConversationItmesKeyHead(targetId);
        ArrayList<String> receiverIdsKeys = new ArrayList<String>();
        try {
            ArrayList<String> msgidList = new ArrayList<String>();
            for (String str : receiverIds) {
                str = keyHead + str;
                receiverIdsKeys.add(str);
                msgidList.add(redisPoolMgr.hget(str, "targetname"));
            }
            long time = System.currentTimeMillis();
            for (int i = 0; i < msgidList.size(); ++i) {
                Object o = msgidList.get(i);
                if (o == null) {
                    result = false;
                    continue;
                }
                redisPoolMgr.hset((String)receiverIdsKeys.get(i), "targetname", targetName);
                redisPoolMgr.hset((String)receiverIdsKeys.get(i), "groupName", targetName);
                redisPoolMgr.zadd(CONVERSATION_QUEUE, time, (String)receiverIdsKeys.get(i), 604800);
            }
        }
        catch (Exception e) {
            Log.error("ConversationRedisCacheUtil -> updateConTargetname, targetId:{},targetName{},err:{}", new Object[]{targetId, targetName, e.getMessage()});
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateConMsgContent(String userid, String targetId) {
        boolean result = true;
        String str = this.getConversationItmesKeyHead(targetId) + userid;
        if (redisPoolMgr.exists(str)) {
            redisPoolMgr.hdel(str, "msgcontent");
            redisPoolMgr.hdel(str, "content");
            redisPoolMgr.hdel(str, "objectName");
            redisPoolMgr.hdel(str, "sharetypename");
            redisPoolMgr.hdel(str, "sharetype");
            redisPoolMgr.hset(str, "unreadcount", "0");
            redisPoolMgr.hdel(str, "sendId");
            redisPoolMgr.zadd(CONVERSATION_QUEUE, System.currentTimeMillis(), str, 2592000);
            return result;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("update  social_IMRecentConver   set msgcontent = '' ,unreadcount  = '0',objectName = '',sharetypename ='',sharetype='' where userid = ? and targetid = ? ");
            pstmt.setString(1, userid);
            pstmt.setString(2, targetId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("updateConMsgContent ,error ,userid:{},targetid:{},errmsg:{},e:{}", new Object[]{userid, targetId, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            return result;
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateConSubTitle(String userid, String targetId, String content, String lasttime) {
        boolean result = true;
        String str = this.getConversationItmesKeyHead(targetId) + userid;
        if (redisPoolMgr.exists(str)) {
            if (content == null || content.isEmpty()) {
                redisPoolMgr.hdel(str, "content");
                redisPoolMgr.hdel(str, "msgcontent");
            } else {
                redisPoolMgr.hset(str, "content", content);
                redisPoolMgr.hset(str, "msgcontent", content);
            }
            if (lasttime == null || lasttime.isEmpty()) {
                redisPoolMgr.hset(str, "lasttime", "0");
            } else {
                redisPoolMgr.hset(str, "lasttime", lasttime);
            }
            redisPoolMgr.zadd(CONVERSATION_QUEUE, System.currentTimeMillis(), str, 2592000);
            return result;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("update  social_IMRecentConver  set msgcontent = ?,content=?,lasttime= ?  where userid = ? and targetid = ? ");
            pstmt.setString(1, content);
            pstmt.setString(2, content);
            pstmt.setString(3, lasttime);
            pstmt.setString(4, userid);
            pstmt.setString(5, targetId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("updateConMsgContent ,error ,userid:{},targetid:{},errmsg:{},e:{}", new Object[]{userid, targetId, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            return result;
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        return result;
    }

    private String getMsgAtUserId(String msgid, String userId) {
        String result = null;
        DatabaseUtil db = new DatabaseUtil();
        Map<String, String> msgidmap = db.getMsgById(msgid, userId, true, null);
        if (msgidmap == null || msgidmap.isEmpty()) {
            result = null;
        } else {
            String opBody = msgidmap.get("opBody");
            if (opBody == null || opBody.isEmpty()) {
                result = null;
            } else {
                JSONObject extraJSON;
                String extra;
                JSONObject opBodyJson = JSONObject.parseObject((String)opBody);
                if (opBody != null && opBody.contains("extra") && (extra = opBodyJson.getString("extra")) != null && !extra.isEmpty() && (extraJSON = JSONObject.parseObject((String)extra)) != null && extraJSON.containsKey((Object)"msg_at_userid")) {
                    result = extraJSON.getString("msg_at_userid");
                }
            }
        }
        return result;
    }

    public boolean updateConMsgContent(String targetId, String msgId, String msgContent, Set<String> receiverIds, String sendId) {
        boolean result = true;
        String keyHead = this.getConversationItmesKeyHead(targetId);
        ArrayList<String> receiverIdsKeys = new ArrayList<String>();
        try {
            ArrayList<String> msgidList = new ArrayList<String>();
            for (String str : receiverIds) {
                str = keyHead + str;
                receiverIdsKeys.add(str);
                msgidList.add(redisPoolMgr.hget(str, "msgid"));
            }
            MsgReadUtil msgReadUtil = MsgReadUtil.getInstance();
            Set<String> readUses = msgReadUtil.getMsgReadById(msgId);
            if (receiverIdsKeys.size() > 0) {
                for (String str : receiverIdsKeys) {
                    if (readUses != null && readUses.contains(str.replace(keyHead, ""))) continue;
                    try {
                        int at;
                        String isAt;
                        int unreadcount = Integer.parseInt(redisPoolMgr.hget(str, "unreadcount"));
                        if (unreadcount > 0) {
                            redisPoolMgr.hset(str, "unreadcount", String.valueOf(--unreadcount));
                        }
                        String msg_at_userid = this.getMsgAtUserId(msgId, str);
                        if (!this.msgAtUtil(str.replaceAll(CONVERSATION_ITMES + targetId + ":", ""), msg_at_userid) || (isAt = redisPoolMgr.hget(str, "isAt")) == null || isAt.isEmpty() || (at = Integer.parseInt(isAt)) <= 0) continue;
                        redisPoolMgr.hset(str, "isAt", String.valueOf(--at));
                    }
                    catch (Exception e) {}
                }
            }
            for (int i = 0; i < msgidList.size(); ++i) {
                Object o = msgidList.get(i);
                if (o == null) {
                    result = false;
                }
                if (msgId.equals(msgidList.get(i))) continue;
                receiverIdsKeys.set(i, null);
            }
            receiverIdsKeys.removeAll(Collections.singleton(null));
            Long time = System.currentTimeMillis();
            if (receiverIdsKeys.size() > 0) {
                for (String str : receiverIdsKeys) {
                    if (msgContent == null) {
                        redisPoolMgr.zrem(str, "msgcontent");
                        redisPoolMgr.zrem(str, "content");
                        redisPoolMgr.zrem(str, "objectName");
                        redisPoolMgr.zrem(str, "sharetypename");
                        redisPoolMgr.zrem(str, "sharetype");
                        redisPoolMgr.zadd(CONVERSATION_QUEUE, time.longValue(), str, 2592000);
                        continue;
                    }
                    redisPoolMgr.hset(str, "msgcontent", msgContent);
                    redisPoolMgr.hset(str, "content", LocaleUtils.getLocalizedString((String)"message.withdraw", (String)"multirouter"));
                    redisPoolMgr.hset(str, "objectName", "RC:InfoNtf:withdraw:RC:TxtMsg");
                    redisPoolMgr.hset(str, "sendId", sendId);
                    redisPoolMgr.zadd(CONVERSATION_QUEUE, time.longValue(), str, 2592000);
                }
            }
        }
        catch (Exception e) {
            Log.error("ConversationRedisCacheUtil -> updateConMsgContent, targetId:{},msgContent{},err:{}", new Object[]{targetId, msgContent, e.getMessage()});
            result = false;
        }
        return result;
    }

    public boolean batchSaveConvRight(Map<String, Map<String, String>> map) {
        return this.batchStoreRedisHset(map, CONVERSATION_EXPIRE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> getTopGroupConversation(String userId, Set<String> groupTopSet) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select b.groupName as groupName from (select groupName from ofgroupuser where username = ?) a left join ofgroup b on a.groupName = b.groupName where istop = '1' ");
            pstmt.setString(1, (userId + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String targetId = rs.getString("groupName");
                String redisConverKey = CONVERSATION_ITMES + targetId + ":" + userId;
                groupTopSet.add(redisConverKey);
                Map<String, String> rightMap = null;
                if (redisPoolMgr != null) {
                    rightMap = redisPoolMgr.hgetall(redisConverKey);
                }
                if (rightMap != null && rightMap.containsKey("msgcontent") && rightMap.containsKey("lasttime")) {
                    rightMap.put("groupTop", "1");
                    result.add(rightMap);
                    continue;
                }
                rightMap = this.getTopConversation(userId, targetId, redisConverKey);
                if (rightMap != null && rightMap.containsKey("msgcontent") && rightMap.containsKey("lasttime")) {
                    rightMap.put("groupTop", "1");
                }
                result.add(rightMap);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("getTopGroupConversation ,userId : {} ,error:{} ", (Object)userId, (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getTopSet(String userId) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        Set topSet;
        block7: {
            topSet = null;
            con = null;
            pstmt = null;
            rs = null;
            try {
                topSet = redisPoolMgr.zrange(this.getConversationTopKey(userId), 0L, -1L);
                if (topSet == null || topSet.isEmpty() || !topSet.contains(CONVERSATION_RIGHT_HAD_INIT)) {
                    HashSet<String> dbSet = new HashSet<String>();
                    con = DbConnectionManager.getConnection();
                    pstmt = con.prepareStatement(" select targetId,lasttime from Social_IMRecentConver where userId = ? and isTop = '1' and (isDel is null or isdel = '0') ");
                    pstmt.setString(1, userId);
                    rs = pstmt.executeQuery();
                    HashMap<String, Double> scoreMembers = new HashMap<String, Double>();
                    while (rs.next()) {
                        String targetId = rs.getString("targetId");
                        String lasttime = rs.getString("lasttime");
                        String redisKey = this.getConversationItmesKeyHead(targetId) + userId;
                        scoreMembers.put(redisKey, Double.parseDouble(lasttime));
                        dbSet.add(redisKey);
                    }
                    if (dbSet != null && dbSet.size() > 0) {
                        topSet.addAll(dbSet);
                        scoreMembers.put(CONVERSATION_RIGHT_HAD_INIT, Double.parseDouble("0"));
                        redisPoolMgr.zadd(this.getConversationTopKey(userId), scoreMembers, -1);
                    }
                    break block7;
                }
                topSet.remove(CONVERSATION_RIGHT_HAD_INIT);
            }
            catch (Exception e) {
                try {
                    Log.error("getTopSet,userId :{} , error:{},e:{}", new Object[]{e, e.getMessage(), e});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        return topSet;
    }

    public Map<String, Object> getIMConversation(String userId, int pageSize, Long lastTime, String targetTypes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String key = this.getConversationRightKey(userId);
        List<Map<String, String>> reList = new ArrayList<Map<String, String>>();
        HashSet<String> set = new HashSet<String>();
        Set<String> topSet = null;
        HashSet<String> groupTopSet = new HashSet<String>();
        List<Map<String, String>> groupTopList = this.getTopGroupConversation(userId, groupTopSet);
        reList.addAll(groupTopList);
        if (lastTime == null) {
            lastTime = 0L;
            topSet = this.getTopSet(userId);
            if (topSet != null && topSet.size() > 0) {
                for (String topKey : topSet) {
                    Map topMap = redisPoolMgr.hgetall(topKey);
                    if (topMap != null && topMap.containsKey("lasttime")) {
                        reList.add(topMap);
                        continue;
                    }
                    topMap = this.getTopConversation(userId, this.getTargetIdByRedisKey(topKey), topKey);
                    if (topMap == null || !topMap.containsKey("lasttime")) continue;
                    reList.add(topMap);
                }
            }
        }
        Set directList = null;
        if (lastTime != null && lastTime > 0L) {
            directList = redisPoolMgr.zrevrangeByScore("conversation:direct:" + userId, lastTime, Long.valueOf(System.currentTimeMillis() * 2L), 0, pageSize * 2);
        }
        Set convRight = redisPoolMgr.zrevrangeByScore(key, lastTime, Long.valueOf(System.currentTimeMillis() * 2L), 0, pageSize * 2);
        if (groupTopSet != null && groupTopSet.size() > 0) {
            convRight.removeAll(groupTopSet);
        }
        if (topSet != null && topSet.size() > 0) {
            convRight.removeAll(topSet);
        }
        if (directList != null && directList.size() > 0) {
            convRight.addAll(directList);
        }
        for (String rightKey : convRight) {
            if (!CONVERSATION_RIGHT_HAD_INIT.equals(rightKey)) {
                Map<String, String> rightMap = redisPoolMgr.hgetall(rightKey);
                if (rightMap != null && rightMap.containsKey("lasttime")) {
                    reList.add(rightMap);
                    continue;
                }
                rightMap = this.getTopConversation(userId, this.getTargetIdByRedisKey(rightKey), rightKey);
                if (rightMap == null || !rightMap.containsKey("lasttime")) continue;
                reList.add(rightMap);
                continue;
            }
            result.put("reload", "0");
        }
        if (redisPoolMgr.zscore(key, CONVERSATION_RIGHT_HAD_INIT) != null) {
            result.put("reload", "0");
        }
        HashSet<String> targetTypeSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)targetTypes)) {
            String[] targetTypeArray = targetTypes.split(",");
            for (int i = 0; i < targetTypeArray.length; ++i) {
                targetTypeSet.add(targetTypeArray[i]);
            }
        }
        Iterator it = reList.iterator();
        while (it.hasNext()) {
            Map temp = (Map)it.next();
            String targetidTemp = (String)temp.get("targetid");
            if (temp.isEmpty() || targetidTemp == null) {
                it.remove();
                continue;
            }
            if (!("1".equals(temp.get("targettype")) || Arrays.asList(targetidTemp.split(",")).contains(userId) || targetidTemp.equals("bing_" + userId) || targetidTemp.equals("group_notice:" + userId))) {
                it.remove();
                continue;
            }
            set.remove(this.getConversationItmesKeyHead(targetidTemp) + userId);
            if (StringUtils.isNotBlank((CharSequence)targetTypes) && !targetTypeSet.contains(temp.get("targettype"))) {
                it.remove();
            }
            temp.remove("recivesids");
            if (temp.containsKey("groupType") || !"1".equals(temp.get("targettype"))) continue;
            temp.put("groupType", "0");
        }
        if (set.size() > reList.size()) {
            result.remove("reload");
            this.delInvalidTargetId(key, set);
            if (lastTime == 0L) {
                this.delInvalidTargetId(this.getConversationTopKey(userId), set);
            }
        } else {
            reList = ConversationRedisCacheUtil.sortConversationList(reList, pageSize);
        }
        result.put("reList", reList);
        return result;
    }

    private String getTargetIdByRedisKey(String redisKey) {
        String[] s = redisKey.split(":");
        return s[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getTopConversation(String userid, String targetId, String redisKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("SELECT userid,targetid,targettype,targetname,t1.istop,isdel,unreadcount,lasttime,msgcontent,msgid,sendid,objectname,content,sharetypename,sharetype,isAt,t3.description AS groupName,t3.groupIconUrl AS groupIconUrl, t3.groupType AS groupType,t3.isTop AS groupTop,t3.secretGroupType AS secretGroupType from social_IMRecentConver  t1 left join ofGroup t3 on t1.targetid = t3.groupName where t1.userid= ? and t1.targetid = ?");
            pstmt.setString(1, userid);
            pstmt.setString(2, targetId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String isAt;
                String sharetype;
                String objectName;
                String sendid;
                String groupIconUrl;
                String targetid = rs.getString("targetid");
                if (targetid == null || targetid.isEmpty()) {
                    targetid = "";
                }
                String targettype = rs.getString("targettype");
                String userId = rs.getString("userid");
                if (userId == null || userId.isEmpty()) {
                    userId = "";
                }
                map.put("userid", userId);
                map.put("targetid", targetid);
                map.put("targettype", targettype);
                String targetname = rs.getString("targetname");
                map.put("targetname", targetname);
                String istop = rs.getString("istop");
                if (istop == null || istop.isEmpty()) {
                    istop = "0";
                }
                map.put("istop", istop);
                String isdel = rs.getString("isdel");
                if (isdel == null || isdel.isEmpty()) {
                    isdel = "0";
                }
                map.put("isdel", isdel);
                String lasttime = rs.getString("lasttime");
                if (lasttime == null || lasttime.isEmpty()) {
                    Log.warn("getTopConversation,lasttime is null,userId:{},targetid:{},targetType:{},targetname:{}", new Object[]{userId, targetid, targettype, targetname});
                    continue;
                }
                map.put("lasttime", lasttime);
                String msgcontent = rs.getString("msgcontent");
                map.put("msgcontent", msgcontent);
                String unreadcount = rs.getString("unreadcount");
                if (unreadcount == null || unreadcount.isEmpty()) {
                    unreadcount = "0";
                }
                map.put("unreadcount", unreadcount);
                String groupName = rs.getString("groupName");
                if (groupName == null || groupName.isEmpty()) {
                    groupName = "";
                }
                if (groupName != null && !groupName.isEmpty()) {
                    map.put("groupName", groupName);
                }
                if ((groupIconUrl = rs.getString("groupIconUrl")) == null || groupIconUrl.isEmpty()) {
                    groupIconUrl = "";
                }
                if (groupIconUrl != null && !groupIconUrl.isEmpty()) {
                    map.put("groupIconUrl", groupIconUrl);
                }
                String groupType = rs.getString("groupType");
                map.put("groupType", (String)StringUtils.defaultIfEmpty((CharSequence)groupType, (CharSequence)"0"));
                String groupTop = rs.getString("groupTop");
                map.put("groupTop", (String)StringUtils.defaultIfEmpty((CharSequence)groupTop, (CharSequence)"0"));
                String msgId = rs.getString("msgid");
                if (msgId != null && !msgId.isEmpty()) {
                    map.put("msgid", (String)StringUtils.defaultIfEmpty((CharSequence)msgId, (CharSequence)""));
                }
                if ((sendid = rs.getString("sendid")) != null && !sendid.isEmpty()) {
                    map.put("sendId", (String)StringUtils.defaultIfEmpty((CharSequence)sendid, (CharSequence)""));
                }
                if ((objectName = rs.getString("objectname")) != null && !objectName.isEmpty()) {
                    map.put("objectName", (String)StringUtils.defaultIfEmpty((CharSequence)objectName, (CharSequence)""));
                }
                String content = rs.getString("content");
                map.put("content", (String)StringUtils.defaultIfEmpty((CharSequence)content, (CharSequence)""));
                String sharetypename = rs.getString("sharetypename");
                if (sharetypename != null && !sharetypename.isEmpty()) {
                    map.put("sharetypename", (String)StringUtils.defaultIfEmpty((CharSequence)sharetypename, (CharSequence)""));
                }
                if ((sharetype = rs.getString("sharetype")) != null && !sharetype.isEmpty()) {
                    map.put("sharetype", (String)StringUtils.defaultIfEmpty((CharSequence)sharetype, (CharSequence)""));
                }
                if ((isAt = rs.getString("isAt")) != null && !isAt.isEmpty()) {
                    map.put("isAt", (String)StringUtils.defaultIfEmpty((CharSequence)isAt, (CharSequence)""));
                }
                String secretGroupType = rs.getString("secretGroupType");
                map.put("secretGroupType", (String)StringUtils.defaultIfEmpty((CharSequence)secretGroupType, (CharSequence)"0"));
                if (!"1".equals(secretGroupType)) continue;
                DatabaseUtil db = new DatabaseUtil();
                map.put("secretGroupTargetId", db.getSecretChatTargetId(userId, targetId));
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getTopConversation,userid:{},targetId:{},error:{}", new Object[]{userid, targetId, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        if (map != null && !map.isEmpty()) {
            try {
                redisPoolMgr.batchHset(redisKey, map, 2592000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public static List<Map<String, String>> sortConversationList(List<Map<String, String>> list, int pageSize) {
        Collections.sort(list, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                long t1 = 0L;
                long t2 = 0L;
                String isGroupTop1 = o1.get("groupTop");
                String isGroupTop2 = o2.get("groupTop");
                if ("1".equals(isGroupTop1) && !"1".equals(isGroupTop2)) {
                    return -1;
                }
                if ("1".equals(isGroupTop2) && !"1".equals(isGroupTop1)) {
                    return 1;
                }
                String istop1 = o1.get("istop");
                String istop2 = o2.get("istop");
                if ("1".equals(istop1) && !"1".equals(istop2)) {
                    return -1;
                }
                if ("1".equals(istop2) && !"1".equals(istop1)) {
                    return 1;
                }
                try {
                    t1 = Long.parseLong(o1.get("lasttime"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    t2 = Long.parseLong(o2.get("lasttime"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (t2 > t1) {
                    return 1;
                }
                if (t2 == t1) {
                    return 0;
                }
                return -1;
            }
        });
        return pageSize < list.size() ? list.subList(0, pageSize) : list;
    }

    public void batchSaveConv(String userId, List<Map<String, String>> mapList, Boolean isLastOne) {
        HashMap<String, Map<String, String>> recentConverToRedis = new HashMap<String, Map<String, String>>();
        String right_key = this.getConversationRightKey(userId);
        HashMap<String, Double> scoreMembers = new HashMap<String, Double>();
        HashMap<String, Double> scoreTopMembers = new HashMap<String, Double>();
        for (Map<String, String> map : mapList) {
            String targetId = map.get("targetid");
            String key = this.getConversationItmesKeyHead(targetId) + userId;
            recentConverToRedis.put(key, map);
            String lasttime = map.get("lasttime");
            long replaceTimestamp = System.currentTimeMillis();
            if (null == lasttime || lasttime.isEmpty()) {
                lasttime = String.valueOf(replaceTimestamp);
                Log.error("batchSaveConv error, lasttime is null or empty, key:{}, userid:{}, targetid:{}\uff0creplaceTimestamp:{}", new Object[]{key, userId, targetId, replaceTimestamp});
            }
            scoreMembers.put(key, Double.parseDouble(lasttime));
            if (!"1".equals(map.get("istop"))) continue;
            scoreTopMembers.put(key, Double.parseDouble(lasttime));
        }
        if (isLastOne.booleanValue()) {
            scoreMembers.put(CONVERSATION_RIGHT_HAD_INIT, 0.0);
        }
        redisPoolMgr.zadd(right_key, scoreMembers, -1);
        if (scoreTopMembers.size() > 0) {
            redisPoolMgr.zadd(this.getConversationTopKey(userId), scoreTopMembers, -1);
        }
        this.batchStoreRedisHset(recentConverToRedis, CONVERSATION_EXPIRE, true);
    }

    public List<String> getAllItmesOfTargetId(String targetId) {
        return redisPoolMgr.scan("0", this.getConversationItmesKeyHead(targetId) + "*", 1000);
    }

    public boolean deleteOFConversation(String userId, String targetId) {
        boolean result = false;
        try {
            String key = this.getConversationItmesKeyHead(targetId) + userId;
            result = redisPoolMgr.hexists(key, "isdel");
            if (result) {
                redisPoolMgr.hset(key, "isdel", "1");
                redisPoolMgr.hset(key, "istop", "0");
                redisPoolMgr.zadd(this.getConversationRightKey(userId), System.currentTimeMillis(), key, 604800);
                redisPoolMgr.zadd(CONVERSATION_QUEUE, System.currentTimeMillis(), key, 604800);
            }
            redisPoolMgr.zrem(this.getConversationTopKey(userId), key);
        }
        catch (Exception e) {
            Log.error("ConversationRedisCacheUtil->deleteOFConversation: userid:{},targetid:{}, error:{}", new Object[]{userId, targetId, e.getMessage()});
        }
        return false;
    }

    public boolean setOFConversationTop(String userId, String targetId, String istop) {
        boolean result = false;
        if (istop == null) {
            istop = "1";
        }
        try {
            String key = this.getConversationItmesKeyHead(targetId) + userId;
            String rightKey = this.getConversationRightKey(userId);
            long socre = System.currentTimeMillis();
            redisPoolMgr.hset(key, "istop", istop);
            try {
                String lasttimeStr;
                if ("0".equals(istop) && ((lasttimeStr = redisPoolMgr.hget(key, "lasttime")) == null || lasttimeStr.isEmpty())) {
                    socre = Long.parseLong(lasttimeStr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            redisPoolMgr.zadd("conversation:direct:" + userId, System.currentTimeMillis(), key, -1);
            redisPoolMgr.zadd(rightKey, socre, key, -1);
            redisPoolMgr.zadd(CONVERSATION_QUEUE, System.currentTimeMillis(), key, 604800);
            if ("1".equals(istop)) {
                redisPoolMgr.zadd(this.getConversationTopKey(userId), System.currentTimeMillis(), key, -1);
            } else {
                redisPoolMgr.zrem(this.getConversationTopKey(userId), key);
            }
        }
        catch (Exception e) {
            Log.error("ConversationRedisCacheUtil->setOFConversationTop: userid:{},targetid:{},istop:{}, error:{}", new Object[]{userId, targetId, istop, e.getMessage()});
        }
        return result;
    }

    public boolean clearUnreadMsg(String userId, String targetId, int count) {
        boolean result;
        block5: {
            result = false;
            try {
                String key = this.getConversationItmesKeyHead(targetId) + userId;
                result = redisPoolMgr.hexists(key, "unreadcount");
                if (!result) break block5;
                redisPoolMgr.hset(key, "unreadcount", String.valueOf(count));
                redisPoolMgr.hset(key, "isAt", "0");
                long score = System.currentTimeMillis();
                try {
                    String lasttimeStr = redisPoolMgr.hget(key, "lasttime");
                    if (lasttimeStr != null && !lasttimeStr.isEmpty()) {
                        score = Long.parseLong(lasttimeStr);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                redisPoolMgr.zadd("conversation:direct:" + userId, System.currentTimeMillis(), key, -1);
                redisPoolMgr.zadd(this.getConversationRightKey(userId), score, key, 604800);
                redisPoolMgr.zadd(CONVERSATION_QUEUE, System.currentTimeMillis(), key, 604800);
            }
            catch (Exception e) {
                Log.error("ConversationRedisCacheUtil->clearUnreadMsg: userid:{},targetid:{} error:{}", new Object[]{userId, targetId, e.getMessage()});
            }
        }
        return result;
    }

    public void clearAllUnreadMsg(String userId) {
        String key = this.getConversationRightKey(userId);
        try {
            Set convKeys = redisPoolMgr.zrange(key, 0L, -1L);
            convKeys.remove(CONVERSATION_RIGHT_HAD_INIT);
            for (String str : convKeys) {
                redisPoolMgr.hset(str, "unreadcount", "0");
            }
        }
        catch (Exception e) {
            Log.error("clearAllUnreadMsg  error, key:{}, userid:{}, err msg:{}", new Object[]{key, userId, e.getMessage()});
        }
    }

    @Override
    public void run() {
        Log.info("ConversationRedisCacheUtil task begin");
        if (redisPoolMgr != null) {
            try {
                Set conversationItmes;
                List<Map<String, String>> targetIdsList = new ArrayList();
                while ((conversationItmes = redisPoolMgr.zrange(CONVERSATION_QUEUE, 0L, 10L)).size() > 0) {
                    try {
                        targetIdsList = redisPoolMgr.batchHgetall(new ArrayList(conversationItmes));
                        if (targetIdsList.size() > 0) {
                            ConversationRedisCacheUtil.updateCon(targetIdsList);
                        }
                    }
                    catch (Exception e) {
                        Log.error("ConversationRedisCacheUtil task err ,targetIdsList:{}, msg:{}", targetIdsList, (Object)e.getMessage());
                    }
                    redisPoolMgr.batchZrem(CONVERSATION_QUEUE, conversationItmes);
                }
            }
            catch (Exception e) {
                Log.error("ConversationRedisCacheUtil error:{}", (Object)e.getMessage());
            }
        }
        Log.info("ConversationRedisCacheUtil task end");
    }

    private static final Set<String> zscan(String key, String pattern) {
        HashSet<String> list = new HashSet<String>();
        ScanParams scanParams = new ScanParams();
        scanParams.count(Integer.valueOf(5000));
        scanParams.match(pattern);
        String cursor = "0";
        try {
            ScanResult zscan;
            do {
                zscan = redisPoolMgr.zscan(key, cursor, scanParams);
                for (Tuple tuple : zscan.getResult()) {
                    list.add(tuple.getElement());
                }
            } while (!"0".equals(cursor = zscan.getStringCursor()));
        }
        catch (Exception e) {
            Log.error("ConversationRedisCacheUtil -> zscan,key,:{},pattern:{},err:{}", new Object[]{key, pattern, e.getMessage()});
        }
        return list;
    }

    private static final void updateCon(List<Map<String, String>> mapList) throws Exception {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            HashMap map = new HashMap();
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_IMRECENTCONVER);
            for (Map<String, String> mapTemp : mapList) {
                if (mapTemp == null) continue;
                String userId = mapTemp.get("userid");
                pstmt.setString(1, mapTemp.get("targetid"));
                pstmt.setString(2, userId);
                pstmt.addBatch();
            }
            long startTime = System.currentTimeMillis();
            pstmt.executeBatch();
            pstmt.clearBatch();
            DbConnectionManager.closeStatement((Statement)pstmt);
            if (mapList.size() > 0) {
                pstmt = con.prepareStatement(INSERT_IMRECENTCONVER);
                for (Map<String, String> mapTemp : mapList) {
                    pstmt.setString(1, mapTemp.get("userid"));
                    pstmt.setString(2, mapTemp.get("targetid"));
                    String isdel = mapTemp.get("isdel");
                    if (isdel == null || isdel.isEmpty()) {
                        isdel = "0";
                    }
                    pstmt.setInt(3, Integer.parseInt(isdel));
                    String istop = mapTemp.get("istop");
                    if (istop == null || istop.isEmpty()) {
                        istop = "0";
                    }
                    pstmt.setInt(4, Integer.parseInt(istop));
                    String unreadcount = mapTemp.get("unreadcount");
                    if (unreadcount == null || unreadcount.isEmpty()) {
                        unreadcount = "0";
                    }
                    pstmt.setInt(5, Integer.parseInt(unreadcount));
                    pstmt.setLong(6, System.currentTimeMillis());
                    pstmt.setString(7, mapTemp.get("sendId"));
                    pstmt.setString(8, mapTemp.get("targettype"));
                    pstmt.setString(9, mapTemp.get("msgid"));
                    pstmt.setString(10, mapTemp.get("msgcontent"));
                    pstmt.setString(11, mapTemp.get("targetname"));
                    pstmt.setString(12, mapTemp.get("lasttime"));
                    pstmt.setString(13, mapTemp.get("objectName"));
                    pstmt.setString(14, mapTemp.get("content"));
                    pstmt.setString(15, mapTemp.get("sharetypename"));
                    pstmt.setString(16, mapTemp.get("sharetype"));
                    pstmt.setString(17, mapTemp.get("isAt"));
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
                DbConnectionManager.closeStatement((Statement)pstmt);
            }
            pstmt = con.prepareStatement(DELETE_IMCONVERSATION);
            if (mapList.size() > 0) {
                for (Map<String, String> mapTemp : mapList) {
                    pstmt.setString(1, mapTemp.get("targetid"));
                    pstmt.addBatch();
                }
                long updateConbatch3StartTime = System.currentTimeMillis();
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
        }
        catch (Exception e) {
            try {
                Log.error(" ConversationRedisCacheUtil updateCon,map={},error:{},{}", new Object[]{mapList, e.getMessage(), e});
                throw e;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
    }

    private String getConversationRightKey(String userId) {
        return CONVERSATION_RIGHT + userId;
    }

    private String getConversationItmesKeyHead(String targetId) {
        return CONVERSATION_ITMES + targetId + ":";
    }

    private String getConversationTopKey(String userId) {
        return CONVERSATION_TOP + userId;
    }

    private String getUserName(String userid) {
        String userName = "";
        if (userid.indexOf("|") < 0) {
            userid = userid + "|" + ServerInfo.SYSTEM_UDID;
        }
        try {
            userName = UsernameUtil.getUserName(userid, userManager.getUser(userid).getName());
        }
        catch (Exception e) {
            Log.error("ConversationRedisCacheUtil->getUserName:userid:{},err:{}", (Object)userid, (Object)e.getMessage());
        }
        return userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Map<String, String>> getRecentConverByTargetId(String targetId) {
        Map<String, Map<String, String>> map;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block17: {
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("SELECT t1.userid,t1.targetid,t1.targettype,t1.targetname,t1.istop,t1.isdel,t1.unreadcount,t1.lasttime,t1.msgcontent,t1.msgid,t1.sendid,t1.objectname,t1.content,t1.sharetypename,t1.sharetype,t1.isAt, t3.description AS groupName,t3.groupIconUrl AS groupIconUrl, t3.groupType AS groupType,t3.isTop AS groupTop from social_IMRecentConver  t1 left join ofGroup t3 on t1.targetid = t3.groupName  where t1.targetid = ? ");
                pstmt.setString(1, targetId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String userId;
                    String targettype;
                    HashMap<String, CharSequence> map2 = new HashMap<String, CharSequence>();
                    String targetid = rs.getString("targetid");
                    if (targetid == null || targetid.isEmpty()) {
                        targetid = "";
                    }
                    if ((targettype = rs.getString("targettype")) == null || targettype.isEmpty()) {
                        targettype = (String)StringUtils.defaultIfEmpty((CharSequence)targettype, (CharSequence)"");
                    }
                    if ((userId = rs.getString("userid")) == null || userId.isEmpty()) {
                        userId = "";
                    }
                    map2.put("userid", userId);
                    map2.put("targetid", targetid);
                    map2.put("targettype", targettype);
                    String targetname = rs.getString("targetname");
                    if (targetname == null || targetname.isEmpty()) {
                        targetname = (String)StringUtils.defaultIfEmpty((CharSequence)targetname, (CharSequence)"");
                    }
                    map2.put("targetname", targetname);
                    String istop = rs.getString("istop");
                    if (istop == null || istop.isEmpty()) {
                        istop = "0";
                    }
                    map2.put("istop", istop);
                    String isdel = rs.getString("isdel");
                    if (isdel == null || isdel.isEmpty()) {
                        isdel = "0";
                    }
                    map2.put("isdel", isdel);
                    String lasttime = rs.getString("lasttime");
                    if ((lasttime == null || lasttime.isEmpty()) && (lasttime == null || lasttime.isEmpty())) {
                        Log.warn("getRecentConverByTargetId,lasttime is null,userId:{},targetid:{},targetType:{},targetname:{}", new Object[]{userId, targetid, targettype, targetname});
                        map = null;
                        break block17;
                    }
                    map2.put("lasttime", lasttime);
                    String msgcontent = rs.getString("msgcontent");
                    if (msgcontent == null || msgcontent.isEmpty()) {
                        msgcontent = (String)StringUtils.defaultIfEmpty((CharSequence)msgcontent, (CharSequence)"");
                    }
                    map2.put("msgcontent", msgcontent);
                    String unreadcount = rs.getString("unreadcount");
                    if (unreadcount == null || unreadcount.isEmpty()) {
                        unreadcount = "0";
                    }
                    map2.put("unreadcount", unreadcount);
                    String groupName = rs.getString("groupName");
                    if (groupName == null || groupName.isEmpty()) {
                        groupName = "";
                    }
                    map2.put("groupName", groupName);
                    String groupIconUrl = rs.getString("groupIconUrl");
                    if (groupIconUrl == null || groupIconUrl.isEmpty()) {
                        groupIconUrl = "";
                    }
                    map2.put("groupIconUrl", groupIconUrl);
                    String groupType = rs.getString("groupType");
                    map2.put("groupType", StringUtils.defaultIfEmpty((CharSequence)groupType, (CharSequence)"0"));
                    String groupTop = rs.getString("groupTop");
                    map2.put("groupTop", StringUtils.defaultIfEmpty((CharSequence)groupTop, (CharSequence)"0"));
                    String msgId = rs.getString("msgid");
                    map2.put("msgid", StringUtils.defaultIfEmpty((CharSequence)msgId, (CharSequence)""));
                    String sendid = rs.getString("sendid");
                    map2.put("sendId", StringUtils.defaultIfEmpty((CharSequence)sendid, (CharSequence)""));
                    String objectName = rs.getString("objectname");
                    map2.put("objectName", StringUtils.defaultIfEmpty((CharSequence)objectName, (CharSequence)""));
                    String content = rs.getString("content");
                    map2.put("content", StringUtils.defaultIfEmpty((CharSequence)content, (CharSequence)""));
                    String sharetypename = rs.getString("sharetypename");
                    map2.put("sharetypename", StringUtils.defaultIfEmpty((CharSequence)sharetypename, (CharSequence)""));
                    String sharetype = rs.getString("sharetype");
                    map2.put("sharetype", StringUtils.defaultIfEmpty((CharSequence)sharetype, (CharSequence)""));
                    String isAt = rs.getString("isAt");
                    map2.put("isAt", StringUtils.defaultIfEmpty((CharSequence)isAt, (CharSequence)""));
                    result.put(userId, map2);
                }
            }
            catch (Exception e) {
                try {
                    Log.error("getRecentConverByTargetId,targetId:{},error:{}", (Object)targetId, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                return result;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return result;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = scheduled;
        synchronized (scheduledThreadPoolExecutor) {
            if (!scheduled.isShutdown()) {
                sha = "";
                scheduled.shutdown();
                Log.info("ConversationRedisCacheUtil scheduled stop");
            }
        }
    }

    public boolean batchStoreRedisHset(Map<String, Map<String, String>> map, int expireSecond, boolean hsetnx) {
        return redisPoolMgr.batchStoreRedisHset(map, expireSecond, hsetnx);
    }

    public boolean delInvalidTargetId(String key, Set<String> set) {
        Log.info("delInvalidTargetId,key:{},set={}", (Object)key, set);
        boolean result = true;
        try {
            redisPoolMgr.zrem(key, set.toArray(new String[set.size()]));
        }
        catch (Exception e) {
            result = false;
            Log.error("ConversationRedisCacheUtil ->delInvalidTargetId  error,key:{},set:{}, err msg:{}", new Object[]{key, set, e.getMessage()});
        }
        return result;
    }
}

