/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.cache;

import com.weaver.util.cluster.redis.ClusterRedisPoolMgr;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Message;

public class HasRoutedMessageCacheUtil {
    private static Logger Log = LoggerFactory.getLogger(HasRoutedMessageCacheUtil.class);
    private static HasRoutedMessageCacheUtil instance = null;
    private static ClusterRedisPoolMgr redisPoolMgr = null;
    private static String keyFlag = "HasRouted:MsgId:";
    private static String MsgIDKeyFlag = "HasRouted:Message:";
    private static final int POOL_SIZE = 100;
    private static BlockingQueue<SAXReader> xmlReaders = new LinkedBlockingQueue<SAXReader>(100);

    private HasRoutedMessageCacheUtil() {
    }

    private static void initSaxReader() throws IllegalStateException {
        xmlReaders = new LinkedBlockingQueue<SAXReader>(100);
        for (int i = 0; i < 100; ++i) {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            xmlReaders.add(xmlReader);
        }
    }

    public static synchronized HasRoutedMessageCacheUtil getInstance() {
        if (instance == null) {
            redisPoolMgr = ClusterRedisPoolMgr.getInstance();
            if (redisPoolMgr == null) {
                Log.warn("redis is not install or redis running error.");
            } else {
                instance = new HasRoutedMessageCacheUtil();
            }
        }
        return instance;
    }

    public List<Message> getMessages(String JID2, long index, long end, int size) {
        ArrayList<Message> list = new ArrayList<Message>();
        return list;
    }

    public void put(String JID2, Message message, long times) {
        String msgID = message.getID();
        Log.info("saveHasRoutedMessage to redis.jid:{},msgid:{}", (Object)JID2, (Object)msgID);
    }

    public boolean delHasRouteMessage(String JID2, String msgId) {
        boolean deleteNum = false;
        Log.info("removeHasRoutedMessage from redis.JID:{},msgId:{}", (Object)JID2, (Object)msgId);
        return deleteNum;
    }

    private Message getMessage(String json) {
        SAXReader xmlReader = null;
        Message message = null;
        try {
            try {
                xmlReader = xmlReaders.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (xmlReader == null) {
                xmlReader = new SAXReader();
            }
            message = new Message(xmlReader.read((Reader)new StringReader(json)).getRootElement());
        }
        catch (Exception e) {
            Log.error("str to message error,json:{},error:{}", (Object)json, (Object)e.getMessage());
        }
        return message;
    }

    static {
        try {
            HasRoutedMessageCacheUtil.initSaxReader();
            Log.info("done init SaxReader, size:{}", (Object)100);
        }
        catch (IllegalStateException e) {
            Log.error("Error!!! init SaxReader failed, emessage will be unusable, err={}", (Object)e.getMessage());
        }
    }
}

