/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.emessage.multirouter.messagemanager.MessageStatisticsUtil;
import com.weaver.msg.encrypt.EncryptUtil;
import com.weaver.util.ServerCheckUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.TimerTaskUtil;
import com.weaver.util.subtable.historymsg.CreateHistoryMsgTableUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.database.SchemaManager;
import org.jivesoftware.openfire.plugin.cache.MsgReadUtil;
import org.jivesoftware.openfire.plugin.util.ConverIDUtil;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.UDIDUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryMessageRedisCacheUtil
implements Runnable {
    private static final Logger Log = LoggerFactory.getLogger(HistoryMessageRedisCacheUtil.class);
    private static final ReentrantLock reentrantLock = new ReentrantLock();
    public static final String HISTORY_MSG = "history:msg:";
    public static final String HISTORY_MSG_SYNC = "sync:history:msg:";
    private static ScheduledThreadPoolExecutor scheduled;
    private static final String HISTORY_TO_DB_QUEUE = "history:queue";
    private static final String HISTORY_CONVERSATION = "history:conv:";
    private static final String HISTORY_TO_DB_QUEUE_ERROR = "history:errorqueue";
    private static HistoryMessageRedisCacheUtil instance;
    private static RedisPoolMgr redisPoolMgr;
    private static final int MAX_MESSAGE_STORE_QUANTITY_OF_TARGETID = 500;
    private static final int HISTORYMSG_EXPIRE;
    private static String INSERT_HISTORYMSG;
    private static String INSERT_HISTORYMSGRECENTLY;
    private static String INSERT_HISTORYMSGRECENTLY_oracle;
    private static String INSERT_HISTORYMSGRECENTLY_mysql;
    private static String INSERT_SOCIALHISTORYMSGRIGHT;
    private static String INSERT_SOCIALHISTORYMSGRECENTLYRIGHT;
    private static String SELECT_SOCIAL_HISTORYMSGRIGHT_BY_MSGID;

    private HistoryMessageRedisCacheUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static HistoryMessageRedisCacheUtil getInstance() {
        if (instance == null) {
            Class<HistoryMessageRedisCacheUtil> clazz = HistoryMessageRedisCacheUtil.class;
            // MONITORENTER : org.jivesoftware.openfire.plugin.cache.HistoryMessageRedisCacheUtil.class
            if (instance == null) {
                instance = new HistoryMessageRedisCacheUtil();
                boolean needRunTimerTaskUtil = TimerTaskUtil.needRunTimerTaskUtil();
                if (needRunTimerTaskUtil) {
                    HistoryMessageRedisCacheUtil.start();
                    Log.info("HistoryMessageRedisCacheUtil scheduled start");
                }
            }
            // MONITOREXIT : clazz
        }
        if ((redisPoolMgr = RedisPoolMgr.getInstance()) != null) return instance;
        return null;
    }

    public boolean saveHistoryMsg(String msgid, Map<String, String> map, Set<String> userRight) {
        boolean result = true;
        try {
            String targetid = map.get("targetid");
            int targetType = Integer.parseInt(map.get("targetType"));
            String msgKey = this.getMsgKey(msgid, targetid, targetType);
            String msgSyncKey = this.getMsgSyncKey(msgid, targetid, targetType);
            if (!"1".equals(map.get("targetType"))) {
                targetid = ConverIDUtil.genaralTargetId(targetid, map.get("fromUserId"));
            }
            HashSet<String> zaddKeys = new HashSet<String>();
            for (String userid : userRight) {
                zaddKeys.add(this.getConversationIDKey(targetid, userid, targetType));
            }
            Long dateTime = Long.parseLong(map.get("sendTime"));
            redisPoolMgr.batchzaddKey(zaddKeys, dateTime.longValue(), msgKey, HISTORYMSG_EXPIRE);
            for (Map.Entry<String, String> i : map.entrySet()) {
                if (i.getValue() != null) continue;
                i.setValue("");
            }
            boolean hmset1 = redisPoolMgr.hmset(msgKey, map, HISTORYMSG_EXPIRE);
            boolean hmset2 = redisPoolMgr.hmset(msgSyncKey, map, -1);
            boolean zadd = redisPoolMgr.zadd(HISTORY_TO_DB_QUEUE, dateTime.longValue(), msgSyncKey, -1) == 0;
            result = hmset1 && hmset2 && zadd;
        }
        catch (Exception e) {
            result = false;
            Log.error("record msg error :{} ", (Throwable)e);
        }
        return result;
    }

    public boolean batchSaveHistoryMsg(int targetType, String fromUserId, String targetId, List<Map<String, String>> maps, boolean isLastOne) {
        HashMap<String, Map<String, String>> keys_map = new HashMap<String, Map<String, String>>();
        HashMap<String, Double> scoreMembers = new HashMap<String, Double>();
        for (Map<String, String> temp : maps) {
            String msgkey = this.getMsgKey(temp.get("timestamp"), fromUserId, targetType);
            keys_map.put(msgkey, temp);
            scoreMembers.put(msgkey, Double.parseDouble(temp.get("sendTime")));
        }
        if (targetType != 1) {
            targetId = ConverIDUtil.genaralTargetId(targetId, fromUserId);
        }
        if (isLastOne) {
            scoreMembers.put("history:msg:0", 0.0);
        }
        redisPoolMgr.zadd(this.getConversationIDKey(targetId, fromUserId, targetType), scoreMembers, HISTORYMSG_EXPIRE);
        return redisPoolMgr.batchHmset(keys_map, HISTORYMSG_EXPIRE);
    }

    public boolean updateHistoryMsg(String msgid, String className, String userId) {
        if (redisPoolMgr.exists(HISTORY_MSG + msgid)) {
            redisPoolMgr.hsetex(HISTORY_MSG + msgid, "objectName", className, HISTORYMSG_EXPIRE);
            redisPoolMgr.hsetex(HISTORY_MSG + msgid, "content", "withdraw", HISTORYMSG_EXPIRE);
            HashMap<String, String> extra = new HashMap<String, String>();
            extra.put("msg_id", msgid);
            extra.put("receiverids", "");
            extra.put("withdrawUserId", userId);
            DatabaseUtil db = new DatabaseUtil();
            extra.put("msg_at_userid", db.getMsgAtUserId(msgid, userId, null));
            HashMap<String, Object> fullAmount = new HashMap<String, Object>();
            fullAmount.put("extra", extra);
            fullAmount.put("content", "withdraw");
            fullAmount.put("objectName", "RC:InfoNtf:withdraw:RC:TxtMsg");
            redisPoolMgr.hsetex(HISTORY_MSG + msgid, "extra", JSON.toJSONString(extra), HISTORYMSG_EXPIRE);
            redisPoolMgr.hsetex(HISTORY_MSG + msgid, "fullAmount", JSON.toJSONString(fullAmount), HISTORYMSG_EXPIRE);
            if (redisPoolMgr.exists(HISTORY_MSG_SYNC + msgid)) {
                redisPoolMgr.hsetex(HISTORY_MSG_SYNC + msgid, "objectName", className, -1);
                redisPoolMgr.hsetex(HISTORY_MSG_SYNC + msgid, "content", "withdraw", -1);
                redisPoolMgr.hsetex(HISTORY_MSG_SYNC + msgid, "extra", JSON.toJSONString(extra), -1);
                redisPoolMgr.hsetex(HISTORY_MSG_SYNC + msgid, "fullAmount", JSON.toJSONString(fullAmount), -1);
            }
            return redisPoolMgr.zrank(HISTORY_TO_DB_QUEUE, HISTORY_MSG_SYNC + msgid);
        }
        return false;
    }

    public Map<String, Object> getHistoryList(int targetType, String fromUserId, String targetId, Long lastTime, int pageSize, String fromResource) {
        String redisKey;
        ArrayList list;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet msgIdSet = new HashSet();
        result.put("reload", "-1");
        if (targetType != 1) {
            targetId = ConverIDUtil.genaralTargetId(targetId, fromUserId);
        }
        int offset = 0;
        if (lastTime < System.currentTimeMillis()) {
            ++pageSize;
        }
        if ((list = new ArrayList(redisPoolMgr.zrevrangeByScore(redisKey = this.getConversationIDKey(targetId, fromUserId, targetType), Long.valueOf(0L), lastTime, offset, pageSize))).contains("history:msg:0")) {
            result.put("reload", "0");
            list.remove("history:msg:0");
        }
        redisPoolMgr.deleteExpiredData(redisKey, 500);
        ArrayList<Map<String, String>> msgObj = new ArrayList<Map<String, String>>();
        DatabaseUtil db = new DatabaseUtil();
        ArrayList<String> invalMsgIdList = new ArrayList<String>();
        for (String msgId : list) {
            if (msgObj.size() > pageSize) continue;
            String realMsgId = msgId.replace(HISTORY_MSG, "");
            Map<String, String> historyMap = db.getMsgById(realMsgId, fromUserId, false, fromResource);
            if (historyMap != null && !historyMap.isEmpty()) {
                msgObj.add(historyMap);
                continue;
            }
            result.put("reload", "0");
            try {
                Double score = redisPoolMgr.zscore(redisKey, msgId);
                Set expireData = redisPoolMgr.zrangeByScore(redisKey, 0.0, score.doubleValue());
                if (expireData == null || expireData.size() <= 0) break;
                redisPoolMgr.batchZrem(redisKey, expireData);
            }
            catch (Exception exception) {}
            break;
        }
        result.put("msgObj", msgObj);
        result.put("msgIdSet", msgIdSet);
        if (invalMsgIdList.size() > 0) {
            this.delInvalidMsg(this.getConversationIDKey(targetId, fromUserId, targetType), invalMsgIdList);
            result.put("reload", "1");
        }
        return result;
    }

    @Override
    public void run() {
        Log.info("HistoryMessageRedisCacheUtil task begin");
        ServerCheckUtil.setHistoryTaskRunning();
        if (redisPoolMgr != null) {
            try {
                Set msgSet;
                while ((msgSet = redisPoolMgr.zrange(HISTORY_TO_DB_QUEUE, 0L, 10L)).size() > 0) {
                    List msgidsList = redisPoolMgr.batchHgetall(new ArrayList(msgSet));
                    ArrayList<Map<String, String>> msgList = new ArrayList<Map<String, String>>();
                    for (Map msgTemp : msgidsList) {
                        if (msgTemp.size() == 0) continue;
                        msgList.add(msgTemp);
                    }
                    try {
                        HistoryMessageRedisCacheUtil.record2Db(msgList);
                    }
                    catch (Exception e) {
                        Log.error("HistoryMessageRedisCacheUtil e :{}", (Throwable)e);
                        ArrayList<String> msgErrorList = new ArrayList<String>();
                        for (Map map : msgList) {
                            msgErrorList.add(JSON.toJSONString((Object)map));
                        }
                        redisPoolMgr.batchzaddKey(HISTORY_TO_DB_QUEUE_ERROR, System.currentTimeMillis(), msgErrorList, -1);
                        ServerCheckUtil.setHistoryRecordErrInfo((String)e.getMessage());
                    }
                    for (String msgId : msgSet) {
                        if (msgId == null || !msgId.startsWith("sync")) continue;
                        redisPoolMgr.del(msgId);
                    }
                    redisPoolMgr.batchZrem(HISTORY_TO_DB_QUEUE, msgSet);
                }
            }
            catch (Exception e) {
                Log.error("HistoryMessageRedisCacheUtil error:{},ex:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        Log.info("HistoryMessageRedisCacheUtil task end");
    }

    private String getConversationIDKey(String targetId, String userId, int targetType) {
        StringBuilder sbld = new StringBuilder(HISTORY_CONVERSATION);
        sbld.append(targetId);
        sbld.append(":");
        sbld.append(userId);
        return sbld.toString();
    }

    private static String getInsertHistoryMsgSQL(String sendTime) {
        String tableName = "HistoryMsg";
        if (JiveGlobals.getBooleanProperty((String)"subtable.historyMsg", (boolean)false)) {
            tableName = CreateHistoryMsgTableUtil.getTableName((String)sendTime);
        }
        String sql = "INSERT INTO " + tableName + " (fromUserId,targetId,targetType,GroupId,classname,msgContent,extra,type,imageUri,dateTime,msgid,fullAmount,updatetime) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        return sql;
    }

    private static final void recordHistoryMsg(Map<String, String> map) throws SQLException {
        boolean abortTransaction = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = DbConnectionManager.getTransactionConnection();
            SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String sendTime = SDF_ALL_TIME_FORMAT.format(Long.parseLong(map.get("sendTime")));
            String updateTime = SDF_ALL_TIME_FORMAT.format(new Date());
            String imgUrl = map.get("imgUrl");
            if (imgUrl != null && imgUrl.length() > 100) {
                imgUrl = imgUrl.substring(imgUrl.length() - 100);
                Log.error("imgUrl>100,map:{}", map);
            }
            DbConnectionManager.closeStatement(pstmt);
            String InsertHistoryMsgSQL = HistoryMessageRedisCacheUtil.getInsertHistoryMsgSQL(sendTime);
            pstmt = conn.prepareStatement(InsertHistoryMsgSQL);
            pstmt.setString(1, map.get("fromUserId"));
            pstmt.setString(2, map.get("targetid"));
            pstmt.setInt(3, Integer.parseInt(map.get("targetType")) + 1);
            pstmt.setString(4, map.get("GroupId"));
            pstmt.setString(5, map.get("objectName"));
            if (EncryptUtil.isEncryptEnable()) {
                pstmt.setString(6, EncryptUtil.encrypt((String)map.get("content")));
                pstmt.setString(7, EncryptUtil.encrypt((String)map.get("extra")));
                pstmt.setString(12, EncryptUtil.encrypt((String)map.get("fullAmount")));
            } else {
                pstmt.setString(6, map.get("content"));
                pstmt.setString(7, map.get("extra"));
                pstmt.setString(12, map.get("fullAmount"));
            }
            pstmt.setString(8, map.get("type"));
            pstmt.setString(9, imgUrl);
            pstmt.setString(10, sendTime);
            pstmt.setString(11, map.get("msgid"));
            pstmt.setString(13, updateTime);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                abortTransaction = true;
                Log.error("\u5b58\u5165\u6570\u636e\u5f02\u5e38:HISTORYMSG msg:{},err:{}", map, (Object)e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection((Connection)conn, (boolean)abortTransaction);
                throw throwable;
            }
        }
        DbConnectionManager.closeStatement((Statement)pstmt);
        DbConnectionManager.closeTransactionConnection((Connection)conn, (boolean)abortTransaction);
    }

    private static final void recordHistoryMsg(List<Map<String, String>> list) throws SQLException {
        for (Map<String, String> map : list) {
            HistoryMessageRedisCacheUtil.recordHistoryMsg(map);
        }
    }

    private static void record2Db(List<Map<String, String>> list) throws Exception {
        if (JiveGlobals.getBooleanProperty((String)"update.history.batch", (boolean)false)) {
            for (Map<String, String> map : list) {
                HistoryMessageRedisCacheUtil.record2Db(map);
            }
        } else {
            HistoryMessageRedisCacheUtil.record2DbBatch(list);
        }
    }

    private static final void record2Db(Map<String, String> map) throws SQLException {
        boolean abortTransaction = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            long strtime;
            long sendtime;
            String str;
            String imgUrl;
            conn = DbConnectionManager.getTransactionConnection();
            SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String sendTime = SDF_ALL_TIME_FORMAT.format(Long.parseLong(map.get("sendTime")));
            String updateTime = SDF_ALL_TIME_FORMAT.format(new Date());
            String delUserIds = null;
            if (map != null && map.containsKey("delUsers")) {
                delUserIds = map.get("delUsers");
            }
            List<Object> delUser = new ArrayList();
            if (delUserIds != null) {
                delUser = UDIDUtil.getList(delUserIds);
            }
            if ((imgUrl = map.get("imgUrl")) != null && imgUrl.length() > 100) {
                imgUrl = imgUrl.substring(imgUrl.length() - 100);
                Log.error("imgUrl>100,map:{}", map);
            }
            List<String> userRightList = Arrays.asList(map.get("userRight").split(","));
            DbConnectionManager.closeStatement(pstmt);
            String InsertHistoryMsgSQL = HistoryMessageRedisCacheUtil.getInsertHistoryMsgSQL(sendTime);
            pstmt = conn.prepareStatement(InsertHistoryMsgSQL);
            pstmt.setString(1, map.get("fromUserId"));
            pstmt.setString(2, map.get("targetid"));
            pstmt.setInt(3, Integer.parseInt(map.get("targetType")) + 1);
            pstmt.setString(4, map.get("GroupId"));
            if (EncryptUtil.isEncryptEnable()) {
                pstmt.setString(6, EncryptUtil.encrypt((String)map.get("content")));
                pstmt.setString(7, EncryptUtil.encrypt((String)map.get("extra")));
                pstmt.setString(12, EncryptUtil.encrypt((String)map.get("fullAmount")));
            } else {
                pstmt.setString(6, map.get("content"));
                pstmt.setString(7, map.get("extra"));
                pstmt.setString(12, map.get("fullAmount"));
            }
            pstmt.setString(5, map.get("objectName"));
            pstmt.setString(8, map.get("type"));
            pstmt.setString(9, imgUrl);
            pstmt.setString(10, sendTime);
            pstmt.setString(11, map.get("msgid"));
            pstmt.setString(13, updateTime);
            pstmt.executeUpdate();
            String sql = INSERT_HISTORYMSGRECENTLY;
            if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sql = INSERT_HISTORYMSGRECENTLY_oracle;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = INSERT_HISTORYMSGRECENTLY_mysql;
            }
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, map.get("fromUserId"));
            pstmt.setString(2, map.get("targetid"));
            pstmt.setInt(3, Integer.parseInt(map.get("targetType")) + 1);
            pstmt.setString(4, map.get("GroupId"));
            pstmt.setString(5, map.get("objectName"));
            if (EncryptUtil.isEncryptEnable()) {
                pstmt.setString(6, EncryptUtil.encrypt((String)map.get("content")));
                pstmt.setString(7, EncryptUtil.encrypt((String)map.get("extra")));
                pstmt.setString(12, EncryptUtil.encrypt((String)map.get("fullAmount")));
            } else {
                pstmt.setString(6, map.get("content"));
                pstmt.setString(7, map.get("extra"));
                pstmt.setString(12, map.get("fullAmount"));
            }
            pstmt.setString(8, map.get("type"));
            pstmt.setString(9, imgUrl);
            pstmt.setString(10, sendTime);
            pstmt.setString(11, map.get("msgid"));
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
            pstmt = conn.prepareStatement(INSERT_SOCIALHISTORYMSGRIGHT);
            for (String useridString : userRightList) {
                str = redisPoolMgr.get("emptyHistoryMsgByConver:" + map.get("GroupId") + ":" + useridString);
                if (str != null && !str.isEmpty() && (sendtime = Long.parseLong(map.get("sendTime"))) - (strtime = Long.parseLong(str)) < 0L) {
                    Log.info("record2Db conversation has empty no db map :{} ,userid :{} ", (Object)useridString);
                    continue;
                }
                if (delUser != null && !delUser.isEmpty() && delUser.contains(useridString)) {
                    Log.info("record2Db msg has delete no db map :{},userid :{}  ", map, (Object)useridString);
                    continue;
                }
                pstmt.setString(1, useridString);
                pstmt.setString(2, map.get("msgid"));
                pstmt.setInt(3, 0);
                pstmt.setString(4, sendTime);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
            if (JiveGlobals.getBooleanProperty((String)"xmpp.social_hisotymsgrecentlyright.save", (boolean)false)) {
                DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
                pstmt = null;
                pstmt = conn.prepareStatement(INSERT_SOCIALHISTORYMSGRECENTLYRIGHT);
                for (String useridString : userRightList) {
                    str = redisPoolMgr.get("emptyHistoryMsgByConver:" + map.get("GroupId") + ":" + useridString);
                    if (str != null && !str.isEmpty() && (sendtime = Long.parseLong(map.get("sendTime"))) - (strtime = Long.parseLong(str)) < 0L || delUser != null && !delUser.isEmpty() && delUser.contains(useridString)) continue;
                    pstmt.setString(1, useridString);
                    pstmt.setString(2, map.get("msgid"));
                    pstmt.setInt(3, 0);
                    pstmt.setString(4, sendTime);
                    pstmt.setString(5, map.get("GroupId"));
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                abortTransaction = true;
                Log.error("\u5b58\u5165\u6570\u636e\u5f02\u5e38:HISTORYMSG msg:{},err:{}", map, (Object)e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection((Connection)conn, (boolean)abortTransaction);
                throw throwable;
            }
        }
        DbConnectionManager.closeStatement((Statement)pstmt);
        DbConnectionManager.closeTransactionConnection((Connection)conn, (boolean)abortTransaction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void record2DbBatch(List<Map<String, String>> list) throws Exception {
        boolean abortTransaction = false;
        Connection conn = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        PreparedStatement pstmt4 = null;
        boolean a = false;
        int b = 0;
        int c = 0;
        int d = 0;
        try {
            conn = DbConnectionManager.getTransactionConnection();
            HistoryMessageRedisCacheUtil.recordHistoryMsg(list);
            String sql = INSERT_HISTORYMSGRECENTLY;
            if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sql = INSERT_HISTORYMSGRECENTLY_oracle;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = INSERT_HISTORYMSGRECENTLY_mysql;
            }
            pstmt2 = conn.prepareStatement(sql);
            pstmt3 = conn.prepareStatement(INSERT_SOCIALHISTORYMSGRIGHT);
            pstmt4 = conn.prepareStatement(INSERT_SOCIALHISTORYMSGRECENTLYRIGHT);
        }
        catch (Exception e) {
            Log.error(" HistoryMessageRedisCacheUtil e :{} ", (Throwable)e);
        }
        boolean i = false;
        for (Map<String, String> map : list) {
            long strtime;
            long sendtime;
            String str;
            DatabaseUtil du;
            boolean msgExisted;
            boolean checkMessage;
            String imgUrl = map.get("imgUrl");
            if (imgUrl != null && imgUrl.length() > 100) {
                imgUrl = imgUrl.substring(imgUrl.length() - 100);
                Log.error("imgUrl>100,map:{}", map);
            }
            List<String> userRightList = Arrays.asList(map.get("userRight").split(","));
            String fromUserId = map.get("fromUserId");
            int targetType = Integer.parseInt(map.get("targetType")) + 1;
            String objectName = map.get("objectName");
            String groupId = map.get("GroupId");
            SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String sendTime = SDF_ALL_TIME_FORMAT.format(Long.parseLong(map.get("sendTime")));
            String updateTime = SDF_ALL_TIME_FORMAT.format(new Date());
            String delUserIds = null;
            if (map != null && map.containsKey("delUsers")) {
                delUserIds = map.get("delUsers");
            }
            List<Object> delUser = new ArrayList();
            if (delUserIds != null) {
                delUser = UDIDUtil.getList(delUserIds);
            }
            if ((checkMessage = JiveGlobals.getBooleanProperty((String)"checkMessage", (boolean)false)) && (msgExisted = (du = new DatabaseUtil()).isHistoryMsgExisted(map.get("targetid"), map.get("msgid")))) {
                String jsonString = JSON.toJSONString(map);
                SchemaManager.writeErrorSqlToFile((String)jsonString, (String)"", (String)"historyMessage.txt");
                return;
            }
            pstmt2.setString(1, map.get("fromUserId"));
            pstmt2.setString(2, map.get("targetid"));
            pstmt2.setInt(3, Integer.parseInt(map.get("targetType")) + 1);
            pstmt2.setString(4, map.get("GroupId"));
            pstmt2.setString(5, map.get("objectName"));
            if (EncryptUtil.isEncryptEnable()) {
                pstmt2.setString(6, EncryptUtil.encrypt((String)map.get("content")));
                pstmt2.setString(7, EncryptUtil.encrypt((String)map.get("extra")));
                pstmt2.setString(12, EncryptUtil.encrypt((String)map.get("fullAmount")));
            } else {
                pstmt2.setString(6, map.get("content"));
                pstmt2.setString(7, map.get("extra"));
                pstmt2.setString(12, map.get("fullAmount"));
            }
            pstmt2.setString(8, map.get("type"));
            pstmt2.setString(9, imgUrl);
            pstmt2.setString(10, sendTime);
            pstmt2.setString(11, map.get("msgid"));
            pstmt2.addBatch();
            ++b;
            for (String useridString : userRightList) {
                str = redisPoolMgr.get("emptyHistoryMsgByConver:" + map.get("GroupId") + ":" + useridString);
                if (str != null && !str.isEmpty() && (sendtime = Long.parseLong(map.get("sendTime"))) - (strtime = Long.parseLong(str)) < 0L) {
                    Log.info("record2Db conversation has empty no db map :{} ,userid :{} ", (Object)useridString);
                    continue;
                }
                if (delUser != null && !delUser.isEmpty() && delUser.contains(useridString)) {
                    Log.info("record2Db msg has delete no db map :{},userid :{}  ", map, (Object)useridString);
                    continue;
                }
                pstmt3.setString(1, useridString);
                pstmt3.setString(2, map.get("msgid"));
                pstmt3.setInt(3, 0);
                pstmt3.setString(4, sendTime);
                pstmt3.addBatch();
                ++c;
            }
            if (JiveGlobals.getBooleanProperty((String)"xmpp.social_hisotymsgrecentlyright.save", (boolean)false)) {
                for (String useridString : userRightList) {
                    str = redisPoolMgr.get("emptyHistoryMsgByConver:" + map.get("GroupId") + ":" + useridString);
                    if (str != null && !str.isEmpty() && (sendtime = Long.parseLong(map.get("sendTime"))) - (strtime = Long.parseLong(str)) < 0L || delUser != null && !delUser.isEmpty() && delUser.contains(useridString)) continue;
                    pstmt4.setString(1, useridString);
                    pstmt4.setString(2, map.get("msgid"));
                    pstmt4.setInt(3, 0);
                    pstmt4.setString(4, sendTime);
                    pstmt4.setString(5, map.get("GroupId"));
                    pstmt4.addBatch();
                    ++d;
                }
            }
            if (!JiveGlobals.getBooleanProperty((String)"message.statistics", (boolean)true) || targetType != 1 && targetType != 2) continue;
            MessageStatisticsUtil.recordMsg2Redis(fromUserId, userRightList, targetType, groupId);
        }
        try {
            pstmt2.executeBatch();
            pstmt2.clearBatch();
            pstmt3.executeBatch();
            pstmt3.clearBatch();
            pstmt4.executeBatch();
            pstmt4.clearBatch();
        }
        catch (SQLException e) {
            try {
                abortTransaction = true;
                Log.error("\u5b58\u5165\u6570\u636e\u5f02\u5e38:msg:{},err:{}", list, (Object)e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DbConnectionManager.closeStatement((Statement)pstmt2);
                    DbConnectionManager.closeStatement((Statement)pstmt3);
                    DbConnectionManager.closeStatement(pstmt4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DbConnectionManager.closeTransactionConnection((Connection)conn, (boolean)abortTransaction);
                throw throwable;
            }
        }
        try {
            DbConnectionManager.closeStatement((Statement)pstmt2);
            DbConnectionManager.closeStatement((Statement)pstmt3);
            DbConnectionManager.closeStatement((Statement)pstmt4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DbConnectionManager.closeTransactionConnection((Connection)conn, (boolean)abortTransaction);
    }

    public static void stop() {
        reentrantLock.lock();
        if (!scheduled.isShutdown()) {
            scheduled.shutdown();
            Log.info("HistoryMessageRedisCacheUtil scheduled stop");
        }
        reentrantLock.unlock();
    }

    private static void start() {
        scheduled = new ScheduledThreadPoolExecutor(1);
        int historyMsgExcuteTime = JiveGlobals.getIntProperty((String)"xmpp.historyMsg.excuteTime", (int)300);
        if (historyMsgExcuteTime < 30) {
            historyMsgExcuteTime = 30;
        }
        scheduled.scheduleAtFixedRate(instance, 10L, historyMsgExcuteTime, TimeUnit.SECONDS);
    }

    public static void reStart() {
        reentrantLock.lock();
        if (!scheduled.isShutdown()) {
            scheduled.shutdown();
            Log.info("HistoryMessageRedisCacheUtil scheduled had stopped");
        }
        if (scheduled.isShutdown()) {
            HistoryMessageRedisCacheUtil.start();
            Log.info("HistoryMessageRedisCacheUtil had restarted");
        }
        reentrantLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getMsgReceiverIds(String msgId) {
        String userRight;
        HashSet<String> result = new HashSet<String>();
        if (redisPoolMgr != null && (userRight = redisPoolMgr.hget(HISTORY_MSG + msgId, "userRight")) != null) {
            result.addAll(Arrays.asList(userRight.split(",")));
            return result;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(SELECT_SOCIAL_HISTORYMSGRIGHT_BY_MSGID);
            pstmt.setString(1, msgId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                result.add(rs.getString("userId"));
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getMsgReceiverIds,msgid:{},err:{}", (Object)msgId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        if (redisPoolMgr != null) {
            redisPoolMgr.hsetex(HISTORY_MSG + msgId, "userRight", StringUtils.join(result, (String)","), HISTORYMSG_EXPIRE);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delInvalidMsg(String key, List<String> set) {
        Log.info("delInvalidMsg,key:{},set={}", (Object)key, set);
        boolean result = true;
        try {
            redisPoolMgr.zrem(key, set.toArray(new String[set.size()]));
        }
        catch (Exception e) {
            result = false;
            Log.error("HistoryMessageRedisCacheUtil ->delInvalidMsg  error,key:{},set:{}, err msg:{}", new Object[]{key, set, e.getMessage()});
        }
        return result;
    }

    public void updateDingClassName(String messageId, String msgContent) {
        String messagekey = HISTORY_MSG + messageId;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("objectName", "FW:CMDMsg");
        map.put("content", msgContent);
        redisPoolMgr.hmset(messagekey, map, -1);
    }

    public void revertDingClassName(String messageId, String msgContent) {
        String messagekey = HISTORY_MSG + messageId;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("objectName", "RC:TxtMsg");
        map.put("content", msgContent);
        redisPoolMgr.hmset(messagekey, map, -1);
    }

    private String getMsgKey(String msgid, String targetId, Integer targetType) {
        StringBuilder key = new StringBuilder(HISTORY_MSG);
        key.append(msgid);
        if (targetType > 100) {
            key.append(":");
            key.append(targetId);
        }
        return key.toString();
    }

    private String getMsgSyncKey(String msgid, String targetId, Integer targetType) {
        StringBuilder key = new StringBuilder(HISTORY_MSG_SYNC);
        key.append(msgid);
        if (targetType > 100) {
            key.append(":");
            key.append(targetId);
        }
        return key.toString();
    }

    private String getConversationContent(String sendId, String msgcontent, String objectName) {
        String pushContent;
        try {
            String ding;
            JSONObject jsonJSON;
            String para;
            JSONObject paraJSON;
            JSONObject msgcontentJSON;
            pushContent = msgcontent;
            if (objectName.equals("RC:VcMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.Vc", (String)"multirouter");
            }
            if (objectName.equals("RC:LBSMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.lbs", (String)"multirouter");
            }
            if (objectName.equals("FW:UniteMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.uniteMsg", (String)"multirouter");
            }
            if ("RC:ExpMsg".equals(objectName)) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.ExpMsg", (String)"multirouter");
            }
            if (objectName.equals("RC:ImgMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.img", (String)"multirouter");
            }
            if (objectName.equals("FW:CustomMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.shake", (String)"multirouter");
            }
            if (objectName.equals("FW:attachmentMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.attachment", (String)"multirouter") + msgcontent;
            }
            if (objectName.equals("FW:CustomShareMsg") || objectName.equals("FW:CustomShareMsgVote")) {
                pushContent = msgcontent;
            }
            if ("FW:VoIPMsg".equals(objectName)) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.VoIPMsg", (String)"multirouter") + msgcontent;
            }
            if ("FW:Extension_Msg".equals(objectName)) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.Extension_Msg", (String)"multirouter");
            }
            if (objectName.equals("RC:PublicNoticeMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.PublicNotice", (String)"multirouter") + msgcontent;
            }
            if (objectName.equals("FW:PersonCardMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.PersonCard", (String)"multirouter") + msgcontent;
            }
            if ("FW:CMDMsg".equals(objectName) && (msgcontentJSON = JSON.parseObject((String)msgcontent)) != null && msgcontentJSON.containsKey((Object)"para") && (paraJSON = JSON.parseObject((String)(para = msgcontentJSON.getString("para")))) != null && paraJSON.containsKey((Object)"ding") && (jsonJSON = JSON.parseObject((String)(ding = paraJSON.getString("ding")))) != null && jsonJSON.containsKey((Object)"content")) {
                pushContent = jsonJSON.getString("content");
            }
        }
        catch (Exception e) {
            Log.error("getConversationMsgContent,error:{},senderId:{},objectName:{},msgContent:{}", new Object[]{e.getMessage(), sendId, objectName, msgcontent});
            pushContent = msgcontent;
        }
        return pushContent;
    }

    private String getConversationMsgContent(String sendId, String msgcontent, String objectName) {
        String pushContent;
        try {
            String ding;
            JSONObject jsonJSON;
            String para;
            JSONObject paraJSON;
            JSONObject msgcontentJSON;
            User user = UserManager.getInstance().getUser(sendId + "|" + ServerInfo.SYSTEM_UDID.toLowerCase());
            String pushBeforeText = user.getName() + "";
            pushContent = pushBeforeText + ":" + msgcontent;
            if (objectName.equals("RC:VcMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.Vc", (String)"multirouter");
            }
            if (objectName.equals("RC:LBSMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.lbs", (String)"multirouter");
            }
            if (objectName.equals("FW:UniteMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.uniteMsg", (String)"multirouter");
            }
            if ("RC:ExpMsg".equals(objectName)) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.ExpMsg", (String)"multirouter");
            }
            if (objectName.equals("RC:ImgMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.img", (String)"multirouter");
            }
            if (objectName.equals("FW:CustomMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.shake", (String)"multirouter");
            }
            if (objectName.equals("FW:attachmentMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.attachment", (String)"multirouter") + msgcontent;
            }
            if (objectName.equals("FW:CustomShareMsg") || objectName.equals("FW:CustomShareMsgVote")) {
                pushContent = pushBeforeText + ":" + msgcontent;
            }
            if ("FW:VoIPMsg".equals(objectName)) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.VoIPMsg", (String)"multirouter") + msgcontent;
            }
            if ("FW:Extension_Msg".equals(objectName)) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.Extension_Msg", (String)"multirouter");
            }
            if (objectName.equals("RC:PublicNoticeMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.PublicNotice", (String)"multirouter") + msgcontent;
            }
            if (objectName.equals("FW:PersonCardMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.PersonCard", (String)"multirouter") + msgcontent;
            }
            if ("FW:CMDMsg".equals(objectName) && (msgcontentJSON = JSON.parseObject((String)msgcontent)) != null && msgcontentJSON.containsKey((Object)"para") && (paraJSON = JSON.parseObject((String)(para = msgcontentJSON.getString("para")))) != null && paraJSON.containsKey((Object)"ding") && (jsonJSON = JSON.parseObject((String)(ding = paraJSON.getString("ding")))) != null && jsonJSON.containsKey((Object)"content")) {
                pushContent = pushBeforeText + ":" + jsonJSON.getString("content");
            }
        }
        catch (Exception e) {
            Log.error("getConversationMsgContent,error:{},senderId:{},objectName:{},msgContent:{}", new Object[]{e.getMessage(), sendId, objectName, msgcontent});
            pushContent = msgcontent;
        }
        return pushContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConversation(String targetId, String userId, String msgContent, String content, String objectName, String sharetypename, String sharetype, String msgId, String lasttime) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" UPDATE social_IMRecentConver set msgContent = ?,content= ?,objectName= ?, sharetypename= ?,sharetype= ?,lasttime= ? where userId = ? and targetId = ? and msgId = ?  ");
            pstmt.setString(1, msgContent);
            pstmt.setString(2, content);
            pstmt.setString(3, objectName);
            pstmt.setString(4, sharetypename);
            pstmt.setString(5, sharetype);
            pstmt.setString(6, lasttime);
            pstmt.setString(7, userId);
            pstmt.setString(8, targetId);
            pstmt.setString(9, msgId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("updateConversation ,error :{} ,e :{},targetId :{} ,userId :{} ", new Object[]{e.getMessage(), e, targetId, userId});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    private void delSyncMsg(String userId, String msgid) {
        String msgKey = HISTORY_MSG_SYNC + msgid;
        Map temp = redisPoolMgr.hgetall(msgKey);
        if (temp.size() == 0) {
            msgKey = msgKey + ":" + userId;
            temp = redisPoolMgr.hgetall(msgKey);
        }
        if (temp.size() > 0) {
            String targetid = (String)temp.get("targetid");
            int targetType = Integer.parseInt((String)temp.get("targetType"));
            if (1 != targetType) {
                targetid = ConverIDUtil.genaralTargetId(targetid, (String)temp.get("toUserid"));
            }
            String delUsers = null;
            if (temp.containsKey("delUsers")) {
                delUsers = (String)temp.get("delUsers");
            }
            delUsers = delUsers != null && !delUsers.isEmpty() ? delUsers + "," + userId : userId;
            temp.put("delUsers", delUsers);
            redisPoolMgr.hmset(msgKey, temp, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHistoryMsg(String userId, String ... msgids) {
        try {
            for (String str : msgids) {
                if (str == null) continue;
                String msgKey = HISTORY_MSG + str;
                Map temp = redisPoolMgr.hgetall(msgKey);
                if (temp.size() == 0) {
                    msgKey = msgKey + ":" + userId;
                    temp = redisPoolMgr.hgetall(msgKey);
                }
                if (temp.size() <= 0) continue;
                String targetid = (String)temp.get("targetid");
                int targetType = Integer.parseInt((String)temp.get("targetType"));
                if (1 != targetType) {
                    targetid = ConverIDUtil.genaralTargetId(targetid, (String)temp.get("toUserid"));
                }
                String delUsers = null;
                if (temp.containsKey("delUsers")) {
                    delUsers = (String)temp.get("delUsers");
                }
                delUsers = delUsers != null && !delUsers.isEmpty() ? delUsers + "," + userId : userId;
                temp.put("delUsers", delUsers);
                redisPoolMgr.hmset(msgKey, temp, HISTORYMSG_EXPIRE);
                this.delSyncMsg(userId, str);
                redisPoolMgr.zrem(this.getConversationIDKey(targetid, userId, targetType), msgKey);
                ArrayList list = new ArrayList(redisPoolMgr.zrevrangeByScore(this.getConversationIDKey(targetid, userId, targetType), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()), 0, 1));
                if (list != null && list.contains("history:msg:0")) {
                    list.remove("history:msg:0");
                }
                Log.info("list + :{}", list);
                if (list != null && list.size() > 0) {
                    int unreadCount;
                    Set<String> readUsers;
                    Map historyMap = redisPoolMgr.hgetall((String)list.get(0));
                    String redisConverKey = "conversation:itmes:" + targetid + ":" + userId;
                    Map converMap = redisPoolMgr.hgetall(redisConverKey);
                    String fromUserId = (String)historyMap.get("fromUserId");
                    String converMapMsgId = (String)converMap.get("msgid");
                    if (str.equals(converMapMsgId)) {
                        String sendTime = (String)historyMap.get("sendTime");
                        String objectName = (String)historyMap.get("objectName");
                        String msgcontent = this.getConversationMsgContent(fromUserId, (String)historyMap.get("content"), objectName);
                        String content = this.getConversationContent(fromUserId, (String)historyMap.get("content"), objectName);
                        redisPoolMgr.hset(redisConverKey, "lasttime", sendTime);
                        redisPoolMgr.hset(redisConverKey, "msgcontent", msgcontent);
                        redisPoolMgr.hset(redisConverKey, "sendId", fromUserId);
                        redisPoolMgr.hset(redisConverKey, "msgid", (String)historyMap.get("timestamp"));
                        redisPoolMgr.hset(redisConverKey, "content", content);
                        redisPoolMgr.hset(redisConverKey, "objectName", objectName);
                        String extraStr = (String)historyMap.get("extra");
                        String sharetypename = null;
                        String shareType = null;
                        JSONObject extra = JSON.parseObject((String)extraStr);
                        if (extra != null && extra.containsKey((Object)"sharetypename")) {
                            sharetypename = extra.getString("sharetypename");
                        }
                        if (extra != null && extra.containsKey((Object)"sharetype")) {
                            shareType = extra.getString("sharetype");
                        }
                        if (sharetypename == null) {
                            redisPoolMgr.hdel(redisConverKey, "sharetypename");
                        } else {
                            redisPoolMgr.hset(redisConverKey, "sharetypename", sharetypename);
                        }
                        if (shareType == null) {
                            redisPoolMgr.hdel(redisConverKey, "shareType");
                        } else {
                            redisPoolMgr.hset(redisConverKey, "shareType", shareType);
                        }
                        this.updateConversation(targetid, userId, msgcontent, content, objectName, sharetypename, shareType, str, sendTime);
                    }
                    if (userId.equals(fromUserId) || (readUsers = MsgReadUtil.getInstance().getMsgReadById(str)) == null || readUsers.contains(userId) || (unreadCount = Integer.parseInt((String)converMap.get("unreadcount"))) <= 0) continue;
                    redisPoolMgr.hset(redisConverKey, "unreadcount", String.valueOf(--unreadCount));
                    continue;
                }
                DatabaseUtil db = new DatabaseUtil();
                db.deleteOFConversation(userId, targetid);
            }
        }
        catch (Exception e) {
            Log.error("deleteHistoryMsg ,userid:{},err:{}", (Object)userId, (Object)e.getMessage());
        }
    }

    static {
        instance = null;
        redisPoolMgr = null;
        HISTORYMSG_EXPIRE = JiveGlobals.getIntProperty((String)"HISTORYMSG_EXPIRE", (int)604800);
        INSERT_HISTORYMSG = "INSERT INTO HistoryMsg (fromUserId,targetId,targetType,GroupId,classname,msgContent,extra,type,imageUri,dateTime,msgid,fullAmount,updatetime) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        INSERT_HISTORYMSGRECENTLY = "INSERT INTO HistoryMsgRecently (fromUserId,targetId,targetType,GroupId,classname,msgContent,extra,type,imageUri,dateTime,msgid,fullAmount) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        INSERT_HISTORYMSGRECENTLY_oracle = "INSERT INTO HistoryMsgRecently (id,fromUserId,targetId,targetType,GroupId,classname,msgContent,extra,type,imageUri,dateTime,msgid,fullAmount) VALUES (HistoryMsgRecently_id.nextval,?,?,?,?,?,?,?,?,?,?,?,?)";
        INSERT_HISTORYMSGRECENTLY_mysql = "INSERT INTO HistoryMsgRecently (fromUserId,targetId,targetType,GroupId,classname,msgContent,extra,type,imageUri,dateTime,msgid,fullAmount) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        INSERT_SOCIALHISTORYMSGRIGHT = "INSERT INTO Social_historyMsgRight (userId, msgId,isdel,datetime) VALUES (?,?,?,?)";
        INSERT_SOCIALHISTORYMSGRECENTLYRIGHT = "INSERT INTO Social_historyMsgRecentlyRight (userId, msgId,isdel,datetime,groupId) VALUES (?,?,?,?,?)";
        SELECT_SOCIAL_HISTORYMSGRIGHT_BY_MSGID = " select * from Social_historyMsgRight where  msgId = ? ";
    }
}

