/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgReadUtil {
    private static final Logger Log = LoggerFactory.getLogger(MsgReadUtil.class);
    private static final String MSG_READ_KEY = "msgread:";
    private static final String MSG_READ_QUEUE = "msgread:queue";
    private static String GET_HISTORYMSGREAD = " select receiverid from Social_Immsgread where msgid = ? and status = 0 ";
    private static RedisPoolMgr redisPoolMgr = null;
    public static MsgReadUtil instance = null;

    public static MsgReadUtil getInstance() {
        redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            instance = new MsgReadUtil();
        }
        return instance;
    }

    private MsgReadUtil() {
    }

    public long getMsgReadQueueCount() {
        long count = 0L;
        try {
            count = redisPoolMgr.zcount(MSG_READ_QUEUE, 0L, System.currentTimeMillis() * 2L);
        }
        catch (Exception e) {
            Log.error("MsgReadUtil,getMsgReadQueueCount.error:{}", (Object)e.getMessage());
        }
        return count;
    }

    public Set<String> getMsgReadQueue(long start, long end) {
        HashSet<String> result = new HashSet();
        try {
            result = redisPoolMgr.zrange(MSG_READ_QUEUE, start, end);
        }
        catch (Exception e) {
            Log.error("MsgReadUtil,getMsgReadQueue.error:{},start:{},end:{}", new Object[]{e.getMessage(), start, end});
        }
        return result;
    }

    public void removeMsgReadQueue(long start, long end) {
        try {
            redisPoolMgr.zremrangeByRank(MSG_READ_QUEUE, start, end);
        }
        catch (Exception e) {
            Log.error("MsgReadUtil,removeMsgReadQueue.error:{},start:{},end:{}", new Object[]{e.getMessage(), start, end});
        }
    }

    public Map<String, Object> getMsgRead(JSONArray msgIdArray) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < msgIdArray.size(); ++i) {
            String msgId = msgIdArray.getString(i);
            String key = this.getMsgReadKey(msgId);
            boolean msgReadKeyExist = this.isMsgReadKeyExist(key);
            HashSet<String> userIdList = new HashSet();
            if (msgReadKeyExist) {
                userIdList = this.getMsgReadUsers(key);
            } else {
                userIdList = this.getMsgRead(msgId);
                this.saveSetsToRedis(msgId, userIdList);
            }
            result.put(msgId, userIdList);
        }
        return result;
    }

    public Set<String> getMsgReadById(String msgId) {
        String key = this.getMsgReadKey(msgId);
        boolean msgReadKeyExist = this.isMsgReadKeyExist(key);
        HashSet<String> userIdList = new HashSet();
        if (msgReadKeyExist) {
            userIdList = this.getMsgReadUsers(key);
        } else {
            userIdList = this.getMsgRead(msgId);
            this.saveSetsToRedis(msgId, userIdList);
        }
        return userIdList;
    }

    public boolean updateMsgReadStatus(String msgid, String userid) {
        try {
            String key = this.getMsgReadKey(msgid);
            boolean msgReadKeyExist = this.isMsgReadKeyExist(key);
            if (msgReadKeyExist) {
                this.setMsgRead(key, userid);
            } else {
                Set<String> valueSet = this.getMsgRead(msgid);
                if (valueSet != null && !valueSet.isEmpty()) {
                    this.saveSetsToRedis(msgid, valueSet);
                }
                this.setMsgRead(key, userid);
            }
            String msgReadQueueKey = this.getMsgReadQueueKey(key);
            this.setMsgReadQueue(msgReadQueueKey, msgid, userid);
        }
        catch (Exception e) {
            Log.error("MsgReadUtil,updateMsgReadStatus.msgid:{},userid:{},error:{}", new Object[]{msgid, userid, e.getMessage()});
            return false;
        }
        return true;
    }

    private void setMsgReadQueue(String key, String msgid, String userid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("msgid", msgid);
        map.put("userid", userid);
        String value = JSON.toJSONString(map);
        try {
            redisPoolMgr.zadd(key, System.currentTimeMillis(), value, 5184000);
        }
        catch (Exception e) {
            Log.error("MsgReadUtil,setMsgReadQueue.key:{},value:{},error:{}", new Object[]{key, value, e.getMessage()});
        }
    }

    private void setMsgRead(String key, String value) {
        try {
            redisPoolMgr.zadd(key, System.currentTimeMillis(), value, 604800);
            redisPoolMgr.addExpire(key, 604800);
        }
        catch (Exception e) {
            Log.error("MsgReadUtil,setMsgRead.key:{},value:{},error:{}", new Object[]{key, value, e.getMessage()});
        }
    }

    private void setMsgRead(String key, Set<String> value) {
        try {
            Iterator<String> i = value.iterator();
            while (i.hasNext()) {
                redisPoolMgr.zadd(key, System.currentTimeMillis(), i.next(), 604800);
            }
        }
        catch (Exception e) {
            Log.error("MsgReadUtil,setMsgRead batch.key:{},value:{},error:{}", new Object[]{key, value, e.getMessage()});
        }
    }

    public boolean saveSetsToRedis(String msgid, Set<String> userids) {
        String key = this.getMsgReadKey(msgid);
        if (userids == null || userids.isEmpty()) {
            redisPoolMgr.zadd(key, 0L, "0", 604800);
        } else {
            this.setMsgRead(key, userids);
        }
        return true;
    }

    private Set<String> getMsgReadUsers(String key) {
        Set valueSet = null;
        try {
            valueSet = redisPoolMgr.zrangeByScore(key, 1.0, (double)(System.currentTimeMillis() * 2L));
        }
        catch (Exception e) {
            Log.error("MsgReadUtil,getMsgReadUsers,key:{},error:{}", (Object)key, (Object)e.getMessage());
        }
        return valueSet;
    }

    private boolean isMsgReadKeyExist(String key) {
        boolean isExist = false;
        try {
            isExist = redisPoolMgr.exists(key);
        }
        catch (Exception e) {
            Log.error("MsgReadUtil,isMsgReadKeyExist,key:{},error:{}", (Object)key, (Object)e.getMessage());
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getMsgRead(String msgId) {
        HashSet<String> userIdList = new HashSet<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_HISTORYMSGREAD);
            pstmt.setString(1, msgId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                userIdList.add(rs.getString("receiverid"));
            }
        }
        catch (Exception e) {
            try {
                Log.error("MsgReadUtil.getMsgRead error.msgId:{},error:{}", (Object)msgId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return userIdList;
    }

    private String getMsgReadQueueKey(String key) {
        return MSG_READ_QUEUE;
    }

    private String getMsgReadKey(String key) {
        return MSG_READ_KEY + key;
    }
}

