/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.cache;

import com.alibaba.fastjson.JSON;
import com.weaver.util.cluster.redis.ClusterRedisPoolMgr;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDeviceCacheUtil {
    private static final Logger Log = LoggerFactory.getLogger(PushDeviceCacheUtil.class);
    private ClusterRedisPoolMgr redisPoolMgr = ClusterRedisPoolMgr.getInstance();
    private static final String redisCacheKey = "push_device:";
    private static PushDeviceCacheUtil instance;

    private PushDeviceCacheUtil() {
        if (this.redisPoolMgr == null) {
            Log.info("redis server not install.}");
        }
    }

    public static synchronized PushDeviceCacheUtil getInstance() {
        if (instance == null) {
            instance = new PushDeviceCacheUtil();
        }
        return instance;
    }

    public PushDevice get(String key) {
        String value = null;
        try {
            if (this.redisPoolMgr != null) {
                key = redisCacheKey + key;
                value = this.redisPoolMgr.get(key);
            }
        }
        catch (Exception e) {
            Log.error("get PushCacheUtil key : {} , error : {} ", (Object)key, (Object)e.getMessage());
            return null;
        }
        return PushDeviceCacheUtil.getPushDevice(value);
    }

    public PushDevice get(String key, String resource) {
        String value = null;
        try {
            if (this.redisPoolMgr != null) {
                key = redisCacheKey + key + resource;
                value = this.redisPoolMgr.get(key);
            }
        }
        catch (Exception e) {
            Log.error("get PushCacheUtil key : {} , error : {} ", (Object)key, (Object)e.getMessage());
            return null;
        }
        return PushDeviceCacheUtil.getPushDevice(value);
    }

    public void put(String key, PushDevice value) {
        try {
            if (this.redisPoolMgr != null) {
                key = redisCacheKey + key;
                this.redisPoolMgr.set(key, this.getStringPushDevice(value), 2592000);
            }
        }
        catch (Exception e) {
            Log.error("put PushCacheUtil key : {} , value : {} ,error : {}", new Object[]{key, value, e.getMessage()});
        }
    }

    public void put(String key, String resource, PushDevice value) {
        try {
            if (this.redisPoolMgr != null) {
                key = redisCacheKey + key + resource;
                this.redisPoolMgr.set(key, this.getStringPushDevice(value), 2592000);
            }
        }
        catch (Exception e) {
            Log.error("put PushCacheUtil key : {} , value : {} ,error : {}", new Object[]{key, value, e.getMessage()});
        }
    }

    public void remove(String key) {
        try {
            if (this.redisPoolMgr != null) {
                key = redisCacheKey + key;
                this.redisPoolMgr.del(key);
            }
        }
        catch (Exception e) {
            Log.error("remove PushCacheUtil key : {} ,error : {}", (Object)key, (Object)e.getMessage());
        }
    }

    public void remove(String key, String resource) {
        try {
            if (this.redisPoolMgr != null) {
                key = redisCacheKey + key + resource;
                this.redisPoolMgr.del(key);
            }
        }
        catch (Exception e) {
            Log.error("remove PushCacheUtil key : {} ,error : {}", (Object)key, (Object)e.getMessage());
        }
    }

    private static PushDevice getPushDevice(String json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        return (PushDevice)JSON.parseObject((String)json, PushDevice.class);
    }

    private String getStringPushDevice(PushDevice pushDevice) {
        return JSON.toJSONString((Object)pushDevice);
    }
}

