/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.cache;

import com.weaver.util.cluster.redis.ClusterRedisPoolMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushSettingCacheUtil {
    private static final Logger Log = LoggerFactory.getLogger(PushSettingCacheUtil.class);
    private ClusterRedisPoolMgr redisPoolMgr = ClusterRedisPoolMgr.getInstance();
    private static PushSettingCacheUtil instance;
    private static final String REDIS_PUSHSETTING_KEY = "push_setting:";
    private static final int PUSHSETTING_KEY_EXPIRE = 604800;

    private PushSettingCacheUtil() {
        if (this.redisPoolMgr == null) {
            Log.error("redis server not install. ");
        }
    }

    public static synchronized PushSettingCacheUtil getInstance() {
        if (instance == null) {
            instance = new PushSettingCacheUtil();
        }
        return instance;
    }

    public String get(String targetId, String targetType, String username) {
        String key = this.getKey(targetId, targetType, username);
        String value = null;
        try {
            if (this.redisPoolMgr != null) {
                key = REDIS_PUSHSETTING_KEY + key;
                value = this.redisPoolMgr.get(key);
            }
        }
        catch (Exception e) {
            Log.error("get PushSettingCacheUtil key : {},error : {} ", (Object)key, (Object)e.getMessage());
        }
        return value;
    }

    public void put(String targetId, String targetType, String username, String value) {
        String key = this.getKey(targetId, targetType, username);
        try {
            if (this.redisPoolMgr != null) {
                key = REDIS_PUSHSETTING_KEY + key;
                this.redisPoolMgr.set(key, value, 604800);
            }
        }
        catch (Exception e) {
            Log.error("get PushSettingCacheUtil key : {} ,value : {} ,error : {} ", new Object[]{key, value, e.getMessage()});
        }
    }

    public void remove(String targetId, String targetType, String username) {
        String key = this.getKey(targetId, targetType, username);
        try {
            if (this.redisPoolMgr != null) {
                key = REDIS_PUSHSETTING_KEY + key;
                this.redisPoolMgr.del(key);
            }
        }
        catch (Exception e) {
            Log.error("remove PushSettingCacheUtil key : {} ,error : {} ", (Object)key, (Object)e.getMessage());
        }
    }

    private String getKey(String targetId, String targetType, String username) {
        return targetId + targetType + username;
    }
}

