/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.cache;

import com.weaver.cache.redis.RedisPoolMgr;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.openfire.OfflineMessage;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import redis.clients.jedis.Tuple;

public class RouteMessageCacheUtil {
    private static final Logger logger = LoggerFactory.getLogger(RouteMessageCacheUtil.class);
    private static RedisPoolMgr redisPoolMgr = null;
    private static volatile RouteMessageCacheUtil instance;
    private static String keyFlag;
    private static String hasGetRouteMessageKey;
    private static String hasGetRouteMessageKey_USERNAME;
    private static long SAVE_ROUTE_MESSAGE_MAX_COUNT;

    private RouteMessageCacheUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static RouteMessageCacheUtil getInstance() {
        if (instance == null) {
            Class<RouteMessageCacheUtil> clazz = RouteMessageCacheUtil.class;
            // MONITORENTER : org.jivesoftware.openfire.plugin.cache.RouteMessageCacheUtil.class
            if (instance == null) {
                instance = new RouteMessageCacheUtil();
            }
            // MONITOREXIT : clazz
        }
        if ((redisPoolMgr = RedisPoolMgr.getInstance()) != null) return instance;
        logger.info("\u83b7\u53d6redisPoolMgr\u5931\u8d25\uff0c\u65e5\u5fd7\u6253\u5370\u5904\uff1aRoutedMessageCacheUtil\u7684\u6784\u9020\u51fd\u6570RoutedMessageCacheUtil()");
        return null;
    }

    public boolean needGetHasRouteMessage(String username) {
        boolean result = true;
        result = this.needGetHasRouteMessage();
        if (!result) {
            return result;
        }
        result = this.isUserNeedGetRouteMessageFromDb(username);
        return result;
    }

    private boolean isUserNeedGetRouteMessageFromDb(String username) {
        String key = hasGetRouteMessageKey_USERNAME + username;
        try {
            if (redisPoolMgr.exists(key)) {
                String value = redisPoolMgr.get(key);
                if ("1".equals(value)) {
                    return false;
                }
            } else {
                redisPoolMgr.set(key, "1", 345600);
            }
        }
        catch (Exception e) {
            logger.error("isUserNeedGetRouteMessageFromDb to redis.error:{}", (Object)e.getMessage());
        }
        return true;
    }

    private boolean needGetHasRouteMessage() {
        boolean result = true;
        String key = hasGetRouteMessageKey;
        try {
            if (redisPoolMgr.exists(key)) {
                String value = redisPoolMgr.get(key);
                long oldTime = Long.valueOf(value);
                long curTime = System.currentTimeMillis();
                if (curTime - oldTime > 345600000L) {
                    result = false;
                }
            } else {
                redisPoolMgr.set(key, String.valueOf(System.currentTimeMillis()), -1);
            }
        }
        catch (Exception e) {
            logger.error("needGetHasRouteMessage to redis.error:{}", (Object)e.getMessage());
            return true;
        }
        return result;
    }

    public boolean isHasGetRouteMessageForDB(String JID2) {
        String key = hasGetRouteMessageKey + JID2;
        try {
            String value = redisPoolMgr.get(key);
            if ("true".equals(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("isHasGetRouteMessageForDB to redis.jid:{},error:{}", (Object)JID2, (Object)e.getMessage());
        }
        return false;
    }

    public void put(String JID2, Message message, long times) {
        String msgID = message.getID();
        try {
            String key = this.getKey(JID2);
            String value = this.getStringMessage(message);
            redisPoolMgr.zadd(key, times, value, 604800);
            long totalCount = redisPoolMgr.zcount(key, 0L, System.currentTimeMillis() * 2L);
            long offsetCount = totalCount - SAVE_ROUTE_MESSAGE_MAX_COUNT;
            if (offsetCount > 0L) {
                redisPoolMgr.zremrangeByRank(key, 0L, offsetCount - 1L);
                logger.info("routeMessageCacheUtil,routemessage more than 1000 .and delete old routemessage.JID:{}", (Object)JID2.toString());
            }
        }
        catch (Exception e) {
            logger.error("saveRouteMessage to redis JID:{},message:{},error:{}", new Object[]{JID2, message, e.getMessage()});
            return;
        }
        logger.info("saveRouteMessage to redis.jid:{},msgid:{}", (Object)JID2, (Object)msgID);
    }

    public List<OfflineMessage> getMessages(String JID2, long start, long end) {
        ArrayList<OfflineMessage> list = new ArrayList<OfflineMessage>();
        if (JID2 == null || JID2.isEmpty()) {
            logger.warn("getRouteMessages,key is null or empty.");
            return list;
        }
        String key = this.getKey(JID2);
        Set value = redisPoolMgr.zrangeWithScores(key, start, end);
        for (Tuple s : value) {
            OfflineMessage offlineMessage = this.getOfflineMessage(s.getElement(), (long)s.getScore());
            list.add(offlineMessage);
        }
        redisPoolMgr.del(key);
        logger.info("get Route Messages .count:{},JID:{}", (Object)list.size(), (Object)JID2);
        return list;
    }

    public int getRouteMessageSize(JID jid, long start, long end) {
        int result = 0;
        try {
            String key = this.getKey(jid.toString());
            result = (int)redisPoolMgr.zcount(key, start, end);
        }
        catch (Exception e) {
            result = 0;
            logger.error("getRouteMessageSize,jid={},{},err={}", new Object[]{jid.getNode(), jid.getResource(), e.getMessage()});
        }
        return result;
    }

    private String getKey(String key) {
        key = keyFlag + key;
        return key;
    }

    private OfflineMessage getOfflineMessage(String json, long score) {
        Element delaytest;
        SAXReader xmlReader = new SAXReader();
        OfflineMessage message = null;
        Date creationDate = new Date(score);
        try {
            message = new OfflineMessage(creationDate, xmlReader.read((Reader)new StringReader(json)).getRootElement());
        }
        catch (DocumentException e) {
            try {
                message = new OfflineMessage(creationDate, xmlReader.read((Reader)new StringReader(json)).getRootElement());
            }
            catch (DocumentException de) {
                logger.error("getRouteMessage failed to decode offline message={}, err={} ", (Object)json, (Object)de.getMessage());
            }
        }
        if (null != message && (delaytest = message.getChildElement("delay", "urn:xmpp:delay")) == null) {
            Element delay = message.addChildElement("delay", "urn:xmpp:delay");
            delay.addAttribute("from", XMPPServer.getInstance().getServerInfo().getXMPPDomain());
            delay.addAttribute("stamp", XMPPDateTimeFormat.format((Date)creationDate));
        }
        return message;
    }

    private String getStringMessage(Message message) {
        return message.toString();
    }

    static {
        keyFlag = "Route_Message_";
        hasGetRouteMessageKey = "Route_Message_HasGet";
        hasGetRouteMessageKey_USERNAME = "RouteMessageHasGet:";
        SAVE_ROUTE_MESSAGE_MAX_COUNT = 1000L;
    }
}

