/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatSearchIQDao {
    private static final Logger logger = LoggerFactory.getLogger(ChatSearchIQDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> searchChatId(Integer pageNumber, Integer pageSize, String keyword, String userId, String senderId, String startTime, String endTime) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Integer totalCount = 0;
        ArrayList<String> listGroupId = new ArrayList<String>();
        HashMap mapChatMessage = new HashMap();
        boolean searchGroupFromDb = JiveGlobals.getBooleanProperty((String)"searchMsg", (boolean)true);
        try {
            if (searchGroupFromDb) {
                connection = DbConnectionManager.getConnection();
                String sql = "SELECT a.GroupId AS targetId,a.targetType AS targetType,COUNT(a.GroupId) AS msgCount,MAX(a.id) AS maxDateTime FROM HistoryMsg a,Social_historyMsgRight b WHERE a.msgid = b.msgId AND b.userId = ? AND a.targetType IN ('1', '2') AND (b.isdel != 1 OR b.isdel IS NULL) ";
                if (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm)) {
                    sql = "SELECT a.GroupId AS targetId,a.targetType AS targetType,COUNT(a.GroupId) AS msgCount,MAX(a.id) AS maxDateTime FROM HistoryMsg a,Social_historyMsgRight b WHERE a.msgid = b.msgId AND b.userId = ? AND a.targetType IN ('1', '2') and (b.isdel != 1 OR b.isdel IS NULL) ";
                } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                    sql = "SELECT a.GroupId AS targetId,a.targetType AS targetType,COUNT(a.GroupId) AS msgCount,MAX(a.id) AS maxDateTime FROM HistoryMsg a,Social_historyMsgRight b WHERE a.msgid = b.msgId AND b.userId = ? AND a.targetType IN ('1', '2') and (b.isdel != 1 OR b.isdel IS NULL) ";
                } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                    sql = "SELECT a.GroupId AS targetId,a.targetType AS targetType,COUNT(a.GroupId) AS msgCount,MAX(a.id) AS maxDateTime FROM HistoryMsg a,Social_historyMsgRight b WHERE a.msgid = b.msgId AND b.userId = ? AND a.targetType IN ('1', '2') and (b.isdel != 1 OR b.isdel IS NULL) ";
                }
                if (senderId != null && !senderId.isEmpty()) {
                    sql = sql + " AND a.fromUserId = ? ";
                }
                if (startTime != null && !startTime.isEmpty()) {
                    sql = sql + " AND a.datetime > ? ";
                }
                if (endTime != null && !endTime.isEmpty()) {
                    sql = sql + " AND a.datetime < ? ";
                }
                if (keyword != null && !keyword.isEmpty()) {
                    sql = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) ? sql + " AND upper(dbms_lob.substr(a.msgContent)) LIKE upper(?)" : (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? sql + " AND upper(msgContent) LIKE upper(?)" : sql + " AND msgContent LIKE ? ");
                    sql = StringUtils.isBlank((CharSequence)keyword) ? sql + " AND classname IN ('RC:TxtMsg','RC:ImgMsg','RC:VcMsg','RC:LBSMsg','FW:attachmentMsg','FW:PersonCardMsg','FW:CMDMsg','FW:richTextMsg','FW:LinkMsg','FW:NewsMsg','FW:CustomShareMsg','FW:VoIPMsg','FW:Extension_Msg','RC:PublicNoticeMsg','FW:UniteMsg','RC:ExpMsg')" : sql + " AND a.classname IN ('RC:TxtMsg','FW:attachmentMsg','FW:CustomShareMsg')";
                }
                sql = sql + " GROUP BY a.GroupId,a.targetType";
                if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                    sql = sql + " ORDER BY maxDateTime DESC";
                }
                String sqlCount = "SELECT COUNT(1) AS totalCount FROM (" + sql + ") AS historyMsgFilterTable";
                if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                    sqlCount = "SELECT COUNT(1) AS totalCount FROM (" + sql + ")historyMsgFilterTable";
                }
                preparedStatement = connection.prepareStatement(sqlCount);
                if (JiveGlobals.getBooleanProperty((String)"queryHistoryMsgTimeOut", (boolean)false)) {
                    preparedStatement.setQueryTimeout(JiveGlobals.getIntProperty((String)"queryHistoryMsgTimeOutSeconds", (int)10));
                }
                preparedStatement.setString(1, userId);
                int i = 1;
                if (senderId != null && !senderId.isEmpty()) {
                    preparedStatement.setString(++i, senderId);
                }
                if (startTime != null && !startTime.isEmpty()) {
                    preparedStatement.setString(++i, startTime);
                }
                if (endTime != null && !endTime.isEmpty()) {
                    preparedStatement.setString(++i, endTime);
                }
                if (keyword != null && !keyword.isEmpty()) {
                    preparedStatement.setString(++i, "%" + keyword + "%");
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    totalCount = resultSet.getInt("totalCount");
                }
                resultSet.close();
                preparedStatement.close();
                if (pageNumber != null && pageSize != null) {
                    if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                        sql = "SELECT * FROM (SELECT row_number() over(order by pageTable.maxDateTime desc) as rn,pageTable.* FROM (" + sql + ") as pageTable ) as a WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
                    } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                        sql = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
                    } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                        sql = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
                    } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                        sql = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
                    }
                }
                logger.info("searchChatId sql == :{} ", (Object)sql);
                preparedStatement = connection.prepareStatement(sql);
                if (JiveGlobals.getBooleanProperty((String)"queryHistoryMsgTimeOut", (boolean)false)) {
                    preparedStatement.setQueryTimeout(JiveGlobals.getIntProperty((String)"queryHistoryMsgTimeOutSeconds", (int)10));
                }
                preparedStatement.setString(1, userId);
                int j = 1;
                if (senderId != null && !senderId.isEmpty()) {
                    preparedStatement.setString(++j, senderId);
                }
                if (startTime != null && !startTime.isEmpty()) {
                    preparedStatement.setString(++j, startTime);
                }
                if (endTime != null && !endTime.isEmpty()) {
                    preparedStatement.setString(++j, endTime);
                }
                if (keyword != null && !keyword.isEmpty()) {
                    preparedStatement.setString(++j, "%" + keyword + "%");
                }
                resultSet = preparedStatement.executeQuery();
                GroupManager groupManager = GroupManager.getInstance();
                while (resultSet.next()) {
                    String[] arrayGroupId;
                    String targetId = resultSet.getString("targetId");
                    String targetType = resultSet.getString("targetType");
                    String msgCount = resultSet.getString("msgCount");
                    String groupName = "";
                    String groupIconUrl = "";
                    Group group = null;
                    String groupType = "0";
                    HashMap<String, String> mapChatDetail = new HashMap<String, String>();
                    if (targetType.equals("2")) {
                        try {
                            group = groupManager.getGroup(targetId);
                            if (group == null) continue;
                            groupName = group.getDescription();
                            PersistableMap groupProp = group.getProperties();
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            if (groupProp != null && groupProp.containsKey((Object)"groupType")) {
                                groupType = (String)groupProp.get((Object)"groupType");
                            }
                            String secretGroupType = "0";
                            if (groupProp != null && groupProp.containsKey((Object)"secretGroupType")) {
                                secretGroupType = (String)groupProp.get((Object)"secretGroupType");
                            }
                            if ("1".equals(secretGroupType)) {
                                DatabaseUtil db = new DatabaseUtil();
                                mapChatDetail.put("secretGroupTargetId", db.getSecretChatTargetId(userId, targetId));
                            }
                            listGroupId.add(targetId);
                            mapChatDetail.put("msgCount", msgCount);
                            mapChatDetail.put("targetId", targetId);
                            mapChatDetail.put("targetType", targetType);
                            mapChatDetail.put("groupName", groupName);
                            mapChatDetail.put("groupIconUrl", groupIconUrl);
                            mapChatDetail.put("groupType", groupType);
                            mapChatDetail.put("secretGroupType", secretGroupType);
                            mapChatMessage.put(targetId, mapChatDetail);
                        }
                        catch (Exception groupProp) {}
                        continue;
                    }
                    mapChatDetail.put("msgCount", msgCount);
                    String groupId = targetId;
                    if (!StringUtils.isNotBlank((CharSequence)groupId) || (arrayGroupId = groupId.split("-")).length != 2) continue;
                    if (userId.equals(arrayGroupId[0])) {
                        targetId = arrayGroupId[1];
                    } else {
                        if (!userId.equals(arrayGroupId[1])) continue;
                        targetId = arrayGroupId[0];
                    }
                    listGroupId.add(targetId);
                    mapChatDetail.put("targetId", targetId);
                    mapChatDetail.put("targetType", targetType);
                    mapChatDetail.put("groupName", groupName);
                    mapChatDetail.put("groupIconUrl", groupIconUrl);
                    mapChatMessage.put(targetId, mapChatDetail);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4f1a\u8bdd\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(resultSet, preparedStatement, (Connection)connection);
        }
        result.put("searchedChat", listGroupId);
        result.put("pageNumber", pageNumber);
        result.put("pageSize", pageSize);
        result.put("totalCount", totalCount);
        result.put("chatMessage", mapChatMessage);
        return result;
    }
}

