/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cust.qmx.QMXUtil;
import com.weaver.msg.encrypt.EncryptUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.util.DingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistorySearchIQDao {
    private static final Logger logger = LoggerFactory.getLogger(HistorySearchIQDao.class);
    private static SimpleDateFormat SDF_SIMPLE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat SDF_ALL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final List<String> GRAY_BAR_TYPE = new ArrayList<String>();
    public static final List<String> FULL_AMOUNT_TYPE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> searchHistoryMsg(String loginUserId, String fromUserId, String targetId, Integer targetType, Integer pageNumber, Integer pageSize, String startTime, String endTime, String keyword, String msgType, String dataId, String orderType, String senderId, Long totalCount, String fromResource) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList msgObj = new ArrayList();
        try {
            connection = DbConnectionManager.getConnection();
            String sql = "";
            sql = StringUtils.isNotBlank((CharSequence)orderType) && orderType.equals("1") ? "SELECT ROW_NUMBER() OVER(ORDER BY a.datetime ASC) AS rn,a.id,fromUserId,targetId,targetType,GroupId,classname,msgContent,extra,type,imageUri,a.dateTime,a.msgid,fullAmount FROM (select * from historyMsg where groupId = ?)a inner JOIN (select * from social_HistoryMsgright where userid = '" + loginUserId + "')b ON a.msgid = b.msgId  WHERE (b.isdel != 1 OR b.isdel IS NULL) " : "SELECT ROW_NUMBER() OVER(ORDER BY a.datetime DESC) AS rn,a.id,fromUserId,targetId,targetType,GroupId,classname,msgContent,extra,type,imageUri,a.dateTime,a.msgid,fullAmount FROM (select * from historyMsg where groupId = ?)a inner JOIN (select * from social_HistoryMsgright where userid = '" + loginUserId + "')b ON a.msgid = b.msgId  WHERE (b.isdel != 1 OR b.isdel IS NULL) ";
            if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sql = "SELECT a.id,fromUserId,targetId,targetType,GroupId,classname,msgContent,extra,type,imageUri,a.dateTime,a.msgid,fullAmount FROM HistoryMsg a inner JOIN Social_historyMsgRight b ON a.msgid = b.msgId AND (b.isdel != 1 OR b.isdel IS NULL) WHERE groupid = ?";
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = "SELECT a.id,fromUserId,targetId,targetType,GroupId,classname,msgContent,extra,type,imageUri,a.dateTime,a.msgid,fullAmount FROM HistoryMsg a inner JOIN Social_historyMsgRight b ON a.msgid = b.msgId AND (b.isdel != 1 OR b.isdel IS NULL) WHERE groupid = ?";
            }
            String groupid = "";
            if (targetType == 1 || targetType == 9 || targetType == 102 || targetType == 103 || targetType == 104 || targetType == 112) {
                groupid = fromUserId.compareToIgnoreCase(targetId) >= 0 ? targetId + "-" + fromUserId : fromUserId + "-" + targetId;
            } else if (targetType == 2) {
                groupid = targetId;
            }
            if (!DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = sql + " AND b.userId = '" + loginUserId + "'";
            }
            if (senderId != null && !senderId.isEmpty()) {
                sql = sql + " AND fromUserId = ?";
            }
            if (StringUtils.isNotBlank((CharSequence)startTime)) {
                sql = sql + " AND a.dateTime >= '" + startTime + "'";
            }
            if (StringUtils.isNotBlank((CharSequence)endTime)) {
                sql = sql + " AND a.dateTime <= '" + endTime + "'";
            }
            if (null == keyword || keyword.isEmpty()) {
                keyword = "";
            } else {
                sql = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) ? sql + " AND upper(dbms_lob.substr(msgContent)) LIKE upper('%" + keyword + "%')" : (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? sql + " AND upper(msgContent) LIKE upper('%" + keyword + "%')" : sql + " AND msgContent LIKE '%" + keyword + "%'");
            }
            if (StringUtils.isBlank((CharSequence)msgType)) {
                sql = keyword.equals("") ? sql + " AND classname IN ('RC:TxtMsg','RC:ImgMsg','RC:VcMsg','RC:LBSMsg','FW:attachmentMsg','FW:PersonCardMsg','FW:CMDMsg','FW:richTextMsg','FW:LinkMsg','FW:NewsMsg','FW:CustomShareMsg','FW:VoIPMsg','FW:Extension_Msg','RC:PublicNoticeMsg','FW:UniteMsg','RC:ExpMsg')" : sql + " AND classname IN ('RC:TxtMsg','FW:attachmentMsg','FW:CustomShareMsg')";
            } else {
                Object[] arrayMsgType = msgType.split(",");
                for (int i = 0; i < arrayMsgType.length; ++i) {
                    arrayMsgType[i] = "'" + arrayMsgType[i] + "'";
                }
                sql = sql + " AND classname IN (" + StringUtils.join((Object[])arrayMsgType, (String)",") + ")";
            }
            String sqlCount = "SELECT COUNT(1) AS totalCount FROM (" + sql + ") AS historyMsgFilterTable";
            if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sqlCount = "SELECT COUNT(1) AS totalCount FROM (" + sql + ")historyMsgFilterTable";
            }
            if (totalCount == null || totalCount < 0L) {
                preparedStatement = connection.prepareStatement(sqlCount);
                preparedStatement.setString(1, groupid);
                if (senderId != null && !senderId.isEmpty()) {
                    preparedStatement.setString(2, senderId);
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    totalCount = resultSet.getLong("totalCount");
                }
                resultSet.close();
                preparedStatement.close();
            }
            if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = StringUtils.isNotBlank((CharSequence)orderType) && orderType.equals("1") ? sql + " ORDER BY a.datetime ASC" : sql + " ORDER BY a.datetime DESC";
            }
            if (StringUtils.isNotBlank((CharSequence)dataId)) {
                String msgIdSql = "SELECT COUNT(a.id) AS pageNumberCount FROM HistoryMsg a,Social_historyMsgRight b WHERE groupid = ? AND a.msgid = b.msgId AND (b.isdel != 1 OR b.isdel IS NULL) AND a.id >= " + Integer.parseInt(dataId);
                if (StringUtils.isNotBlank((CharSequence)startTime)) {
                    sql = sql + " AND a.dateTime >= '" + startTime + "'";
                }
                if (StringUtils.isNotBlank((CharSequence)endTime)) {
                    sql = sql + " AND a.dateTime <= '" + endTime + "'";
                }
                if (StringUtils.isBlank((CharSequence)msgType)) {
                    msgIdSql = keyword.equals("") ? msgIdSql + " AND classname IN ('RC:TxtMsg','RC:ImgMsg','RC:VcMsg','RC:LBSMsg','FW:attachmentMsg','FW:PersonCardMsg','FW:CMDMsg','FW:richTextMsg','FW:LinkMsg','FW:NewsMsg','FW:CustomShareMsg','FW:VoIPMsg','FW:Extension_Msg','RC:PublicNoticeMsg','FW:UniteMsg','RC:ExpMsg')" : msgIdSql + " AND a.classname IN ('RC:TxtMsg','FW:attachmentMsg','FW:CustomShareMsg')";
                } else {
                    Object[] arrayMsgType = msgType.split(",");
                    for (int i = 0; i < arrayMsgType.length; ++i) {
                        arrayMsgType[i] = "'" + arrayMsgType[i] + "'";
                    }
                    msgIdSql = msgIdSql + " AND a.classname IN (" + StringUtils.join((Object[])arrayMsgType, (String)",") + ")";
                }
                msgIdSql = msgIdSql + " AND b.userId = '" + loginUserId + "'";
                Integer pageNumberCount = 0;
                preparedStatement = connection.prepareStatement(msgIdSql);
                preparedStatement.setString(1, groupid);
                if (senderId != null && !senderId.isEmpty()) {
                    preparedStatement.setString(2, senderId);
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    pageNumberCount = resultSet.getInt("pageNumberCount");
                }
                resultSet.close();
                preparedStatement.close();
                if (pageNumberCount > 0) {
                    pageNumber = pageNumberCount / pageSize + (pageNumberCount % pageSize > 0 ? 1 : 0);
                }
            }
            if (pageNumber != null && pageSize != null) {
                if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                    sql = "SELECT * FROM (" + sql + ") AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
                } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                    sql = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
                } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                    sql = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
                } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                    sql = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
                }
            }
            logger.info("sql ========= :{}", (Object)sql);
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, groupid);
            if (senderId != null && !senderId.isEmpty()) {
                preparedStatement.setString(2, senderId);
            }
            logger.info("historySearchDao sql ====start===== :{}", (Object)sql);
            resultSet = preparedStatement.executeQuery();
            logger.info("historySearchDao sql ====end===== :{}", (Object)sql);
            while (resultSet.next()) {
                String fullAmount;
                int ding_id;
                DingUtil dingUtil;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fromUserId", resultSet.getString("fromUserId"));
                map.put("targetId", resultSet.getString("targetId"));
                String objectName = resultSet.getString("classname");
                JSONObject opBody = new JSONObject();
                opBody.put("objectName", (Object)objectName);
                opBody.put("msgType", (Object)this.getMsgTypeValueByName(resultSet.getString("classname")));
                opBody.put("targetid", (Object)resultSet.getString("targetId"));
                opBody.put("targetType", (Object)String.valueOf(resultSet.getInt("targetType") - 1));
                opBody.put("toUserid", (Object)resultSet.getString("fromUserId"));
                opBody.put("chatdivid", (Object)resultSet.getString("targetId"));
                opBody.put("timestamp", (Object)resultSet.getString("msgid"));
                String msgContent = resultSet.getString("msgContent");
                if (EncryptUtil.isEncryptEnable()) {
                    msgContent = EncryptUtil.decrypt((String)msgContent);
                }
                opBody.put("content", (Object)msgContent);
                opBody.put("imgUrl", (Object)resultSet.getString("imageUri"));
                opBody.put("dataId", (Object)String.valueOf(resultSet.getInt("id")));
                String extra = resultSet.getString("extra");
                if (EncryptUtil.isEncryptEnable()) {
                    extra = EncryptUtil.decrypt((String)extra);
                }
                opBody.put("extra", (Object)extra);
                if ("FW:CMDMsg".equals(objectName) && !(dingUtil = new DingUtil()).chechUserDing(fromUserId, ding_id = dingUtil.getDingIdByMessageContent(msgContent))) {
                    String newContent = dingUtil.getDingContent(msgContent);
                    opBody.put("content", (Object)newContent);
                    opBody.put("objectName", (Object)"RC:TxtMsg");
                }
                if ((GRAY_BAR_TYPE.contains(objectName) || FULL_AMOUNT_TYPE.contains(objectName)) && (fullAmount = resultSet.getString("fullAmount")) != null && !fullAmount.isEmpty()) {
                    JSONObject fullAmountObj = JSONObject.parseObject((String)fullAmount);
                    for (String key : fullAmountObj.keySet()) {
                        if (opBody.containsKey((Object)key)) continue;
                        opBody.put(key, (Object)fullAmountObj.getString(key));
                    }
                }
                if (QMXUtil.isEnable((String)loginUserId) && "mobile".equals(fromResource)) {
                    JSONObject jsonExtra;
                    if ("RC:ImgMsg".equals(objectName)) {
                        opBody.put("objectName", (Object)"RC:TxtMsg");
                        opBody.put("content", (Object)QMXUtil.imgContent);
                        opBody.put("imgUrl", (Object)"");
                        jsonExtra = JSONObject.parseObject((String)extra);
                        jsonExtra.put("imgUrl", (Object)"");
                        jsonExtra.put("fileid", (Object)"");
                        opBody.put("extra", (Object)JSON.toJSONString((Object)jsonExtra));
                    }
                    if ("FW:attachmentMsg".equals(objectName)) {
                        opBody.put("objectName", (Object)"RC:TxtMsg");
                        opBody.put("content", (Object)QMXUtil.fileContent);
                        opBody.put("imgUrl", (Object)"");
                        jsonExtra = JSONObject.parseObject((String)extra);
                        jsonExtra.put("imgUrl", (Object)"");
                        jsonExtra.put("fileid", (Object)"");
                        opBody.put("extra", (Object)JSON.toJSONString((Object)jsonExtra));
                    }
                }
                map.put("opBody", (String)opBody);
                String dateTime = resultSet.getString("dateTime");
                Long tempTime = StringUtils.isNumeric((CharSequence)dateTime) ? Long.parseLong(dateTime) : (dateTime.length() == 19 ? SDF_SIMPLE.parse(dateTime).getTime() : SDF_ALL.parse(dateTime).getTime());
                map.put("sendTime", String.valueOf(tempTime));
                msgObj.add(map);
            }
            DbConnectionManager.closeConnection((ResultSet)resultSet, (Statement)preparedStatement, (Connection)connection);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u804a\u5929\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(resultSet, preparedStatement, (Connection)connection);
        }
        result.put("searchedHistory", msgObj);
        result.put("pageNumber", pageNumber);
        result.put("pageSize", pageSize);
        result.put("totalCount", totalCount);
        return result;
    }

    private int getMsgTypeValueByName(String name) {
        int result = 6;
        if ("RC:TxtMsg".equals(name)) {
            result = 1;
        } else if ("RC:ImgMsg".equals(name)) {
            result = 2;
        } else if ("RC:VcMsg".equals(name)) {
            result = 3;
        } else if ("RC:LBSMsg".equals(name)) {
            result = 8;
        }
        return result;
    }

    private Integer getDataPageNumber(String dataId) {
        Integer result = null;
        if (StringUtils.isNotBlank((CharSequence)dataId)) {
            String string = "SELECT COUNT(a.id) FROM HistoryMsg a,Social_historyMsgRight b WHERE a.msgid = b.msgId AND (b.isdel != 1 OR b.isdel IS NULL) AND a.id >= " + Integer.parseInt(dataId);
        }
        return result;
    }

    static {
        GRAY_BAR_TYPE.add("RC:DizNtf");
        GRAY_BAR_TYPE.add("RC:InfoNtf");
        GRAY_BAR_TYPE.add("FW:InfoNtf");
        GRAY_BAR_TYPE.add("RC:InfoNtfVote");
        FULL_AMOUNT_TYPE = new ArrayList<String>();
        FULL_AMOUNT_TYPE.add("RC:VcMsg");
        FULL_AMOUNT_TYPE.add("RC:LBSMsg");
    }
}

