/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.deleteConver;

import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteConverThread
extends Thread {
    private String[] userIds;
    private static final Logger Log = LoggerFactory.getLogger(DeleteConverThread.class);

    public DeleteConverThread(String[] userIds) {
        this.userIds = userIds;
    }

    @Override
    public void run() {
        Log.info("start deleteConver userIds:{}", (Object)this.userIds.length);
        if (this.userIds != null && this.userIds.length > 1) {
            for (int i = 0; i < this.userIds.length; ++i) {
                this.deleteConv(this.userIds[i]);
                this.deleteConvFromDb(this.userIds[i]);
            }
        } else if (this.userIds != null && this.userIds.length == 1) {
            this.deleteConv(this.userIds[0]);
            this.deleteConvFromDb(this.userIds[0]);
        }
        Log.info("end deleteConver userIds:{}", (Object)this.userIds.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConvFromDb(String userId) {
        Log.info("start deleteConvFromDb userId:{}", (Object)userId);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("update social_IMRecentConver set isdel = 1 where targetId like ? ");
            pstmt.setString(1, "%" + userId + "%");
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("deleteConvFromDb,error:{},userId:{}", (Object)e.getMessage(), (Object)userId);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        Log.info("end deleteConvFromDb userId:{}", (Object)userId);
    }

    private void deleteConv(String userId) {
        Log.info("start redis delete conv :{}", (Object)userId);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        Set converSations = redisPoolMgr.Keys("conversation:itmes:*" + userId + "*");
        Log.info("this user has :{} converSations", (Object)converSations.size());
        DatabaseUtil db = new DatabaseUtil();
        for (String conver : converSations) {
            String[] s = null;
            if (conver != null && conver.contains(":")) {
                s = conver.split(":");
            }
            if (s == null || s.length != 4) continue;
            String userid = s[3];
            String targetId = s[2];
            db.deleteOFConversation(userid, targetId);
        }
        Log.info("end redis delete conv :{}", (Object)userId);
    }
}

