/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.jivesoftware.openfire.plugin.bean.HttpProxyForPush;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePushYYUtil {
    private static final Logger Log = LoggerFactory.getLogger(MessagePushYYUtil.class);
    private static final String PROP_FILE_PATH = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "yyPush.properties";
    private static String ACCESS_TOKEN_URL = "https://eaiapp.ccom.edu.cn/api/third/get-token";
    private static String APPID = "200231101102923704";
    private static String APPSECRET = "tdww0q4q1irnry43k8aij9sabhxqqrqr";
    private static String PUSHRUL = "https://eaiapp.ccom.edu.cn/uc/api/ucs/qywx";
    private static String wid = "171";
    private static String access_token = null;
    private static long access_token_expire = 0L;
    private static String CONTENT = "\u60a8\u6536\u5230\u4e00\u6761\u6d88\u606f\uff0c\u8bf7\u6253\u5f00\u592e\u97f3\u529e\u516cAPP ( \u540d\u79f0\uff1aEMobile 7)\u67e5\u770b\u3002";
    public static boolean yyPushOpen = false;

    public static void main(String[] args) {
        MessagePushYYUtil.msgPush("9913");
    }

    public static void msgPush(String userId) {
        MessagePushYYUtil.getAccessToken();
        String param = "access_token=" + access_token + "&numbers[]=" + userId + "&content[msgtype]=text&content[text][content]=" + CONTENT + "&wid=" + wid;
        try {
            String result = MessagePushYYUtil.httpPost(PUSHRUL, param, 3000, 3000, "application/x-www-form-urlencoded");
            Log.info("msgPush,content :{},userId:{},result :{},param:{}", new Object[]{userId, result, param});
        }
        catch (IOException e) {
            Log.error("msgPush,content :{},userId:{},error :{},e:{},param:{}", new Object[]{userId, e.getMessage(), e, param});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String httpUrl, String data, int connectTimeout, int readTimeout, String Content_Type) throws IOException {
        String string;
        OutputStream outPut = null;
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        try {
            URL url = new URL(httpUrl);
            HttpProxyForPush httpProxy = HttpProxyForPush.getInstance();
            boolean isUserProxy = httpProxy.isUserProxy();
            if (isUserProxy) {
                InetSocketAddress addr = new InetSocketAddress(httpProxy.getProxyHost(), httpProxy.getProxyPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                urlConnection = (HttpsURLConnection)url.openConnection(proxy);
                boolean isNeedAuth = httpProxy.isPropxyNeedAuth();
                if (isNeedAuth) {
                    String encoded = new String(Base64.encodeBase64((byte[])(httpProxy.getProxyUsername() + ":" + httpProxy.getProxyPassword()).getBytes()));
                    urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
            } else {
                urlConnection = (HttpsURLConnection)url.openConnection();
            }
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            if (Content_Type != null && !Content_Type.isEmpty()) {
                urlConnection.setRequestProperty("Content-Type", Content_Type);
            }
            urlConnection.setConnectTimeout(30000);
            urlConnection.setReadTimeout(30000);
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes("UTF-8"));
            outPut.flush();
            in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            List lines = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            StringBuffer strBuf = new StringBuffer();
            for (String line : lines) {
                strBuf.append(line);
            }
            string = strBuf.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outPut);
            IOUtils.closeQuietly(in);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outPut);
        IOUtils.closeQuietly((InputStream)in);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }

    private static void getAccessToken() {
        if (access_token != null && access_token_expire > System.currentTimeMillis()) {
            return;
        }
        String url = ACCESS_TOKEN_URL + "?appid=" + APPID + "&appsecret=" + APPSECRET;
        try {
            String result = MessagePushYYUtil.httpGet(url, 30000, 30000);
            JSONObject json = JSONObject.parseObject((String)result);
            if (json != null && json.containsKey((Object)"d")) {
                String d = json.getString("d");
                JSONObject jsonD = JSONObject.parseObject((String)d);
                if (jsonD != null && jsonD.containsKey((Object)"access_token")) {
                    access_token = jsonD.getString("access_token");
                }
                if (jsonD != null && jsonD.containsKey((Object)"expires_in")) {
                    int expires_in = jsonD.getIntValue("expires_in");
                    access_token_expire = System.currentTimeMillis() + (long)(expires_in * 1000);
                }
            }
        }
        catch (IOException e) {
            Log.error("getAccessToken,error :{} ,url :{},e:{}", new Object[]{e.getMessage(), url, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String httpUrl, int connectTimeout, int readTimeout) throws IOException {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            URL realUrl = new URL(httpUrl);
            URLConnection connection = realUrl.openConnection();
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readYyPushProp() {
        InputStream is = null;
        InputStreamReader fileReader = null;
        try {
            String WID;
            String pushUrl;
            String appSecret;
            String appId;
            File file = new File(PROP_FILE_PATH);
            if (!file.exists()) {
                Log.info("readYyPushProp ,file not exists :{} ", (Object)PROP_FILE_PATH);
                return;
            }
            is = new FileInputStream(file);
            fileReader = new FileReader(PROP_FILE_PATH);
            Properties prop = new Properties();
            prop.load(fileReader);
            String pushOpen = prop.getProperty("yyPushOpen");
            if (!"true".equals(pushOpen)) {
                Log.info("readYyPushProp ,yyPushOpen is :{}", (Object)pushOpen);
                return;
            }
            yyPushOpen = true;
            String access_token_url = prop.getProperty("access_token_url");
            if (access_token_url != null && !access_token_url.isEmpty()) {
                ACCESS_TOKEN_URL = access_token_url.trim();
            }
            if ((appId = prop.getProperty("appId")) != null && !appId.isEmpty()) {
                APPID = appId.trim();
            }
            if ((appSecret = prop.getProperty("appSecret")) != null && !appSecret.isEmpty()) {
                APPSECRET = appSecret.trim();
            }
            if ((pushUrl = prop.getProperty("pushUrl")) != null && !pushUrl.isEmpty()) {
                PUSHRUL = pushUrl.trim();
            }
            if ((WID = prop.getProperty("wid")) == null) return;
            if (WID.isEmpty()) return;
            wid = WID.trim();
            return;
        }
        catch (Exception e) {
            Log.error("MessagePushYYUtil,readYyPushProp,error:{}", (Object)e.getMessage());
            yyPushOpen = false;
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

