/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import com.alibaba.fastjson.JSON;
import com.oppo.push.server.Notification;
import com.oppo.push.server.Result;
import com.oppo.push.server.Sender;
import com.oppo.push.server.Target;
import com.oppo.push.server.TargetType;
import java.util.UUID;
import org.jivesoftware.openfire.security.SecurityAuditManager;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPushMessageUtil {
    private String appKey = "6db61a985605492188fd8af295362e89";
    private String masterSecret = "f78e61b3c68f4cfca033fbeba24c97cf";
    private static final Logger Log = LoggerFactory.getLogger(OPushMessageUtil.class);

    public OPushMessageUtil(String appKey, String masterSecret) {
        this.appKey = appKey;
        this.masterSecret = masterSecret;
    }

    public void pushMessageToOppo(String zh_name, String title, String pushContent, String targetId, String targetType, String push_link, String deviceToken, String deviceType) {
        try {
            if (pushContent != null && pushContent.length() >= 100) {
                pushContent = pushContent.substring(0, 98);
            }
            Sender sender = new Sender(this.appKey, this.masterSecret);
            Notification notification = this.getNotification(title, pushContent, targetId, targetType, push_link);
            Target target = Target.build((String)deviceToken);
            Result result = sender.unicastNotification(notification, target);
            Log.info("pushMessageToOppo,result:{},pushContent:{}, targetId:{}, targetType:{}, push_link:{}", new Object[]{JSON.toJSONString((Object)result), pushContent, targetType, targetId, push_link, deviceType});
            SecurityAuditManager.getInstance().logEvent(zh_name, "\u63a5\u6536\u8bbe\u5907 - OPPO, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50), targetId);
        }
        catch (Exception e) {
            Log.error("pushMessageToOppo,error:{},pushContent:{}, targetId:{}, targetType:{}, push_link:{}", new Object[]{JSON.toJSONString((Object)e), pushContent, targetType, targetId, push_link, deviceType});
            SecurityAuditManager.getInstance().logEvent(zh_name, "\u63a5\u6536\u8bbe\u5907 - OPPO - ERROR - " + StringUtils.abbreviate((String)e.getMessage(), (int)50), targetId);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        OPushMessageUtil o = new OPushMessageUtil("6db61a985605492188fd8af295362e89", "f78e61b3c68f4cfca033fbeba24c97cf");
        o.pushMessage();
    }

    private void pushMessage() {
        try {
            Sender sender = new Sender(this.appKey, this.masterSecret);
            Notification notification = this.getNotification("E-Mobile", "test233XXXX", "1", "132", "1111");
            TargetType t = TargetType.REGISTRATION_ID;
            Target target = Target.build((String)"OPPO_CN_bfc55ef29c1d3ef73ac7d17d874d7b82");
            System.err.println(target.getTargetValue());
            System.out.println(target.getTargetType());
            Result result = sender.unicastNotification(notification, target);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Notification getNotification(String title, String pushContent, String targetId, String targetType, String push_link) {
        Notification notification = new Notification();
        notification.setTitle(title);
        notification.setContent(pushContent);
        notification.setStyle(Integer.valueOf(1));
        notification.setAppMessageId(UUID.randomUUID().toString());
        notification.setClickActionType(Integer.valueOf(0));
        notification.setNetworkType(Integer.valueOf(0));
        return notification;
    }
}

