/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import com.alibaba.fastjson.JSON;
import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.cache.PushDeviceCacheUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class PushDbUtil {
    private static final Logger Log = LoggerFactory.getLogger(PushDbUtil.class);
    private static String INSERT_OFPUSHDEVICE = "INSERT INTO OFPUSHDEVICE (userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName) VALUES (?,?,?,?,?,?,?,?)";
    private static String INSERT_OFPUSHDEVICE_oracle = "INSERT INTO OFPUSHDEVICE (pushid,userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName) VALUES (OFPUSHDEVICE_id.nextval,?,?,?,?,?,?,?,?)";
    private static String INSERT_OFPUSHDEVIECE_mysql = "INSERT INTO OFPUSHDEVICE (userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName) VALUES (?,?,?,?,?,?,?,?)";
    private static String SELECT_OFPUSHDEVICE = "SELECT userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName from OFPUSHDEVICE where userid = ?";
    private static String UPDATE_OFPUSHDEVICESTATUS = "UPDATE OFPUSHDEVICE SET  pushStatus = ? where userid = ?";
    private static String Select_OFPUSHDEVICE = "select * from OFPUSHDEVICE where userid = ? or (token = ? and devicetype = ?) ";
    private static String Delete_OFPUSHDEVICE = "delete from OFPUSHDEVICE where userid = ? or (token = ? and devicetype = ?)";
    private static String Delete_OFPUSHDEVICEBYUSER = "UPDATE OFPUSHDEVICE set token = '-1' where userid = ?";

    private boolean checkPushDevice(PushDevice pd, PushDevice beforepd) {
        if (pd == null || beforepd == null) {
            return false;
        }
        try {
            if (pd.getToken().equals(beforepd.getToken()) && pd.getLanguage().equals(beforepd.getLanguage()) && pd.getType().equals(beforepd.getType()) && pd.getPackageName().equals(pd.getPackageName())) {
                if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
                    return pd.getUserType().equals(pd.getUserType());
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recodePushDeviceResource(JID jid, PushDevice pd, String resource) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String mobilersion;
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("SELECT userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName from OFPUSHDEVICE where userid = ? and (userType = ? or userType is null) ");
            pstmt.setString(1, jid.getNode());
            pstmt.setString(2, resource);
            rs = pstmt.executeQuery();
            String pushStatus = null;
            boolean insertSQL = false;
            while (rs.next()) {
                pushStatus = rs.getString("pushStatus");
                insertSQL = true;
            }
            if (!insertSQL) {
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement("INSERT INTO OFPUSHDEVICE (userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName,userType) VALUES (?,?,?,?,?,?,?,?,?)");
                if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement("INSERT INTO OFPUSHDEVICE (pushid,userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName,userType) VALUES (OFPUSHDEVICE_id.nextval,?,?,?,?,?,?,?,?,?)");
                } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement("INSERT INTO OFPUSHDEVICE (userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName,userType) VALUES (?,?,?,?,?,?,?,?,?)");
                }
                pstmt.setString(1, jid.getNode());
                pstmt.setString(2, pd.getType());
                pstmt.setString(3, pd.getToken());
                pstmt.setString(4, pushStatus);
                pstmt.setString(5, pd.getLanguage());
                pstmt.setString(6, pd.getPushKitDeviceToken());
                mobilersion = pd.getMobileVersion();
                if (mobilersion != null && mobilersion.length() > 2) {
                    mobilersion = "7";
                }
                pstmt.setString(7, mobilersion);
                pstmt.setString(8, pd.getPackageName());
                pstmt.setString(9, pd.getUserType());
                pstmt.execute();
            } else {
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement("update OFPUSHDEVICE set devicetype = ?,token=?,language=?,pushKitDeviceToken=?,mobileVersion=?,packageName=?,userType=? where userid = ? and (userType = ? or userType is null)");
                pstmt.setString(1, pd.getType());
                pstmt.setString(2, pd.getToken());
                pstmt.setString(3, pd.getLanguage());
                pstmt.setString(4, pd.getPushKitDeviceToken());
                mobilersion = pd.getMobileVersion();
                if (mobilersion != null && mobilersion.length() > 2) {
                    mobilersion = "7";
                }
                pstmt.setString(5, mobilersion);
                pstmt.setString(6, pd.getPackageName());
                pstmt.setString(7, pd.getUserType());
                pstmt.setString(8, jid.getNode());
                pstmt.setString(9, pd.getUserType());
                pstmt.execute();
            }
            if (pushStatus != null && !pushStatus.isEmpty()) {
                pd.setPushStatus(pushStatus);
            }
            Log.info("pushdevice :{} ", (Object)JSON.toJSONString((Object)pd));
            PushDeviceCacheUtil pushCache = PushDeviceCacheUtil.getInstance();
            pushCache.put(jid.getNode(), resource, pd);
        }
        catch (SQLException e) {
            try {
                Log.error("recodePushDeviceResource,error:{},e:{},pd:{},jid:{}", new Object[]{e, e.getMessage(), JSON.toJSONString((Object)pd), jid.toString()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordPushDevice(JID jid, PushDevice pd, String resource) {
        if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
            this.recodePushDeviceResource(jid, pd, resource);
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String mobilersion;
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("SELECT userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName from OFPUSHDEVICE where userid = ? ");
            pstmt.setString(1, jid.getNode());
            rs = pstmt.executeQuery();
            String pushStatus = null;
            boolean insertSQL = false;
            while (rs.next()) {
                pushStatus = rs.getString("pushStatus");
                insertSQL = true;
            }
            if (!insertSQL) {
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement(INSERT_OFPUSHDEVICE);
                if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(INSERT_OFPUSHDEVICE_oracle);
                } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(INSERT_OFPUSHDEVIECE_mysql);
                }
                pstmt.setString(1, jid.getNode());
                pstmt.setString(2, pd.getType());
                pstmt.setString(3, pd.getToken());
                pstmt.setString(4, pushStatus);
                pstmt.setString(5, pd.getLanguage());
                pstmt.setString(6, pd.getPushKitDeviceToken());
                mobilersion = pd.getMobileVersion();
                if (mobilersion != null && mobilersion.length() > 2) {
                    mobilersion = "7";
                }
                pstmt.setString(7, mobilersion);
                pstmt.setString(8, pd.getPackageName());
                pstmt.execute();
            } else {
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement("update OFPUSHDEVICE set devicetype = ?,token=?,language=?,pushKitDeviceToken=?,mobileVersion=?,packageName=? where userid = ? ");
                pstmt.setString(1, pd.getType());
                pstmt.setString(2, pd.getToken());
                pstmt.setString(3, pd.getLanguage());
                pstmt.setString(4, pd.getPushKitDeviceToken());
                mobilersion = pd.getMobileVersion();
                if (mobilersion != null && mobilersion.length() > 2) {
                    mobilersion = "7";
                }
                pstmt.setString(5, mobilersion);
                pstmt.setString(6, pd.getPackageName());
                pstmt.setString(7, jid.getNode());
                pstmt.execute();
            }
            if (pushStatus != null && !pushStatus.isEmpty()) {
                pd.setPushStatus(pushStatus);
            }
            Log.info("pushdevice :{} ", (Object)JSON.toJSONString((Object)pd));
            PushDeviceCacheUtil pushCache = PushDeviceCacheUtil.getInstance();
            pushCache.put(jid.getNode(), pd);
        }
        catch (SQLException e) {
            try {
                Log.error("recordPushDevice,error:{},e:{},pd:{},jid:{}", new Object[]{e, e.getMessage(), JSON.toJSONString((Object)pd), jid.toString()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    public void registerPush(JID jid, PushDevice pd) {
        if (null == pd) {
            return;
        }
        PushDevice pdBefore = null;
        pdBefore = JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false) ? this.getRegisterPush(jid, pd.getUserType()) : this.getRegisterPush(jid);
        if (this.checkPushDevice(pd, pdBefore)) {
            Log.info("registerPush token has exist.jid={},token={},type={},packageName:{},mobileVersion:{}", new Object[]{jid.toString(), pd.getToken(), pd.getType(), pd.getPackageName(), pd.getMobileVersion()});
            return;
        }
        this.recordPushDevice(jid, pd, pd.getUserType());
        Log.info("registerPush ok, del and register, jid={},token={},type={},mobileVersion:{},packageName:{}", new Object[]{jid.toString(), pd.getToken(), pd.getType(), pd.getMobileVersion(), pd.getPackageName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PushDevice getRegisterPush(JID jid, String resource) {
        PushDevice pushDevice;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        PushDeviceCacheUtil pushCache;
        PushDevice pd;
        block7: {
            pd = null;
            pushCache = PushDeviceCacheUtil.getInstance();
            pd = pushCache.get(jid.getNode(), resource);
            if (pd != null) {
                return pd;
            }
            con = null;
            pstmt = null;
            rs = null;
            con = DbConnectionManager.getConnection();
            String SQL = "SELECT userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName,userType from OFPUSHDEVICE where userid = ? and userType= ? ";
            if ("mobile".equals(resource)) {
                SQL = "SELECT userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName,userType from OFPUSHDEVICE where userid = ? and (userType= ?  or userType is null )";
            }
            pstmt = con.prepareStatement(SQL);
            pstmt.setString(1, jid.getNode());
            pstmt.setString(2, resource);
            rs = pstmt.executeQuery();
            if (!rs.next()) break block7;
            String type = rs.getString("devicetype");
            String token = rs.getString("token");
            String pushStatus = rs.getString("pushStatus");
            String language = rs.getString("language");
            String pushKitDeviceToken = rs.getString("pushKitDeviceToken");
            String mobileVersion = rs.getString("mobileVersion");
            String packageName = rs.getString("packageName");
            String userType = rs.getString("userType");
            pd = new PushDevice(type, token, pushStatus, language, pushKitDeviceToken, mobileVersion, packageName, userType);
            pushCache.put(jid.getNode(), pd);
            PushDevice pushDevice2 = pd;
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return pushDevice2;
        }
        try {
            pd = new PushDevice("", "", "", "", "", "", "", "");
            pushCache.put(jid.getNode(), resource, pd);
            pushDevice = pd;
        }
        catch (Exception e) {
            try {
                Log.error("getRegisterPush,jid={},{},err={}", new Object[]{jid.getNode(), jid.getResource(), e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return null;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return pushDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PushDevice getRegisterPush(JID jid) {
        PushDevice type222;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        PushDeviceCacheUtil pushCache;
        PushDevice pd;
        block6: {
            pd = null;
            pushCache = PushDeviceCacheUtil.getInstance();
            pd = pushCache.get(jid.getNode());
            if (pd != null) {
                return pd;
            }
            con = null;
            pstmt = null;
            rs = null;
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(SELECT_OFPUSHDEVICE);
            pstmt.setString(1, jid.getNode());
            rs = pstmt.executeQuery();
            if (!rs.next()) break block6;
            String type222 = rs.getString("devicetype");
            String token = rs.getString("token");
            String pushStatus = rs.getString("pushStatus");
            String language = rs.getString("language");
            String pushKitDeviceToken = rs.getString("pushKitDeviceToken");
            String mobileVersion = rs.getString("mobileVersion");
            String packageName = rs.getString("packageName");
            pd = new PushDevice(type222, token, pushStatus, language, pushKitDeviceToken, mobileVersion, packageName);
            pushCache.put(jid.getNode(), pd);
            PushDevice pushDevice = pd;
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return pushDevice;
        }
        try {
            pd = new PushDevice("", "", "", "", "", "", "");
            pushCache.put(jid.getNode(), pd);
            type222 = pd;
        }
        catch (Exception e) {
            try {
                Log.error("getRegisterPush,jid={},{},err={}", new Object[]{jid.getNode(), jid.getResource(), e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return null;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return type222;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPush(JID jid) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            String sql = " UPDATE OFPUSHDEVICE set token = '-1' where userid = ? ";
            if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
                sql = " UPDATE OFPUSHDEVICE set token = '-1' where userid = ?  and userType = ? ";
            }
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, jid.getNode());
            if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
                pstmt.setString(2, jid.getResource());
            }
            pstmt.execute();
            PushDeviceCacheUtil pushCache = PushDeviceCacheUtil.getInstance();
            if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
                pushCache.remove(jid.getNode(), jid.getResource());
            } else {
                pushCache.remove(jid.getNode());
            }
            Log.info("unregisterPush ok,jid={},{}", (Object)jid.getNode(), (Object)jid.getResource());
        }
        catch (Exception e) {
            try {
                Log.info("unregisterPush,jid={},err={}", (Object)jid.toString(), (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPushStatus(JID jid, String pushStatus, String resource) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
                pstmt = con.prepareStatement("UPDATE OFPUSHDEVICE SET  pushStatus = ? where userid = ? and userType =? ");
                pstmt.setString(1, pushStatus);
                pstmt.setString(2, jid.getNode());
                pstmt.setString(3, resource);
            } else {
                pstmt = con.prepareStatement(UPDATE_OFPUSHDEVICESTATUS);
                pstmt.setString(1, pushStatus);
                pstmt.setString(2, jid.getNode());
            }
            pstmt.execute();
            PushDeviceCacheUtil pushCache = PushDeviceCacheUtil.getInstance();
            if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
                pushCache.remove(jid.getNode(), resource);
            } else {
                pushCache.remove(jid.getNode());
            }
            Log.info("setPushStatus,jid={},{},pushStatus={}", new Object[]{jid.getNode(), jid.getResource(), pushStatus});
        }
        catch (Exception e) {
            boolean bl;
            try {
                Log.error("setPushStatus,jid={},pushStatus={},{},err={}", new Object[]{jid.getNode(), jid.getResource(), pushStatus, e.getMessage()});
                bl = false;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
            return bl;
        }
        DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        return true;
    }

    public int getBadgeByUserId(String userId) {
        int value = 0;
        try {
            RedisPoolMgr redisPoolMsg = RedisPoolMgr.getInstance();
            if (redisPoolMsg != null) {
                String s = redisPoolMsg.get("apns:badge:" + userId);
                value = s != null && !s.isEmpty() ? Integer.parseInt(s) + 1 : 1;
                redisPoolMsg.set("apns:badge:" + userId, String.valueOf(value), -1);
            }
        }
        catch (Exception e) {
            Log.error("getBadgeByUserId ,error :{} ,e :{} .userId :{} ", new Object[]{e.getMessage(), e, userId});
            value = 1;
        }
        return value;
    }
}

