/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import com.alibaba.fastjson.JSONArray;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.push.PushDbUtil;
import org.jivesoftware.openfire.plugin.push.PushMessageToWeAPPJpushUtil;
import org.jivesoftware.openfire.plugin.push.PushMessageWithPackage;
import org.jivesoftware.openfire.plugin.push.weapppush.WeAppPushUtil;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class PushKitThread
extends Thread {
    private static final Logger Log = LoggerFactory.getLogger(PushKitThread.class);
    private String alert;
    private JSONArray userJSONArray;
    private String content;

    public PushKitThread(JSONArray userJSONArray, String alert, String content) {
        this.alert = alert;
        this.userJSONArray = userJSONArray;
        this.content = content;
    }

    @Override
    public void run() {
        Log.info("start push ,alert :{},content:{},userJSONArray:{}", new Object[]{this.alert, this.content, this.userJSONArray});
        this.pushMessageForPushKit();
    }

    private void pushMessageForPushKit() {
        for (int i = 0; i < this.userJSONArray.size(); ++i) {
            String username = this.userJSONArray.getString(i).toLowerCase();
            PushDbUtil db = new PushDbUtil();
            PushDevice pd = null;
            if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
                if (!this.checkUserOnline(username, "mobile")) {
                    JID mobileJId = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
                    pd = db.getRegisterPush(mobileJId, "mobile");
                    if (pd == null || pd.getToken() == null || "-1".equals(pd.getToken())) {
                        Log.warn("user is not login or user pushdevice is null.username:{},alert:{}", (Object)username, (Object)this.alert);
                    } else {
                        this.pushMessage(pd, username);
                    }
                } else {
                    Log.error("\u624b\u673a\u7aef\u5728\u7ebf\uff0c\u4e0d\u89e6\u53d1\u97f3\u89c6\u9891\u6d88\u606f\u79bb\u7ebf\u63a8\u9001\uff1ausername :{},alert:{}", (Object)username, (Object)this.alert);
                }
                if (!this.checkUserOnline(username, "pad")) {
                    JID padJID = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
                    pd = db.getRegisterPush(padJID, "pad");
                    if (pd == null || pd.getToken() == null || "-1".equals(pd.getToken())) {
                        Log.warn("user is not login or user pushdevice is null.username:{},alert:{}", (Object)username, (Object)this.alert);
                        continue;
                    }
                    this.pushMessage(pd, username);
                    continue;
                }
                Log.error("\u624b\u673a\u7aef\u5728\u7ebf\uff0c\u4e0d\u89e6\u53d1\u97f3\u89c6\u9891\u6d88\u606f\u79bb\u7ebf\u63a8\u9001\uff1ausername :{},alert:{}", (Object)username, (Object)this.alert);
                continue;
            }
            if (!this.checkUserOnline(username, "mobile")) {
                JID jid = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
                pd = db.getRegisterPush(jid);
                if (pd == null || pd.getToken() == null || "-1".equals(pd.getToken())) {
                    Log.warn("user is not login or user pushdevice is null.username:{},alert:{}", (Object)username, (Object)this.alert);
                    continue;
                }
                this.pushMessage(pd, username);
                continue;
            }
            Log.error("\u624b\u673a\u7aef\u5728\u7ebf\uff0c\u4e0d\u89e6\u53d1\u97f3\u89c6\u9891\u6d88\u606f\u79bb\u7ebf\u63a8\u9001\uff1ausername :{},alert:{}", (Object)username, (Object)this.alert);
        }
    }

    private void pushMessage(PushDevice pd, String username) {
        PushDbUtil db = new PushDbUtil();
        String pushType = pd.getType();
        int msgSubType = 1;
        try {
            if ("101".equals(pushType)) {
                String title = null;
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                PushMessageToWeAPPJpushUtil.pushMessageToIos(pd.getType(), pd.getPackageName(), pd.getToken(), title, this.alert, "9dcb0b7def279f5b2b89d91f", "40d9802cd6e57c17780e9f69", null, null, null, null, "\u97f3\u89c6\u9891", true, false, this.content, msgSubType);
            } else if ("103".equals(pushType)) {
                String title = "EMobile7";
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToJPushAndroid(pd.getPackageName(), pd.getToken(), title, this.alert, null, null, null, "f3f6b85f6261ed0b4e2c74ad", "71f209810b4dc534109c7147", null, false, msgSubType);
            } else if ("105".equals(pushType)) {
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                String title = "EMobile7";
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                weAppPushUtil.pushMessageToHuawei("com.weaver.emobile7", pd.getToken(), null, null, null, title, this.alert, "weaver.fw.com.WelcomeActivity", "\u97f3\u89c6\u9891", false, msgSubType);
            } else if ("104".equals(pushType)) {
                String title = "EMobile7";
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToXiaoMi("com.weaver.emobile7", pd.getToken(), null, null, null, title, this.alert, "\u97f3\u89c6\u9891", false, msgSubType);
            } else if ("106".equals(pushType)) {
                String title = "EM7\u5185\u6d4b\u7248";
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                PushMessageToWeAPPJpushUtil.pushMessageToIos(pd.getType(), pd.getPackageName(), pd.getToken(), title, this.alert, "08e193076a0d41aa3d350ab3", "35348f37697702a425cde3ec", null, null, null, null, "\u97f3\u89c6\u9891", true, false, this.content, msgSubType);
            } else if ("116".equals(pd.getType())) {
                String title = null;
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                int badge = db.getBadgeByUserId(username);
                weAppPushUtil.pushMessageToApns("com.tanhas.emobile7", pd.getToken(), null, null, null, title, this.alert, badge, null, "call.caf", true, "4", "\u97f3\u89c6\u9891", false, this.content, msgSubType);
            } else if ("111".equals(pd.getType())) {
                String title = null;
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                int badge = db.getBadgeByUserId(username);
                weAppPushUtil.pushMessageToApns("com.weaver.emobile7", pd.getToken(), null, null, null, title, this.alert, badge, null, "call.caf", true, "5", "\u97f3\u89c6\u9891", false, this.content, msgSubType);
            } else if ("110".equals(pd.getType())) {
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                int badge = db.getBadgeByUserId(username);
                String title = null;
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                weAppPushUtil.pushMessageToApns(pd.getPackageName(), pd.getToken(), null, null, null, title, this.alert, badge, null, "call.caf", false, null, "\u97f3\u89c6\u9891", false, null, msgSubType);
            } else if ("117".equals(pd.getType())) {
                String title = null;
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                weAppPushUtil.pushMessageToHonor(pd.getPackageName(), pd.getToken(), false, title, this.alert, "weaver.fw.com.WelcomeActivity", "\u97f3\u89c6\u9891", null, null, null, msgSubType);
            } else if ("112".equals(pd.getType())) {
                String title = "EMobile7";
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToFireBase(pd.getPackageName(), title, this.alert, pd.getToken(), "\u97f3\u89c6\u9891", null, false, msgSubType);
            } else if ("121".equals(pd.getType()) || "113".equals(pd.getType())) {
                String title = "EMobile7";
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToViVo(pd.getPackageName(), pd.getToken(), null, null, null, title, this.alert, "\u97f3\u89c6\u9891", false, msgSubType);
            } else if ("122".equals(pd.getType()) || "114".equals(pd.getType())) {
                String title = "EMobile7";
                if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                    title = JiveGlobals.getProperty((String)"sysnotice_info");
                }
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToOppo(pd.getPackageName(), pd.getToken(), null, null, null, title, this.alert, "\u97f3\u89c6\u9891", false, msgSubType);
            } else if ("201".equals(pd.getType()) || "202".equals(pd.getType()) || "203".equals(pd.getType()) || "204".equals(pd.getType()) || "205".equals(pd.getType()) || "206".equals(pd.getType())) {
                PushMessageWithPackage.pushMessageWithPackage(pd.getType(), pd.getPackageName(), this.alert, pd.getToken(), null, null, null, "\u97f3\u89c6\u9891", null, false, msgSubType, pd.getMobileVersion());
            }
        }
        catch (Exception e) {
            Log.error("push failed, unknown exception, to jid:{},alert:{}, err:{}", new Object[]{username, this.alert, e.getMessage()});
        }
    }

    private boolean checkUserOnline(String username, String resource) {
        ClusterRedisUtil clusterRedisUtil;
        String clusterNode;
        boolean isOnline = false;
        JID jid = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), resource, true);
        ClientSession clientSession = XMPPServer.getInstance().getRoutingTable().getClientRoute(jid);
        if (clientSession != null && !clientSession.isAnonymousUser() && !clientSession.isClosed()) {
            isOnline = true;
            return isOnline;
        }
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        if (!isOnline && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(jid)) != null && !clusterNode.isEmpty()) {
            isOnline = true;
        }
        return isOnline;
    }
}

