/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.push.PushInfoBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushMessageDataUtil {
    private static final Logger Log = LoggerFactory.getLogger(PushMessageDataUtil.class);
    private static final String GET_PUSHINFO = "select packagename,appName from ofpushinfoNew where  packagename = ? ";
    private static String pushInfoKey = "pushInfoKey:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushInfoBean getPushInfo(String packageName) {
        String redisValue;
        if ("com.weaver.emb7".equals(packageName)) {
            PushInfoBean pushInfoBean = new PushInfoBean();
            pushInfoBean.setAppName("\u79d2\u529e");
            return pushInfoBean;
        }
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null && (redisValue = redisPoolMgr.get(pushInfoKey + packageName)) != null && !redisValue.isEmpty()) {
            PushInfoBean pushInfoBean = new PushInfoBean();
            String appName = redisValue;
            if (appName == null || appName.isEmpty()) {
                redisPoolMgr.del(pushInfoKey + packageName);
            } else {
                pushInfoBean.setAppName(appName);
                return pushInfoBean;
            }
        }
        PushInfoBean pushInfoBean = null;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_PUSHINFO);
            pstmt.setString(1, packageName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                pushInfoBean = new PushInfoBean();
                String appName = rs.getString("appName");
                if (appName == null || appName.isEmpty()) {
                    pushInfoBean.setAppName("EMobile7");
                    continue;
                }
                pushInfoBean.setAppName(appName);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getPushInfo.error:{},packageName:{}", (Object)e.getMessage(), (Object)packageName);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        if (redisPoolMgr != null && pushInfoBean != null) {
            redisPoolMgr.set(pushInfoKey + packageName, pushInfoBean.getAppName(), 2592000);
        }
        return pushInfoBean;
    }
}

