/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.KeystoreException;
import javapns.devices.Device;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.push.PushDbUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushMessageForApns {
    private static final Logger Log = LoggerFactory.getLogger(PushMessageForApns.class);
    private static PushDbUtil db = new PushDbUtil();
    PushNotificationManager pushManager = new PushNotificationManager();
    private static PushMessageForApns instance = null;
    private static String certificatePath = null;
    private static String certificatePassword = null;

    public static PushMessageForApns getInstance() {
        if (instance == null) {
            instance = new PushMessageForApns();
        }
        return instance;
    }

    private PushMessageForApns() {
        certificatePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "push.p12";
        certificatePassword = PushMessageForApns.getCerticatePassword();
    }

    public boolean pushToPushKitForEmobile7AppStore(String alert, PushDevice pd, String userId) {
        try {
            long startTime = System.currentTimeMillis();
            PushNotificationPayload payLoad = new PushNotificationPayload();
            this.pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)certificatePath, certificatePassword, true));
            payLoad.addAlert(alert);
            payLoad.addBadge(db.getBadgeByUserId(userId));
            payLoad.addSound("default");
            BasicDevice device = new BasicDevice();
            device.setToken(pd.getPushKitDeviceToken());
            PushedNotification notification = this.pushManager.sendNotification((Device)device, (Payload)payLoad, true);
            this.pushManager.stopConnection();
            Log.info("PushMessageForApns result:{},cost :{} ms ", (Object)notification.toString(), (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            Log.error("PushMessageForApns,error:{},pushConent:{}", (Object)e.getMessage(), (Object)alert);
            instance = null;
            try {
                this.pushManager.stopConnection();
            }
            catch (CommunicationException e1) {
                e1.printStackTrace();
            }
            catch (KeystoreException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        PushDevice pd = new PushDevice();
        pd.setPushKitDeviceToken("88c9f29a95e5bbc822134662a3b20532e7565505507e33fdd1ad14708f0d60b8");
        PushMessageForApns p = PushMessageForApns.getInstance();
        for (int i = 0; i < 100; ++i) {
            p.pushToPushKitForEmobile7AppStore("test" + i, pd, String.valueOf(i));
        }
        System.out.println(System.currentTimeMillis() - startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCerticatePassword() {
        InputStream is = null;
        String apnsPassword = "weaverqaz";
        try {
            String filePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "push.properties";
            File file = new File(filePath);
            is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            apnsPassword = prop.getProperty("apnsPassword", "weaverqaz");
        }
        catch (Exception e) {
            apnsPassword = "weaverqaz";
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return apnsPassword;
    }
}

