/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import bingo.jpush.base.ClientSendService;
import bingo.jpush.model.PushMessage;
import bingo.jpush.model.ResultModel;
import bingo.jpush.utils.httpclientutil.exception.HttpProcessException;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jivesoftware.openfire.plugin.util.UDIDUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushMessageForBingoJpush {
    private static String filePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "BingoJpush.properties";
    private static final Logger Log = LoggerFactory.getLogger(PushMessageForBingoJpush.class);
    private String jpushUrl;
    private String jpushAppId;
    private String jpushAppKey;
    private String jpushMasterSecret;
    private String title;
    private String logoUrl;
    private int msgType;
    private int isRing;
    private int isFloat;
    private int isVibrate;
    private int isClearable;
    private boolean useBingoJpush;
    private static PushMessageForBingoJpush instance = null;

    public static void pushMessageForBingoJPush(String pushContent, String deviceToken, String type) {
        ClientSendService cls = new ClientSendService();
        PushMessage pushMessage = PushMessageForBingoJpush.getPushMessage(pushContent, deviceToken);
        try {
            ResultModel resultModel = cls.sendNotice(pushMessage);
            Log.info("pushMessageForBingoJPush,pushContent:{},deviceToken:{},pushMessage:{},type:{},result:{}", new Object[]{pushContent, deviceToken, JSON.toJSON((Object)pushMessage).toString(), pushContent, deviceToken, type, JSON.toJSON((Object)resultModel).toString()});
        }
        catch (HttpProcessException e) {
            Log.error("pushMessageForBingoJPush,pushContent:{},deviceToken:{},type:{},pushMessage:{},error:{}", new Object[]{pushContent, deviceToken, JSON.toJSON((Object)pushMessage).toString(), pushContent, deviceToken, type, e.getMessage()});
        }
    }

    private static PushMessage getPushMessage(String pushContent, String deviceToken) {
        PushMessage pm = new PushMessage();
        pm.setJpushUrl(PushMessageForBingoJpush.instance.jpushUrl);
        pm.setJpushAppId(PushMessageForBingoJpush.instance.jpushAppId);
        pm.setJpushAppKey(PushMessageForBingoJpush.instance.jpushAppKey);
        pm.setJpushNonceStr(UDIDUtil.getRandomLowercase(24));
        pm.setJpushMasterSecret(PushMessageForBingoJpush.instance.jpushMasterSecret);
        pm.setTitle(PushMessageForBingoJpush.instance.title);
        pm.setText(pushContent);
        pm.setLogoUrl(PushMessageForBingoJpush.instance.logoUrl);
        pm.setMsgType(PushMessageForBingoJpush.instance.msgType);
        pm.setPushType(0);
        pm.setTargetUserType(1);
        pm.setNotifyAction(0);
        pm.setIsRing(PushMessageForBingoJpush.instance.isRing);
        pm.setIsFloat(PushMessageForBingoJpush.instance.isFloat);
        pm.setIsVibrate(PushMessageForBingoJpush.instance.isVibrate);
        pm.setIsClearable(PushMessageForBingoJpush.instance.isClearable);
        pm.setTransmissionContent(pushContent);
        pm.setCidList(new String[]{deviceToken});
        return pm;
    }

    public static PushMessageForBingoJpush getInstance() {
        if (instance == null) {
            instance = new PushMessageForBingoJpush();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PushMessageForBingoJpush() {
        InputStream is = null;
        try {
            File file = new File(filePath);
            is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            this.jpushUrl = prop.getProperty("jpushUrl", "");
            this.jpushAppId = prop.getProperty("jpushAppId", "");
            this.jpushAppKey = prop.getProperty("jpushAppKey", "");
            this.jpushMasterSecret = prop.getProperty("jpushMasterSecret", "");
            this.title = prop.getProperty("title", "E-Mobile");
            this.logoUrl = prop.getProperty("logoUrl", "");
            this.msgType = Integer.valueOf(prop.getProperty("msgType", "0"));
            this.isRing = Integer.valueOf(prop.getProperty("isRing", "1"));
            this.isFloat = Integer.valueOf(prop.getProperty("isFloat", "1"));
            this.isVibrate = Integer.valueOf(prop.getProperty("isVibrate", "1"));
            this.isClearable = Integer.valueOf(prop.getProperty("isClearable", "1"));
            this.useBingoJpush = Boolean.valueOf(prop.getProperty("useBingoJpush", "false"));
        }
        catch (Exception e) {
            Log.error("new PushMessageForBingoJpush,error:{}", (Object)e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Log.info("new PushMessageForBingoJpush,useBingoJpush:{},jpushUrl:{},jpushAppId:{},jpushAppKey:{},jpushMasterSecret:{},title:{},logoUrl:{},msgType:{},isRing:{},isFloat:{},isVibrate:{},isClearable:{}", new Object[]{this.useBingoJpush, this.jpushUrl, this.jpushAppId, this.jpushAppKey, this.jpushMasterSecret, this.title, this.logoUrl, this.msgType, this.isRing, this.isFloat, this.isVibrate, this.isClearable});
    }

    public String getJpushUrl() {
        return this.jpushUrl;
    }

    public void setJpushUrl(String jpushUrl) {
        this.jpushUrl = jpushUrl;
    }

    public String getJpushAppId() {
        return this.jpushAppId;
    }

    public void setJpushAppId(String jpushAppId) {
        this.jpushAppId = jpushAppId;
    }

    public String getJpushAppKey() {
        return this.jpushAppKey;
    }

    public void setJpushAppKey(String jpushAppKey) {
        this.jpushAppKey = jpushAppKey;
    }

    public String getJpushMasterSecret() {
        return this.jpushMasterSecret;
    }

    public void setJpushMasterSecret(String jpushMasterSecret) {
        this.jpushMasterSecret = jpushMasterSecret;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public int getIsRing() {
        return this.isRing;
    }

    public void setIsRing(int isRing) {
        this.isRing = isRing;
    }

    public int getIsFloat() {
        return this.isFloat;
    }

    public void setIsFloat(int isFloat) {
        this.isFloat = isFloat;
    }

    public int getIsVibrate() {
        return this.isVibrate;
    }

    public void setIsVibrate(int isVibrate) {
        this.isVibrate = isVibrate;
    }

    public int getIsClearable() {
        return this.isClearable;
    }

    public void setIsClearable(int isClearable) {
        this.isClearable = isClearable;
    }

    public boolean isUseBingoJpush() {
        return this.useBingoJpush;
    }

    public void setUseBingoJpush(boolean useBingoJpush) {
        this.useBingoJpush = useBingoJpush;
    }
}

