/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import com.alibaba.fastjson.JSON;
import com.gexin.rp.sdk.base.IIGtPush;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.exceptions.PushSingleException;
import com.gexin.rp.sdk.tcp.ReceptionHandler;
import com.gexin.rp.sdk.tcp.client.GtPush;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jivesoftware.openfire.plugin.push.GePushTemp.TransmissionTmpl;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushMessageForGePush {
    private String appkey = "";
    private String mastersecret = "";
    private String host = "";
    private String appId = "";
    private String title = "";
    private static String HWExtKV = "";
    private int prot;
    private boolean useIGtPush = false;
    private static PushMessageForGePush instance = null;
    private static String filePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "IGtPush.properties";
    private static final Logger Log = LoggerFactory.getLogger(PushMessageForGePush.class);

    public static PushMessageForGePush getInstance() {
        if (instance == null) {
            instance = new PushMessageForGePush();
        }
        return instance;
    }

    public static void pushMessageToGePush(String content, String pushDevice, String deviceType) {
        try {
            if (instance == null) {
                instance = PushMessageForGePush.getInstance();
            }
            GtPush push = GtPush.getInstance((String)instance.getHost(), (int)PushMessageForGePush.instance.prot, (String)instance.getAppkey(), (String)instance.getMastersecret(), (ReceptionHandler)new ReceptionHandler(){

                public void receive(IIGtPush push, Map<String, Object> message) {
                    for (String key : message.keySet()) {
                        if (!key.equals("extradata")) continue;
                        byte[] bytes = (byte[])message.get(key);
                        System.out.println(new String(bytes));
                    }
                }
            });
            SingleMessage singleMessage = new SingleMessage();
            singleMessage.setOffline(true);
            singleMessage.setOfflineExpireTime(86400000L);
            singleMessage.setPushNetWorkType(0);
            TransmissionTemplate template = TransmissionTmpl.TransmissionTemplate(instance.getAppId(), instance.getAppkey(), content, deviceType, instance.getTitle(), HWExtKV);
            singleMessage.setData((ITemplate)template);
            Target target = new Target();
            target.setAppId(instance.getAppId());
            target.setClientId(pushDevice);
            Log.error("Template_setting" + template.getPushInfo());
            IPushResult iPushResult = push.pushMessageToSingle(singleMessage, target);
            Log.info("pushMessageToGePush,content:{},pushDevice:{},deviceType:{},appID:{},result:{}", new Object[]{content, pushDevice, deviceType, instance.getAppId(), JSON.toJSON((Object)iPushResult).toString()});
        }
        catch (PushSingleException e1) {
            Log.error("pushMessageToGePush,content:{},pushDevice:{},deviceType:{},host:{},appKey:{},secret:{},appId:{},error:{}", new Object[]{content, pushDevice, deviceType, instance.getHost(), instance.getAppkey(), instance.getMastersecret(), instance.getAppId(), e1});
            Log.error("pushERROR :{}", (Throwable)e1);
        }
        catch (Exception e) {
            Log.error("pushMessageToGePush,content:{},pushDevice:{},deviceType:{},host:{},appKey:{},secret:{},appId:{},error:{}", new Object[]{content, pushDevice, deviceType, instance.getHost(), instance.getAppkey(), instance.getMastersecret(), instance.getAppId(), e.getMessage()});
            Log.error("pushERROR2 :{}", (Throwable)e);
            instance = null;
        }
    }

    public String getAppkey() {
        return this.appkey;
    }

    public String getMastersecret() {
        return this.mastersecret;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isUseIGtPush() {
        return this.useIGtPush;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public int getProt() {
        return this.prot;
    }

    public void setProt(int prot) {
        this.prot = prot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PushMessageForGePush() {
        InputStream is = null;
        try {
            File file = new File(filePath);
            is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            this.appkey = prop.getProperty("appkey", "");
            this.mastersecret = prop.getProperty("mastersecret", "");
            this.host = prop.getProperty("host", "");
            this.appId = prop.getProperty("appId", "");
            this.title = prop.getProperty("title", "E-Mobile");
            this.prot = Integer.parseInt(prop.getProperty("prot"));
            this.useIGtPush = Boolean.valueOf(prop.getProperty("useIGtPush", "false"));
            HWExtKV = prop.getProperty("HWExtKV");
        }
        catch (Exception e) {
            Log.error("new PushMessageForGePush,error:{}", (Object)e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Log.info("new PushMessageForGePush,appkey:{},mastersecret:{},host:{},useIGtPush:{}", new Object[]{this.appkey, this.mastersecret, this.host, this.useIGtPush});
    }

    public static void main(String[] args) throws Exception {
        PushMessageForGePush.pushMessageToGePush("", "", "");
    }
}

