/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.connection.HttpProxy;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.alibaba.fastjson.JSONObject;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Sender;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.jivesoftware.openfire.plugin.bean.HttpProxyForPush;
import org.jivesoftware.openfire.plugin.push.PushInfoBean;
import org.jivesoftware.openfire.plugin.push.PushMessageDataUtil;
import org.jivesoftware.openfire.plugin.push.weapppush.WeAppPushUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushMessageWithPackage {
    private static final Logger Log = LoggerFactory.getLogger(PushMessageWithPackage.class);
    private static Map<String, JPushClient> jpushClientForIos = new HashMap<String, JPushClient>();
    private static Map<String, JPushClient> jpushClientForAndroid = new HashMap<String, JPushClient>();
    private static Map<String, Sender> xiaoMiPushSender = new HashMap<String, Sender>();
    private static Map<String, Long> huaweiPushAccessTokenEx = new HashMap<String, Long>();
    private static Map<String, String> huaweiPushAccessToken = new HashMap<String, String>();
    public static long jpushTimeToLive = JiveGlobals.getLongProperty((String)"jpush.time.to.live.second", (long)86400L);

    public static void pushMessageWithPackage(String type, String packageName, String pushContent, String deviceToken, String targetType, String targetId, String push_link, String zh_name, String title, boolean isIMMsg, int msgSubType, String mobileVersion) throws Exception {
        if (!"201".equals(type)) {
            if ("202".equals(type)) {
                PushInfoBean pushInfoBean = PushMessageDataUtil.getPushInfo(packageName);
                String appName = "EMobile7";
                if (pushInfoBean != null) {
                    appName = pushInfoBean.getAppName();
                }
                if (title != null && !title.isEmpty()) {
                    appName = title;
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToJPushAndroid(packageName, deviceToken, appName, pushContent, targetType, targetId, push_link, null, null, zh_name, isIMMsg, msgSubType);
            } else if ("203".equals(type)) {
                PushInfoBean pushInfoBean;
                if ("weaver.fw.com".equals(packageName)) {
                    WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                    weAppPushUtil.pushMessageToXiaoMi(packageName, deviceToken, targetType, targetId, push_link, "EM7\u5185\u6d4b\u7248", pushContent, zh_name, isIMMsg, msgSubType);
                    return;
                }
                String appName = null;
                appName = title != null && !title.isEmpty() ? title : ((pushInfoBean = PushMessageDataUtil.getPushInfo(packageName)) == null || pushInfoBean.getAppName() == null ? "EMobile7" : pushInfoBean.getAppName());
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToXiaoMi(packageName, deviceToken, targetType, targetId, push_link, appName, pushContent, zh_name, isIMMsg, msgSubType);
            } else if ("204".equals(type)) {
                WeAppPushUtil weAppPushUtil;
                PushInfoBean pushInfoBean;
                if ("weaver.fw.com".equals(packageName)) {
                    WeAppPushUtil weAppPushUtil2 = WeAppPushUtil.getInstance();
                    weAppPushUtil2.pushMessageToHuawei(packageName, deviceToken, targetType, targetId, push_link, "EM7\u5185\u6d4b\u7248", pushContent, "weaver.fw.com.WelcomeActivity", zh_name, isIMMsg, msgSubType);
                    return;
                }
                String appName = null;
                appName = title != null && !title.isEmpty() ? title : ((pushInfoBean = PushMessageDataUtil.getPushInfo(packageName)) == null || pushInfoBean.getAppName() == null ? "EMobile7" : pushInfoBean.getAppName());
                if ("0".equals(mobileVersion)) {
                    weAppPushUtil = WeAppPushUtil.getInstance();
                    weAppPushUtil.pushMessageToHarmonyOS(packageName, deviceToken, targetType, targetId, push_link, appName, pushContent, zh_name, isIMMsg, msgSubType);
                } else {
                    weAppPushUtil = WeAppPushUtil.getInstance();
                    weAppPushUtil.pushMessageToHuawei(packageName, deviceToken, targetType, targetId, push_link, appName, pushContent, "weaver.fw.com.WelcomeActivity", zh_name, isIMMsg, msgSubType);
                }
            } else if ("205".equals(type)) {
                String appConfigName;
                PushInfoBean pushInfoBean = PushMessageDataUtil.getPushInfo(packageName);
                String appName = "EMobile7";
                if (pushInfoBean != null && (appConfigName = pushInfoBean.getAppName()) != null && !appConfigName.isEmpty()) {
                    appName = appConfigName;
                }
                if (title != null && !title.isEmpty()) {
                    appName = title;
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToViVo(packageName, deviceToken, targetType, targetId, push_link, appName, pushContent, zh_name, isIMMsg, msgSubType);
            } else if ("206".equals(type)) {
                String appConfigName;
                PushInfoBean pushInfoBean = PushMessageDataUtil.getPushInfo(packageName);
                String appName = "EMobile7";
                if (pushInfoBean != null && (appConfigName = pushInfoBean.getAppName()) != null && !appConfigName.isEmpty()) {
                    appName = appConfigName;
                }
                if (title != null && !title.isEmpty()) {
                    appName = title;
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToOppo(packageName, deviceToken, targetType, targetId, push_link, appName, pushContent, zh_name, isIMMsg, msgSubType);
            } else if ("207".equals(type)) {
                String appConfigName;
                PushInfoBean pushInfoBean = PushMessageDataUtil.getPushInfo(packageName);
                String appName = "EMobile7";
                if (pushInfoBean != null && (appConfigName = pushInfoBean.getAppName()) != null && !appConfigName.isEmpty()) {
                    appName = appConfigName;
                }
                if (title != null && !title.isEmpty()) {
                    appName = title;
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToHonor(packageName, deviceToken, isIMMsg, appName, pushContent, "weaver.fw.com.WelcomeActivity", zh_name, targetType, targetId, push_link, msgSubType);
            } else if ("208".equals(type)) {
                String appConfigName;
                PushInfoBean pushInfoBean = PushMessageDataUtil.getPushInfo(packageName);
                String appName = "EMobile7";
                if (pushInfoBean != null && (appConfigName = pushInfoBean.getAppName()) != null && !appConfigName.isEmpty()) {
                    appName = appConfigName;
                }
                if (title != null && !title.isEmpty()) {
                    appName = title;
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToHarmonyOS(packageName, deviceToken, targetType, targetId, push_link, title, pushContent, zh_name, isIMMsg, msgSubType);
            } else {
                Log.warn("pushMessageWithPackage.unkown push type.type:{},packageName:{},pushContent:{},deviceToken:{},targetType:{},targetId:{},push_link:{}", new Object[]{type, packageName, pushContent, deviceToken, targetType, targetId, push_link});
            }
        }
    }

    private static String getAccessToken(String appKey, String secret) throws IOException {
        String accessToken = null;
        if (huaweiPushAccessTokenEx != null && huaweiPushAccessToken != null && huaweiPushAccessToken.containsKey(appKey) && huaweiPushAccessTokenEx.containsKey(appKey)) {
            String accessTokenOld = huaweiPushAccessToken.get(appKey);
            long accessTokenExp = huaweiPushAccessTokenEx.get(appKey);
            if (accessTokenExp <= System.currentTimeMillis()) {
                huaweiPushAccessTokenEx.remove(appKey);
                huaweiPushAccessToken.remove(appKey);
            } else {
                accessToken = accessTokenOld;
                return accessToken;
            }
        }
        String msgBody = MessageFormat.format("grant_type=client_credentials&client_secret={0}&client_id={1}", URLEncoder.encode(secret, "UTF-8"), appKey);
        String response = PushMessageWithPackage.httpPost("https://login.cloud.huawei.com/oauth2/v2/token", msgBody, 5000, 5000);
        JSONObject obj = JSONObject.parseObject((String)response);
        accessToken = obj.getString("access_token");
        long tokenExpiredTimeForEmobile6 = System.currentTimeMillis() + obj.getLong("expires_in") - 300000L;
        huaweiPushAccessTokenEx.put(appKey, tokenExpiredTimeForEmobile6);
        huaweiPushAccessToken.put(appKey, accessToken);
        return accessToken;
    }

    private static com.xiaomi.xmpush.server.Message buildMessage(String pushContent, String packageName, String appName, String targetType, String targetId, String push_link, String title) throws Exception {
        if (title != null && !title.isEmpty()) {
            appName = title;
        }
        if (targetType != null && !targetType.isEmpty() && targetId != null && !targetId.isEmpty()) {
            if (push_link == null || push_link.isEmpty()) {
                com.xiaomi.xmpush.server.Message message = new Message.Builder().title(appName).description(pushContent).payload(pushContent).restrictedPackageName(packageName).passThrough(0).notifyType(Integer.valueOf(-1)).notifyId(Integer.valueOf(new Random().nextInt())).extra("targetType", targetType).extra("targetId", targetId).extra("channel_id", "high_system").build();
                return message;
            }
            com.xiaomi.xmpush.server.Message message = new Message.Builder().title(appName).description(pushContent).payload(pushContent).restrictedPackageName(packageName).passThrough(0).notifyType(Integer.valueOf(-1)).notifyId(Integer.valueOf(new Random().nextInt())).extra("targetType", targetType).extra("targetId", targetId).extra("push_link", push_link).extra("channel_id", "high_system").build();
            return message;
        }
        com.xiaomi.xmpush.server.Message message = new Message.Builder().title(appName).description(pushContent).payload(pushContent).restrictedPackageName(packageName).passThrough(0).notifyType(Integer.valueOf(1)).notifyId(Integer.valueOf(new Random().nextInt())).build();
        return message;
    }

    private static Sender getSenderForXiaoMi(String secret) {
        Sender sender = null;
        if (xiaoMiPushSender != null && xiaoMiPushSender.containsKey(secret) && (sender = xiaoMiPushSender.get(secret)) != null) {
            return sender;
        }
        sender = new Sender(secret);
        xiaoMiPushSender.put(secret, sender);
        return sender;
    }

    private static PushPayload getPushPayloadForAndroid(String deviceToken, String pushContent, String targetType, String targetId, String push_link, String title) {
        HashMap<String, String> para = new HashMap<String, String>();
        if (targetType != null && !targetType.isEmpty() && targetId != null && !targetId.isEmpty()) {
            para.put("targetType", targetType);
            para.put("targetId", targetId);
            if (push_link != null && !push_link.isEmpty()) {
                para.put("push_link", push_link);
            }
        }
        if (title == null || title.isEmpty()) {
            title = "\u6d88\u606f\u63d0\u9192:";
        }
        PushPayload payload = null;
        payload = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.registrationId((String[])new String[]{deviceToken})).setMessage(Message.newBuilder().setTitle(title).addExtras(para).setMsgContent(pushContent).build()).setOptions(Options.newBuilder().setApnsProduction(true).setTimeToLive(jpushTimeToLive).build()).build();
        return payload;
    }

    private static PushPayload getPushPayload(String deviceToken, String pushContent, String targetType, String targetId, String push_link, String title) {
        HashMap<String, String> para = new HashMap<String, String>();
        if (targetType != null && !targetType.isEmpty() && targetId != null && !targetId.isEmpty()) {
            para.put("targetType", targetType);
            para.put("targetId", targetId);
            if (push_link != null && !push_link.isEmpty()) {
                para.put("push_link", push_link);
            }
        }
        if (title != null && !title.isEmpty()) {
            JSONObject json = new JSONObject();
            json.put("title", (Object)title);
            json.put("body", (Object)pushContent);
            pushContent = json.toJSONString();
        }
        PushPayload payload = null;
        payload = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.registrationId((String[])new String[]{deviceToken})).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)pushContent).setSound("default").addExtras(para)).setContentAvailable(true).build()).build()).setOptions(Options.newBuilder().setApnsProduction(true).setTimeToLive(jpushTimeToLive).build()).build();
        return payload;
    }

    private static JPushClient getJPushClientAndroid(String appKey, String secret) {
        JPushClient jpushClient = null;
        if (jpushClientForIos != null && jpushClientForAndroid.containsKey(appKey) && (jpushClient = jpushClientForIos.get(appKey)) != null) {
            return jpushClient;
        }
        HttpProxyForPush httpProxyForPush = HttpProxyForPush.getInstance();
        boolean isUserProxy = httpProxyForPush.isUserProxy();
        HttpProxy httpProxy = null;
        ClientConfig clientConfig = null;
        if (isUserProxy) {
            boolean isNeedAuth = httpProxyForPush.isPropxyNeedAuth();
            clientConfig = ClientConfig.getInstance();
            httpProxy = isNeedAuth ? new HttpProxy(httpProxyForPush.getProxyHost(), httpProxyForPush.getProxyPort(), httpProxyForPush.getProxyUsername(), httpProxyForPush.getProxyPassword()) : new HttpProxy(httpProxyForPush.getProxyHost(), httpProxyForPush.getProxyPort());
        }
        jpushClient = httpProxy != null ? new JPushClient(secret, appKey, httpProxy, clientConfig) : new JPushClient(secret, appKey);
        jpushClientForAndroid.put(appKey, jpushClient);
        return jpushClient;
    }

    private static JPushClient getJPushClient(String appKey, String secret) {
        JPushClient jpushClient = null;
        if (jpushClientForIos != null && jpushClientForIos.containsKey(appKey) && (jpushClient = jpushClientForIos.get(appKey)) != null) {
            return jpushClient;
        }
        HttpProxyForPush httpProxyForPush = HttpProxyForPush.getInstance();
        boolean isUserProxy = httpProxyForPush.isUserProxy();
        HttpProxy httpProxy = null;
        ClientConfig clientConfig = null;
        if (isUserProxy) {
            boolean isNeedAuth = httpProxyForPush.isPropxyNeedAuth();
            clientConfig = ClientConfig.getInstance();
            httpProxy = isNeedAuth ? new HttpProxy(httpProxyForPush.getProxyHost(), httpProxyForPush.getProxyPort(), httpProxyForPush.getProxyUsername(), httpProxyForPush.getProxyPassword()) : new HttpProxy(httpProxyForPush.getProxyHost(), httpProxyForPush.getProxyPort());
        }
        jpushClient = httpProxy != null ? new JPushClient(secret, appKey, httpProxy, clientConfig) : new JPushClient(secret, appKey);
        jpushClientForIos.put(appKey, jpushClient);
        return jpushClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String httpUrl, String data, int connectTimeout, int readTimeout) throws IOException {
        String string;
        OutputStream outPut = null;
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        try {
            URL url = new URL(httpUrl);
            HttpProxyForPush httpProxyForPush = HttpProxyForPush.getInstance();
            boolean isUserProxy = httpProxyForPush.isUserProxy();
            if (isUserProxy) {
                InetSocketAddress addr = new InetSocketAddress(httpProxyForPush.getProxyHost(), httpProxyForPush.getProxyPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                urlConnection = (HttpURLConnection)url.openConnection(proxy);
                boolean isNeedAuth = httpProxyForPush.isPropxyNeedAuth();
                if (isNeedAuth) {
                    String encoded = new String(Base64.encodeBase64((byte[])(httpProxyForPush.getProxyUsername() + ":" + httpProxyForPush.getProxyPassword()).getBytes()));
                    urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
            } else {
                urlConnection = (HttpURLConnection)url.openConnection();
            }
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            urlConnection.setConnectTimeout(connectTimeout);
            urlConnection.setReadTimeout(readTimeout);
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes("UTF-8"));
            outPut.flush();
            in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            List lines = IOUtils.readLines((InputStream)in, (String)urlConnection.getContentEncoding());
            StringBuffer strBuf = new StringBuffer();
            for (String line : lines) {
                strBuf.append(line);
            }
            System.out.println(strBuf.toString());
            string = strBuf.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outPut);
            IOUtils.closeQuietly(in);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outPut);
        IOUtils.closeQuietly((InputStream)in);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }
}

