/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaibaoPushUtil {
    private static String appCode = null;
    private static String accountCode = null;
    private static String sysCode = null;
    private static String title = JiveGlobals.getProperty((String)"taibaopushtitle", (String)"\u4e2d\u56fd\u592a\u4fdd");
    private static int encryptFlag = 0;
    private static int msgExpires = 1;
    private static int receiptFlag = 1;
    private static int msgType = 1;
    private static String pushUrl = null;
    private static String sysEnv = null;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String TAIBAO_PUSH_PROP_FILE = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "taibaoPush.properties";
    private static final Logger Log = LoggerFactory.getLogger(TaibaoPushUtil.class);

    public static boolean checkTaibaoPushEnable() {
        TaibaoPushUtil.readTaiBaoProp();
        return pushUrl != null && appCode != null && accountCode != null && sysCode != null;
    }

    public static void main(String[] args) {
        TaibaoPushUtil.readTaiBaoProp();
    }

    private static void readTaiBaoProp() {
        try {
            File file = new File(TAIBAO_PUSH_PROP_FILE);
            if (!file.exists()) {
                return;
            }
            FileReader fileReader = new FileReader(TAIBAO_PUSH_PROP_FILE);
            Properties prop = new Properties();
            Log.info("--\u4ee3\u7801\u5df2\u8986\u76d6\u66f4\u65b0--");
            prop.load(fileReader);
            pushUrl = prop.getProperty("pushUrl");
            appCode = prop.getProperty("appCode");
            accountCode = prop.getProperty("accountCode");
            sysCode = prop.getProperty("sysCode");
            msgExpires = Integer.parseInt(prop.getProperty("msgExpires"));
            receiptFlag = Integer.parseInt(prop.getProperty("receiptFlag"));
            msgType = Integer.parseInt(prop.getProperty("msgType"));
            sysEnv = prop.getProperty("sysEnv");
            Log.info("readTaiBaoProp ,pushUrl:{},appCode:{},accountCode:{},sysCode:{},title:{},msgExpires:{},msgType:{},receiptFlag:{}", new Object[]{pushUrl, appCode, accountCode, sysCode, title, msgExpires, msgType, receiptFlag});
        }
        catch (Exception e) {
            Log.error("TaibaoPushUtil,readTaiBaoProp,error:{},e:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void pushMessageUtil(String msgcontent, String userid, String targetId, String targetType, String push_link, String type) {
        String mesPuthSett = JiveGlobals.getProperty((String)"mesPuthSett", (String)"1");
        if ("1".equals(mesPuthSett)) {
            String param = TaibaoPushUtil.getParam(msgcontent, userid, targetId, targetType, push_link, type, null);
            String pushResult = null;
            if (pushUrl != null && pushUrl.startsWith("http://")) {
                try {
                    pushResult = TaibaoPushUtil.httpPost(pushUrl, param, 5000, 5000, "application/json");
                }
                catch (IOException e) {
                    Log.error("TaibaoPushUtil,pushMessageUtil ,error:{},e:{}", (Object)e.getMessage(), (Object)e);
                }
            } else if (pushUrl != null && pushUrl.startsWith("https://")) {
                try {
                    pushResult = TaibaoPushUtil.httpsPost(pushUrl, param, 5000, 5000, "application/json");
                }
                catch (IOException e) {
                    Log.error("TaibaoPushUtil,pushMessageUtil ,error:{},e:{}", (Object)e.getMessage(), (Object)e);
                }
            }
            Log.info("TaibaoPushUtil.pushMessageUtil ,pushResult :{} ,param :{},mesPuthSett:{} ", new Object[]{pushResult, param, mesPuthSett});
        } else if ("2".equals(mesPuthSett)) {
            String param = TaibaoPushUtil.getParam(msgcontent, userid, targetId, targetType, push_link, type, sysEnv);
            String pushResult = null;
            if (pushUrl != null && pushUrl.startsWith("http://")) {
                try {
                    pushResult = TaibaoPushUtil.httpPost(pushUrl, param, 5000, 5000, "application/json");
                }
                catch (IOException e) {
                    Log.error("TaibaoPushUtil,pushMessageUtil ,error:{},e:{}", (Object)e.getMessage(), (Object)e);
                }
            } else if (pushUrl != null && pushUrl.startsWith("https://")) {
                try {
                    pushResult = TaibaoPushUtil.httpsPost(pushUrl, param, 5000, 5000, "application/json");
                }
                catch (IOException e) {
                    Log.error("TaibaoPushUtil,pushMessageUtil ,error:{},e:{}", (Object)e.getMessage(), (Object)e);
                }
            }
            Log.info("TaibaoPushUtil.pushMessageUtil ,pushResult :{} ,param :{},mesPuthSett:{} ", new Object[]{pushResult, param, mesPuthSett});
        } else if ("3".equals(mesPuthSett)) {
            String param = TaibaoPushUtil.getParam(msgcontent, userid, targetId, targetType, push_link, type, null);
            String pushResult = null;
            if (pushUrl != null && pushUrl.startsWith("http://")) {
                try {
                    pushResult = TaibaoPushUtil.httpPost(pushUrl, param, 5000, 5000, "application/json");
                }
                catch (IOException e) {
                    Log.error("TaibaoPushUtil,pushMessageUtil ,error:{},e:{}", (Object)e.getMessage(), (Object)e);
                }
            } else if (pushUrl != null && pushUrl.startsWith("https://")) {
                try {
                    pushResult = TaibaoPushUtil.httpsPost(pushUrl, param, 5000, 5000, "application/json");
                }
                catch (IOException e) {
                    Log.error("TaibaoPushUtil,pushMessageUtil ,error:{},e:{}", (Object)e.getMessage(), (Object)e);
                }
            }
            Log.info("TaibaoPushUtil.pushMessageUtil ,pushResult :{} ,param :{},mesPuthSett:{} ", new Object[]{pushResult, param, mesPuthSett});
            String param2 = TaibaoPushUtil.getParam(msgcontent, userid, targetId, targetType, push_link, type, sysEnv);
            String pushResult2 = null;
            if (pushUrl != null && pushUrl.startsWith("http://")) {
                try {
                    pushResult2 = TaibaoPushUtil.httpPost(pushUrl, param, 5000, 5000, "application/json");
                }
                catch (IOException e) {
                    Log.error("TaibaoPushUtil,pushMessageUtil ,error:{},e:{}", (Object)e.getMessage(), (Object)e);
                }
            } else if (pushUrl != null && pushUrl.startsWith("https://")) {
                try {
                    pushResult2 = TaibaoPushUtil.httpsPost(pushUrl, param, 5000, 5000, "application/json");
                }
                catch (IOException e) {
                    Log.error("TaibaoPushUtil,pushMessageUtil ,error:{},e:{}", (Object)e.getMessage(), (Object)e);
                }
            }
            Log.info("TaibaoPushUtil.pushMessageUtil ,pushResult2 :{} ,param2 :{},mesPuthSett:{} ", new Object[]{pushResult2, param2, mesPuthSett});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String httpUrl, String data, int connectTimeout, int readTimeout, String Content_Type) throws IOException {
        String string;
        OutputStream outPut = null;
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        try {
            URL url = new URL(httpUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestMethod("POST");
            if (Content_Type != null && !Content_Type.isEmpty()) {
                urlConnection.setRequestProperty("Content-Type", Content_Type);
            }
            urlConnection.setConnectTimeout(connectTimeout);
            urlConnection.setReadTimeout(readTimeout);
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes("UTF-8"));
            outPut.flush();
            in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            List lines = IOUtils.readLines((InputStream)in, (String)urlConnection.getContentEncoding());
            StringBuffer strBuf = new StringBuffer();
            for (String line : lines) {
                strBuf.append(line);
            }
            string = strBuf.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outPut);
            IOUtils.closeQuietly(in);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outPut);
        IOUtils.closeQuietly((InputStream)in);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsPost(String httpUrl, String data, int connectTimeout, int readTimeout, String Content_Type) throws IOException {
        String string;
        OutputStream outPut = null;
        HttpsURLConnection urlConnection = null;
        InputStream in = null;
        try {
            URL url = new URL(httpUrl);
            urlConnection = (HttpsURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            if (Content_Type != null && !Content_Type.isEmpty()) {
                urlConnection.setRequestProperty("Content-Type", Content_Type);
            }
            urlConnection.setConnectTimeout(connectTimeout);
            urlConnection.setReadTimeout(readTimeout);
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes("UTF-8"));
            outPut.flush();
            in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            List lines = IOUtils.readLines((InputStream)in, (String)urlConnection.getContentEncoding());
            StringBuffer strBuf = new StringBuffer();
            for (String line : lines) {
                strBuf.append(line);
            }
            string = strBuf.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outPut);
            IOUtils.closeQuietly(in);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outPut);
        IOUtils.closeQuietly((InputStream)in);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }

    private static String getParam(String msgcontent, String userid, String targetId, String targetType, String push_link, String type, String sysEnv) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appCode", appCode);
        map.put("accountCode", accountCode);
        map.put("sysCode", sysCode);
        map.put("encryptFlag", encryptFlag);
        map.put("msgType", msgType);
        map.put("title", title);
        map.put("msgContent", msgcontent);
        map.put("receiptFlag", receiptFlag);
        if (sysEnv != null && !sysEnv.isEmpty()) {
            map.put("sysEnv", sysEnv);
        }
        int platform = 3;
        if ("501".equals(type)) {
            platform = 4;
        }
        map.put("platform", platform);
        ArrayList<String> userArray = new ArrayList<String>();
        userArray.add(userid);
        map.put("userArray", userArray);
        HashMap<String, String> extra = new HashMap<String, String>();
        if (targetId != null && targetType != null && !targetId.isEmpty() & !targetType.isEmpty()) {
            extra.put("targetId", targetId);
            extra.put("targetType", targetType);
        }
        if (push_link != null && !push_link.isEmpty()) {
            extra.put("push_link", push_link);
        }
        map.put("extras", JSON.toJSONString(extra));
        map.put("msgExpires", msgExpires);
        return JSON.toJSONString(map);
    }
}

