/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push;

import com.alibaba.fastjson.JSON;
import com.vivo.push.sdk.notofication.Message;
import com.vivo.push.sdk.notofication.Result;
import com.vivo.push.sdk.server.Sender;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jivesoftware.openfire.plugin.push.VPushAuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VPushMessageUtil {
    private int appId = 105502047;
    private String appKey = "a40b06fced63e126a105824adbec19cd";
    private String masterSecret = "a3dc7d80-a43a-437f-a0a2-aa04c3ad6d7e";
    private static final Logger Log = LoggerFactory.getLogger(VPushMessageUtil.class);
    private static Map<String, VPushAuthToken> vPushAuthToken = new HashMap<String, VPushAuthToken>();

    public VPushMessageUtil(String appId, String appKey, String masterSercet) {
        this.appId = Integer.parseInt(appId);
        this.appKey = appKey;
        this.masterSecret = masterSercet;
    }

    public static String getAuthToken(Sender sender, String type, int appId, String appKey) {
        String authToken = null;
        if (vPushAuthToken != null && vPushAuthToken.containsKey(type)) {
            VPushAuthToken a = vPushAuthToken.get(type);
            long expire = a.getTimeExprie();
            if (expire > System.currentTimeMillis()) {
                authToken = a.getAuthToken();
            } else {
                try {
                    Result result = sender.getToken(appId, appKey);
                    System.out.println("=================" + result);
                    authToken = result.getAuthToken();
                    VPushAuthToken v = new VPushAuthToken();
                    v.setAuthToken(authToken);
                    v.setTimeExprie(System.currentTimeMillis() + 86100000L);
                    v.setType(type);
                    vPushAuthToken.put(type, v);
                }
                catch (Exception e) {
                    Log.error("vpush ,refore token error : {} ", (Throwable)e);
                }
            }
        } else {
            try {
                Result result = sender.getToken(appId, appKey);
                System.out.println("=================" + result);
                authToken = result.getAuthToken();
                VPushAuthToken v = new VPushAuthToken();
                v.setAuthToken(authToken);
                v.setTimeExprie(System.currentTimeMillis() + 86100000L);
                v.setType(type);
                vPushAuthToken.put(type, v);
            }
            catch (Exception e) {
                Log.error("vpush ,refore token error : {} ", (Throwable)e);
            }
        }
        return authToken;
    }

    public void pushMessageToVIVO(String title, String pushContent, String token, String zh_name, String type, String targetId, String targetType, String push_link) {
        if (pushContent != null && pushContent.length() >= 100) {
            pushContent = pushContent.substring(0, 98);
        }
        try {
            Sender sender = new Sender(this.masterSecret);
            String authToken = VPushMessageUtil.getAuthToken(sender, targetType, this.appId, this.appKey);
            sender.setAuthToken(authToken);
            HashMap<String, String> clientCustomMap = new HashMap<String, String>();
            if (targetId != null) {
                clientCustomMap.put("targetId", targetId);
            }
            if (targetType != null) {
                clientCustomMap.put("targetType", targetType);
            }
            if (push_link != null) {
                clientCustomMap.put("push_link", push_link);
            }
            String requestId = UUID.randomUUID().toString();
            Message singleMessage = new Message.Builder().regId(token).notifyType(4).title(title).content(pushContent).timeToLive(72000).skipType(1).networkType(-1).requestId(requestId).classification(1).pushMode(0).build();
            Result resultMessage = sender.sendSingle(singleMessage);
            Log.info("pushMessageToVIVO,result:{},pushContent:{}, targetId:{}, targetType:{}, push_link:{}", new Object[]{JSON.toJSONString((Object)resultMessage), pushContent, targetType, targetId, push_link, type});
        }
        catch (Exception e) {
            Log.error("pushMessageToVIVO,error:{},pushContent:{}, targetId:{}, targetType:{}, push_link:{}", new Object[]{JSON.toJSONString((Object)e), pushContent, targetType, targetId, push_link, type});
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        VPushMessageUtil vPush = new VPushMessageUtil("105502047", "a3dc7d80-a43a-437f-a0a2-aa04c3ad6d7e", "a40b06fced63e126a105824adbec19cd");
        vPush.pushMessageToVIVO("E-Mobile", "test", "16441349350120204781920", "\u5b59\u5a1c", "113", null, null, null);
    }
}

