/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push.androidconfig;

import com.alibaba.fastjson.JSON;
import com.weaver.cache.redis.RedisPoolMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.push.androidconfig.PushInfoBean;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidConfig {
    private static final String SELECT_PUSHINFO = " select * from ofpushinfo where devicetype = ? and packagename = ? ";
    private static final String UPDATE_PUSHINFO = " update ofpushinfo set appKey = ? , secret = ?,appName=? where devicetype = ? and packagename = ? ";
    private static final String INSERT_PUSHINFO = " insert into ofpushinfo (devicetype,packagename,appKey,secret,appName) values(?,?,?,?,?) ";
    private static String pushInfoKey = "pushInfoKey:";
    private static final Logger Log = LoggerFactory.getLogger(AndroidConfig.class);
    private static final String FILEPATH = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "AndroidPush.json";

    public static void main(String[] args) {
        AndroidConfig.loadAndroidConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAndroidConf() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block8: {
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select packagename,appName from ofpushinfo");
                rs = pstmt.executeQuery();
                HashMap<String, String> pushInfoMap = new HashMap<String, String>();
                while (rs.next()) {
                    String packagename = rs.getString("packagename");
                    String appName = rs.getString("appName");
                    pushInfoMap.put(packagename, appName);
                }
                if (pushInfoMap != null && !pushInfoMap.isEmpty()) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(" insert into ofpushinfoNEW (packagename,appName) values(?,?) ");
                    for (String packagename : pushInfoMap.keySet()) {
                        pstmt.setString(1, packagename);
                        pstmt.setString(2, (String)pushInfoMap.get(packagename));
                        pstmt.addBatch();
                    }
                    if (pstmt != null) {
                        pstmt.executeBatch();
                        pstmt.clearBatch();
                    }
                }
                if (pushInfoMap == null || pushInfoMap.isEmpty()) break block8;
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement(" delete from ofpushinfo where 1=1 ");
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readJsonFile(String fileName) {
        String jsonStr = null;
        InputStreamReader fileReader = null;
        Reader reader = null;
        try {
            File jsonFile = new File(fileName);
            if (!jsonFile.exists()) {
                String string = null;
                return string;
            }
            fileReader = new FileReader(jsonFile);
            reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
            int ch = 0;
            StringBuffer sb = new StringBuffer();
            while ((ch = reader.read()) != -1) {
                sb.append((char)ch);
            }
            String string = jsonStr = sb.toString();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePushInfo(String phonetype, String packagename, String appKey, String secret, String appName) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block6: {
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(SELECT_PUSHINFO);
                pstmt.setString(1, phonetype);
                pstmt.setString(2, packagename);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(UPDATE_PUSHINFO);
                    pstmt.setString(1, appKey);
                    pstmt.setString(2, secret);
                    pstmt.setString(3, appName);
                    pstmt.setString(4, phonetype);
                    pstmt.setString(5, packagename);
                    pstmt.executeUpdate();
                    break block6;
                }
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement(INSERT_PUSHINFO);
                pstmt.setString(1, phonetype);
                pstmt.setString(2, packagename);
                pstmt.setString(3, appKey);
                pstmt.setString(4, secret);
                pstmt.setString(5, appName);
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                try {
                    Log.error("savePushInfo.error:{},phonetype:{},packagename:{},appKey:{},secret:{}", new Object[]{e.getMessage(), phonetype, packagename, appKey, secret});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            PushInfoBean pushInfoBean = new PushInfoBean(appKey, secret, appName);
            redisPoolMgr.set(pushInfoKey + phonetype + packagename, JSON.toJSONString((Object)pushInfoBean), 2592000);
        }
    }
}

