/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push.mpassutil;

import java.net.ProxySelector;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final int MAX_TOTAL_CONNECTIONS = 800;
    private static final int IDEL_TIME = 30;
    private static final int MAX_ROUTE_CONNECTIONS = 400;
    private static final int SOCKET_TIMEOUT = 120000;
    private static final int CONNECTION_REQUEST_TIMEOUT = 120000;
    private static final int CONNECTION_TIMEOUT = 120000;
    private static final int MAX_HEADER_COUNT = 200;
    private static final int MAX_LINE_LENGTH = 2000;
    private static PoolingHttpClientConnectionManager connManager;
    private static CloseableHttpClient httpClient;

    public static CloseableHttpClient createHttpClient(int maxConnections, int maxRouteConnctions) {
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        connManager = new PoolingHttpClientConnectionManager();
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(120000).build();
        connManager.setDefaultSocketConfig(socketConfig);
        MessageConstraints messageConstraints = MessageConstraints.custom().setMaxHeaderCount(200).setMaxLineLength(2000).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).setMessageConstraints(messageConstraints).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        connManager.setMaxTotal(800);
        connManager.setDefaultMaxPerRoute(400);
        connManager.closeIdleConnections(30L, TimeUnit.MILLISECONDS);
        connManager.closeExpiredConnections();
        return HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    public static HttpInvokeResult invokeGet(String url) {
        HttpGet get = new HttpGet(url);
        get.setConfig(HttpClientUtil.getRequestConfig());
        CloseableHttpResponse response = null;
        return HttpClientUtil.doInvokeGet(get, response);
    }

    public static HttpInvokeResult invokeGetWithHeader(String url, Map<String, String> headers) {
        HttpGet get = new HttpGet(url);
        get.setConfig(HttpClientUtil.getRequestConfig());
        CloseableHttpResponse response = null;
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getKey() == null || entry.getKey().equals("") || entry.getValue() == null || entry.getValue().equals("")) continue;
                get.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return HttpClientUtil.doInvokeGet(get, response);
    }

    public static HttpInvokeResult invokePost(String reqURL, Map<String, String> params) {
        HttpPost httpPost = new HttpPost(reqURL);
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
            formParams.add(pair);
        }
        UrlEncodedFormEntity urlEntity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
        httpPost.setEntity((HttpEntity)urlEntity);
        httpPost.setConfig(HttpClientUtil.getRequestConfig());
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            boolean success = HttpClientUtil.isSuccess(statusCode);
            if (entity != null) {
                HttpInvokeResult httpInvokeResult = new HttpInvokeResult(success, EntityUtils.toString((HttpEntity)entity));
                return httpInvokeResult;
            }
            HttpInvokeResult httpInvokeResult = new HttpInvokeResult(success, "");
            return httpInvokeResult;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            HttpClientUtil.handleFinally((HttpRequestBase)httpPost, response);
        }
    }

    public static HttpInvokeResult invokePost(String url, String content) throws RuntimeException {
        HttpInvokeResult httpInvokeResult;
        boolean success;
        CloseableHttpResponse response;
        HttpPost httpPost;
        block6: {
            httpPost = new HttpPost(url);
            response = null;
            if (content != null && content.length() > 0) {
                httpPost.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
            }
            httpPost.setConfig(HttpClientUtil.getRequestConfig());
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            success = HttpClientUtil.isSuccess(statusCode);
            if (entity == null) break block6;
            HttpInvokeResult httpInvokeResult2 = new HttpInvokeResult(success, EntityUtils.toString((HttpEntity)entity), statusCode);
            HttpClientUtil.handleFinally((HttpRequestBase)httpPost, response);
            return httpInvokeResult2;
        }
        try {
            httpInvokeResult = new HttpInvokeResult(success, "");
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtil.handleFinally((HttpRequestBase)httpPost, response);
                throw throwable;
            }
        }
        HttpClientUtil.handleFinally((HttpRequestBase)httpPost, response);
        return httpInvokeResult;
    }

    public static HttpInvokeResult invokePutWithBody(String url, String content) throws RuntimeException {
        HttpPut httpPut = new HttpPut(url);
        CloseableHttpResponse response = null;
        try {
            if (content != null && content.length() > 0) {
                httpPut.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
            }
            httpPut.setConfig(HttpClientUtil.getRequestConfig());
            response = httpClient.execute((HttpUriRequest)httpPut);
            HttpEntity entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            boolean success = HttpClientUtil.isSuccess(statusCode);
            if (entity != null) {
                HttpInvokeResult httpInvokeResult = new HttpInvokeResult(success, EntityUtils.toString((HttpEntity)entity));
                return httpInvokeResult;
            }
            HttpInvokeResult httpInvokeResult = new HttpInvokeResult(success, "");
            return httpInvokeResult;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpPut.releaseConnection();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static RequestConfig getRequestConfig() {
        return RequestConfigHolder.REQUEST_CONFIG;
    }

    private static void handleFinally(HttpRequestBase get, CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
            get.releaseConnection();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static HttpInvokeResult doInvokeGet(HttpGet get, CloseableHttpResponse response) {
        try {
            response = httpClient.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            boolean success = HttpClientUtil.isSuccess(statusCode);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                HttpInvokeResult httpInvokeResult = new HttpInvokeResult(success, EntityUtils.toString((HttpEntity)entity));
                return httpInvokeResult;
            }
            HttpInvokeResult httpInvokeResult = new HttpInvokeResult(success, "");
            return httpInvokeResult;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            HttpClientUtil.handleFinally((HttpRequestBase)get, response);
        }
    }

    private static boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    static {
        httpClient = HttpClientUtil.createHttpClient(800, 400);
    }

    public static class HttpInvokeResult {
        private boolean success;
        private String result;
        private int code;

        public HttpInvokeResult(boolean success, String result, int code) {
            this.success = success;
            this.result = result;
            this.code = code;
        }

        public HttpInvokeResult(boolean success, String result) {
            this.success = success;
            this.result = result;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String toString() {
            return String.format("code:%d, success:%s, result:%s", this.code, this.success, this.result);
        }
    }

    private static class RequestConfigHolder {
        private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).setConnectionRequestTimeout(120000).build();

        private RequestConfigHolder() {
        }
    }
}

