/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push.mpassutil;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SignUtil {
    public static String sign(String content, String priKey, String charset) {
        try {
            PrivateKey pKey = SignUtil.getPrivateKeyFromX509("RSA", priKey);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(pKey);
            signature.update(content.getBytes(charset));
            return new String(Base64.encodeBase64((byte[])signature.sign()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static PrivateKey getPrivateKeyFromX509(String algorithm, String ins) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = ins.getBytes("utf-8");
            encodedKey = Base64.decodeBase64((byte[])encodedKey);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static PublicKey getPublicKeyFromX509(String algorithm, String ins) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = ins.getBytes("utf-8");
            encodedKey = Base64.decodeBase64((byte[])encodedKey);
            return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean check(String content, String sign, String pubKey, String charset) {
        try {
            PublicKey pKey = SignUtil.getPublicKeyFromX509("RSA", pubKey);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(pKey);
            signature.update(content.getBytes(charset));
            return signature.verify(Base64.decodeBase64((String)sign));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

