/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.push.weapppush;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ServerInfo;
import com.weaver.util.WeAppPushLogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.jivesoftware.openfire.plugin.bean.HttpProxyForPush;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeAppPushUtil {
    public static String pushUrl = "https://pushserver.weaver.com.cn/api/im/push/send";
    private static String access_tokenUrl = "https://pushserver.weaver.com.cn/api/im/auth/token";
    private static int appKey = 1000;
    private static String appSecret = "qvawpz4nyp18iogk";
    private static String accessToken = null;
    private static long accessTokenExpire = 0L;
    private static final String WEAPP_PUSH_CONFIG = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "weAppPush.properties";
    private static final Logger Log = LoggerFactory.getLogger(WeAppPushUtil.class);
    private static WeAppPushUtil instance = null;
    private static final X509TrustManager x = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    private static final TrustManager[] trustAllCerts = new TrustManager[]{x};
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static void reloadWeAppPush() {
        instance = null;
    }

    public static WeAppPushUtil getInstance() {
        if (instance == null) {
            instance = new WeAppPushUtil();
        }
        return instance;
    }

    private WeAppPushUtil() {
        this.loadWeAppPushConfig();
    }

    public static void main(String[] args) throws Exception {
        WeAppPushUtil w = new WeAppPushUtil();
        w.pushMessageToHarmonyOS("com.weaver.emobilehm7", "MAMzLgMmbroC5jkAstPUlQAAAGQAAAAAAAJh75Yab0DRHuJLC_wzQdEnYvz29_4O_g8lpPwWSmM9GRkRT7SOgzMvlUDvQOkPlXvnYOu9H0m3ylNd", "", "", "", "EMobile7", "1323133", "", true, 1);
    }

    private static SSLSocketFactory trustAllHosts(HttpsURLConnection connection) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return oldFactory;
    }

    private static String getMD5String(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void pushMessageToHonor(String packageName, String deviceToken, boolean isIMMsg, String title, String pushContent, String className, String zh_name, String targetType, String targetId, String push_link, int msgSubType) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        data.put("package", packageName);
        data.put("dev", 1);
        data.put("cid", ServerInfo.SYSTEM_CID);
        data.put("deviceToken", deviceToken);
        data.put("channel", 8);
        data.put("requestId", UUID.randomUUID().toString());
        data.put("msgSubType", msgSubType);
        if (isIMMsg) {
            data.put("msgType", 0);
            params.put("category", "IM");
        } else {
            data.put("msgType", 1);
            params.put("category", "WORK");
        }
        HashMap<String, String> cust = new HashMap<String, String>();
        if (targetType != null && !targetType.isEmpty()) {
            cust.put("targetType", targetType);
        }
        if (targetId != null && !targetId.isEmpty()) {
            cust.put("targetId", targetId);
        }
        if (push_link != null && !push_link.isEmpty()) {
            cust.put("push_link", push_link);
        }
        params.put("data", JSON.toJSONString(cust));
        HashMap<String, Object> notification = new HashMap<String, Object>();
        notification.put("title", title);
        notification.put("body", pushContent);
        HashMap<String, Object> badge = new HashMap<String, Object>();
        badge.put("addNum", 1);
        badge.put("class", className);
        notification.put("badge", badge);
        HashMap<String, Object> clickAction = new HashMap<String, Object>();
        clickAction.put("type", 3);
        clickAction.put("intent", "#Intent;compo=com.rvr/.Activity;S.W=U;end");
        notification.put("clickAction", clickAction);
        params.put("notification", notification);
        data.put("param", params);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToHonor ,result :{} ,cost:{} ms,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - HONOR, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (Exception e) {
            Log.error("pushMessageToHonor ,error :{} ,e {},params : {}", new Object[]{e.getMessage(), e, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 -HONOR - ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public void pushMessageToFireBase(String packageName, String title, String pushContent, String deviceToken, String zh_name, String targetId, boolean isIMMsg, int msgSubType) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("package", packageName);
        data.put("dev", 1);
        data.put("cid", ServerInfo.SYSTEM_CID);
        data.put("deviceToken", deviceToken);
        data.put("channel", 7);
        if (isIMMsg) {
            data.put("msgType", 0);
        } else {
            data.put("msgType", 1);
        }
        data.put("msgSubType", msgSubType);
        data.put("requestId", UUID.randomUUID().toString());
        HashMap param = new HashMap();
        HashMap<String, String> notification = new HashMap<String, String>();
        notification.put("title", title);
        notification.put("body", pushContent);
        param.put("notification", notification);
        data.put("param", param);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToFireBase ,result :{},cost:{} ms ,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - FireBase, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (IOException e) {
            Log.error("pushMessageToFireBase ,error :{} data :{} ", (Object)e.getMessage(), data);
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - FireBase - ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public void pushMessageToJpushIos(String packageName, String deviceToken, String appKey, String secret, String title, String pushContent, String targetType, String targetId, String secretGroupType, String push_link, String zh_name, boolean mutableContent, boolean isIMMsg, String isVibrateContent, int msgSubType) {
        boolean apnsProductionBadge;
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("package", packageName);
        data.put("dev", 2);
        data.put("deviceToken", deviceToken);
        data.put("channel", 6);
        data.put("cid", ServerInfo.SYSTEM_CID);
        if (appKey != null && !appKey.isEmpty()) {
            data.put("pushKey", appKey);
        }
        if (secret != null && !secret.isEmpty()) {
            data.put("secret", secret);
        }
        if (isIMMsg) {
            data.put("msgType", 0);
        } else {
            data.put("msgType", 1);
        }
        data.put("msgSubType", msgSubType);
        data.put("requestId", UUID.randomUUID().toString());
        HashMap param = new HashMap();
        HashMap<String, Object> notification = new HashMap<String, Object>();
        if (title == null || title.isEmpty()) {
            notification.put("alert", pushContent);
        } else {
            HashMap<String, String> alert = new HashMap<String, String>();
            if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                alert.put("title", title);
                alert.put("body", pushContent);
            } else {
                alert.put("subtitle", title);
                alert.put("body", pushContent);
            }
            notification.put("alert", alert);
        }
        HashMap<String, String> para = new HashMap<String, String>();
        if (mutableContent) {
            para.put("isVibrate", "1");
            if (isVibrateContent != null && !isVibrateContent.isEmpty()) {
                para.put("iVContent", isVibrateContent);
            }
            notification.put("sound", "call.caf");
            notification.put("mutable-content", true);
            notification.put("content-available", true);
        } else {
            notification.put("content-available", false);
            notification.put("sound", "default");
        }
        if (JiveGlobals.getBooleanProperty((String)"xmpp.push.sound", (boolean)false)) {
            if (isIMMsg) {
                notification.put("sound", "message.wav");
            } else if (!isIMMsg) {
                notification.put("sound", "workflow.wav");
            }
        }
        if (apnsProductionBadge = JiveGlobals.getBooleanProperty((String)"apnsProductionBadge", (boolean)true)) {
            notification.put("badge", "+1");
        } else {
            notification.put("badge", 0);
        }
        if (targetType != null && !targetType.isEmpty() && targetId != null && !targetId.isEmpty()) {
            para.put("targetType", targetType);
            para.put("targetId", targetId);
            if (push_link != null && !push_link.isEmpty()) {
                para.put("push_link", push_link);
            }
            if (secretGroupType != null && !secretGroupType.isEmpty()) {
                para.put("secretGroupType", secretGroupType);
            }
        }
        notification.put("extras", para);
        param.put("notification", notification);
        data.put("param", param);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToJpushIos ,result :{} ,cost:{} ms,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - Jpush-IOS, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (IOException e) {
            Log.error("pushMessageToJpushIos ,error :{} data :{} ", (Object)e.getMessage(), data);
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - Jpush-IOS - ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public void pushMessageToJPushAndroid(String packageName, String deviceToken, String title, String pushContent, String targetType, String targetId, String push_link, String appKey, String secret, String zh_name, boolean isIMMsg, int msgSubType) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("package", null);
        data.put("dev", 1);
        data.put("cid", ServerInfo.SYSTEM_CID);
        data.put("deviceToken", deviceToken);
        data.put("channel", 6);
        data.put("requestId", UUID.randomUUID().toString());
        if (appKey != null) {
            data.put("pushKey", appKey);
        }
        if (secret != null) {
            data.put("secret", secret);
        }
        if (isIMMsg) {
            data.put("msgType", 0);
        } else {
            data.put("msgType", 1);
        }
        data.put("msgSubType", msgSubType);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("platform", "Android");
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("title", title);
        message.put("msg_content", pushContent);
        HashMap<String, String> para = new HashMap<String, String>();
        if (targetType != null && !targetType.isEmpty() && targetId != null && !targetId.isEmpty()) {
            para.put("targetType", targetType);
            para.put("targetId", targetId);
            if (push_link != null && !push_link.isEmpty()) {
                para.put("push_link", push_link);
            }
        }
        message.put("extras", para);
        param.put("message", message);
        data.put("param", param);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToAndroidJpush ,result :{},cost :{}  ms,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - Jpush-Android, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (IOException e) {
            Log.error("pushMessageToAndroidJpush ,error :{} data :{} ", (Object)e.getMessage(), data);
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - Jpush-Android - ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public void pushMessageToOppo(String packageName, String deviceToken, String targetType, String targetId, String push_link, String title, String pushContent, String zh_name, boolean isIMMsg, int msgSubType) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("package", packageName);
        data.put("dev", 1);
        data.put("cid", ServerInfo.SYSTEM_CID);
        data.put("deviceToken", deviceToken);
        data.put("channel", 4);
        if (isIMMsg) {
            data.put("msgType", 0);
        } else {
            data.put("msgType", 1);
        }
        data.put("requestId", UUID.randomUUID().toString());
        data.put("msgSubType", msgSubType);
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> clientCustomMap = new HashMap<String, String>();
        if (targetId != null) {
            clientCustomMap.put("targetId", targetId);
        }
        if (targetType != null) {
            clientCustomMap.put("targetType", targetType);
        }
        if (push_link != null) {
            clientCustomMap.put("push_link", push_link);
        }
        param.put("title", title);
        param.put("content", pushContent);
        param.put("style", 1);
        param.put("networkType", 0);
        param.put("clickActionType", 0);
        param.put("action_parameters", JSON.toJSONString(clientCustomMap));
        data.put("param", param);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToOppo ,result :{},cost:{} ms ,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - OPPO, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (IOException e) {
            Log.error("pushMessageToOppo ,error :{} data :{} ", (Object)e.getMessage(), data);
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - OPPO - ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public void pushMessageToViVo(String packageName, String deviceToken, String targetType, String targetId, String push_link, String title, String pushContent, String zh_name, boolean isIMMsg, int msgSubType) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("package", packageName);
        data.put("dev", 1);
        data.put("deviceToken", deviceToken);
        data.put("channel", 5);
        data.put("cid", ServerInfo.SYSTEM_CID);
        if (isIMMsg) {
            data.put("msgType", 0);
        } else {
            data.put("msgType", 1);
        }
        data.put("requestId", UUID.randomUUID().toString());
        data.put("msgSubType", msgSubType);
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> clientCustomMap = new HashMap<String, String>();
        if (targetId != null) {
            clientCustomMap.put("targetId", targetId);
        }
        if (targetType != null) {
            clientCustomMap.put("targetType", targetType);
        }
        if (push_link != null) {
            clientCustomMap.put("push_link", push_link);
        }
        param.put("title", title);
        param.put("notifyType", 4);
        param.put("content", pushContent);
        param.put("skipType", 1);
        param.put("networkType", -1);
        param.put("classification", 1);
        param.put("pushMode", 0);
        param.put("clientCustomMap", clientCustomMap);
        data.put("param", param);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToViVo ,result :{},cost:{}  ms,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - VIVO, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (IOException e) {
            Log.error("pushMessageToViVo ,error :{} data :{} ", (Object)e.getMessage(), data);
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - VIVO - ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public void pushMessageToApns(String packageName, String deviceToken, String targetType, String targetId, String push_link, String title, String pushContent, int badge, String secretGroupType, String sound, boolean mutable_content, String pushKey, String zh_name, boolean isIMMsg, String isVibrateContent, int msgSubType) {
        long startTime = System.currentTimeMillis();
        boolean apnsProductionBadge = JiveGlobals.getBooleanProperty((String)"apnsProductionBadge", (boolean)true);
        if (!apnsProductionBadge) {
            badge = 0;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("package", packageName);
        data.put("dev", 2);
        data.put("deviceToken", deviceToken);
        data.put("channel", 3);
        data.put("cid", ServerInfo.SYSTEM_CID);
        data.put("requestId", UUID.randomUUID().toString());
        if (pushKey != null) {
            data.put("pushKey", pushKey);
        }
        if (isIMMsg) {
            data.put("msgType", 0);
        } else {
            data.put("msgType", 1);
        }
        data.put("msgSubType", msgSubType);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("collapseId", WeAppPushUtil.getRandomLowercase(24));
        HashMap<String, Object> payload = new HashMap<String, Object>();
        HashMap<String, Object> aps = new HashMap<String, Object>();
        if (title != null && !title.isEmpty()) {
            HashMap<String, String> alert = new HashMap<String, String>();
            if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
                alert.put("title", title);
                alert.put("body", pushContent);
            } else {
                alert.put("subtitle", title);
                alert.put("body", pushContent);
            }
            aps.put("alert", alert);
        } else {
            aps.put("alert", pushContent);
        }
        if (mutable_content) {
            aps.put("mutable-content", 1);
        }
        aps.put("badge", badge);
        if (sound == null || sound.isEmpty()) {
            sound = "default";
        }
        aps.put("sound", sound);
        if (JiveGlobals.getBooleanProperty((String)"xmpp.push.sound", (boolean)false)) {
            if (isIMMsg) {
                aps.put("sound", "message.wav");
            } else if (!isIMMsg) {
                aps.put("sound", "workflow.wav");
            }
        }
        payload.put("aps", aps);
        HashMap<String, String> para = new HashMap<String, String>();
        if (targetType != null && !targetType.isEmpty() && targetId != null && !targetId.isEmpty()) {
            para.put("targetType", targetType);
            para.put("targetId", targetId);
            if (push_link != null && !push_link.isEmpty()) {
                para.put("push_link", push_link);
            }
            para.put("secretGroupType", secretGroupType);
        }
        if (mutable_content) {
            para.put("isVibrate", "1");
            if (isVibrateContent != null && !isVibrateContent.isEmpty()) {
                para.put("iVContent", isVibrateContent);
            }
        }
        payload.put("custom", JSON.toJSONString(para));
        param.put("payload", payload);
        data.put("param", param);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToApns ,result :{},cost:{}  ms,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - apns, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (Exception e) {
            Log.error("pushMessageToApns ,error :{} data :{} ", (Object)e.getMessage(), data);
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("IOS -apns- ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public void pushMessageToXiaoMi(String packageName, String deviceToken, String targetType, String targetId, String push_link, String title, String pushContent, String zh_name, boolean isIMMsg, int msgSubType) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("package", packageName);
        data.put("dev", 1);
        data.put("cid", ServerInfo.SYSTEM_CID);
        data.put("deviceToken", deviceToken);
        data.put("channel", 2);
        if (isIMMsg) {
            data.put("msgType", 0);
        } else {
            data.put("msgType", 1);
        }
        data.put("msgSubType", msgSubType);
        data.put("requestId", UUID.randomUUID().toString());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("title", title);
        param.put("payload", pushContent);
        param.put("description", pushContent);
        param.put("notify_type", -1);
        param.put("pass_through", 0);
        param.put("notify_id", new Random().nextInt());
        String intent_uri = "intent:#Intent;component=" + packageName + "/weaver.fw.com.WelcomeActivity;end";
        param.put("extra.intent_uri", intent_uri);
        param.put("extra.notify_effect", "2");
        if (targetType != null && !targetType.isEmpty()) {
            param.put("extra.targetType", targetType);
        }
        if (targetId != null && !targetId.isEmpty()) {
            param.put("extra.targetId", targetId);
        }
        if (push_link != null && !push_link.isEmpty()) {
            param.put("extra.push_link", push_link);
        }
        data.put("param", param);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToXiaoMi ,result :{} ,cost :{}  ms,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - XIAOMI, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (Exception e) {
            Log.error("pushMessageToXiaoMi ,error :{} ,e {},params : {}", new Object[]{e.getMessage(), e, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 -XIAOMI - ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public void pushMessageToHarmonyOS(String packageName, String deviceToken, String targetType, String targetId, String push_link, String title, String pushContent, String zh_name, boolean isIMMsg, int msgSubType) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap params = new HashMap();
        data.put("package", packageName);
        data.put("dev", 12);
        data.put("deviceToken", deviceToken);
        data.put("channel", 9);
        data.put("cid", ServerInfo.SYSTEM_CID);
        data.put("requestId", UUID.randomUUID().toString());
        data.put("msgSubType", msgSubType);
        HashMap<String, Object> notification = new HashMap<String, Object>();
        notification.put("title", title);
        notification.put("body", pushContent);
        HashMap<String, Integer> badge = new HashMap<String, Integer>();
        if (JiveGlobals.getBooleanProperty((String)"huaweiBadge", (boolean)true)) {
            badge.put("addNum", 1);
        } else {
            badge.put("setNum", 0);
        }
        notification.put("badge", badge);
        HashMap<String, Object> click_action = new HashMap<String, Object>();
        click_action.put("actionType", 1);
        click_action.put("action", "com.huawei.codelabpush.intent.action.click");
        HashMap<String, String> cust = new HashMap<String, String>();
        if (targetType != null && !targetType.isEmpty()) {
            cust.put("targetType", targetType);
        }
        if (targetId != null && !targetId.isEmpty()) {
            cust.put("targetId", targetId);
        }
        if (push_link != null && !push_link.isEmpty()) {
            cust.put("push_link", push_link);
        }
        click_action.put("data", cust);
        notification.put("clickAction", click_action);
        HashMap<String, HashMap<String, Object>> payload = new HashMap<String, HashMap<String, Object>>();
        if (isIMMsg) {
            data.put("msgType", 0);
            notification.put("category", "IM");
        } else {
            data.put("msgType", 1);
            notification.put("category", "WORK");
        }
        payload.put("notification", notification);
        params.put("payload", payload);
        data.put("param", params);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToHarmonyOS ,result :{} ,cost:{} ms,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - HarmonyOS, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (Exception e) {
            Log.error("pushMessageToHarmonyOS ,error :{} ,e {},params : {},pushUrl:{}", new Object[]{e.getMessage(), e, JSON.toJSONString(data), pushUrl});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 -HarmonyOS - ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public void pushMessageToHuawei(String packageName, String deviceToken, String targetType, String targetId, String push_link, String title, String pushContent, String className, String zh_name, boolean isIMMsg, int msgSubType) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        data.put("package", packageName);
        data.put("dev", 1);
        data.put("cid", ServerInfo.SYSTEM_CID);
        data.put("deviceToken", deviceToken);
        data.put("channel", 1);
        data.put("requestId", UUID.randomUUID().toString());
        if (isIMMsg) {
            data.put("msgType", 0);
            params.put("category", "IM");
        } else {
            data.put("msgType", 1);
            params.put("category", "WORK");
        }
        data.put("msgSubType", msgSubType);
        HashMap<String, String> cust = new HashMap<String, String>();
        if (targetType != null && !targetType.isEmpty()) {
            cust.put("targetType", targetType);
        }
        if (targetId != null && !targetId.isEmpty()) {
            cust.put("targetId", targetId);
        }
        if (push_link != null && !push_link.isEmpty()) {
            cust.put("push_link", push_link);
        }
        params.put("data", JSON.toJSONString(cust));
        HashMap<String, Object> notification = new HashMap<String, Object>();
        notification.put("title", title);
        notification.put("body", pushContent);
        if (JiveGlobals.getBooleanProperty((String)"xmpp.push.sound", (boolean)false)) {
            if (isIMMsg) {
                notification.put("sound", "/raw/message");
                notification.put("channel_id", "IM");
                notification.put("default_sound", false);
                notification.put("importance", "NORMAL");
            } else if (!isIMMsg) {
                notification.put("sound", "/raw/workflow");
                notification.put("channel_id", "WORK");
                notification.put("default_sound", false);
                notification.put("importance", "NORMAL");
            }
        }
        HashMap<String, Object> badge = new HashMap<String, Object>();
        if (JiveGlobals.getBooleanProperty((String)"huaweiBadge", (boolean)true)) {
            badge.put("add_num", 1);
        } else {
            badge.put("set_num", 0);
        }
        badge.put("class", className);
        notification.put("badge", badge);
        HashMap<String, Object> click_action = new HashMap<String, Object>();
        click_action.put("type", 3);
        click_action.put("intent", "#Intent;compo=com.rvr/.Activity;S.W=U;end");
        notification.put("click_action", click_action);
        params.put("notification", notification);
        data.put("param", params);
        String result = null;
        try {
            this.getAccess_Token();
            result = WeAppPushUtil.httpPost(pushUrl, JSON.toJSONString(data), 5000, 5000, "application/json");
            long endTime = System.currentTimeMillis();
            Log.info("pushMessageToHuawei ,result :{} ,cost:{} ms,params:{} ", new Object[]{result, endTime - startTime, JSON.toJSONString(data)});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 - HUAWEI, \u63a8\u9001\u5185\u5bb9: " + StringUtils.abbreviate((String)pushContent, (int)50)), (String)JSON.toJSONString(data));
        }
        catch (Exception e) {
            Log.error("pushMessageToHuawei ,error :{} ,e {},params : {},pushUrl:{}", new Object[]{e.getMessage(), e, JSON.toJSONString(data), pushUrl});
            WeAppPushLogUtil.logEvent((String)zh_name, (String)("\u63a5\u6536\u8bbe\u5907 -HUAWEI - ERROR " + StringUtils.abbreviate((String)e.getMessage(), (int)50)), (String)JSON.toJSONString(data));
        }
    }

    public String getAccess_Token() throws IOException {
        if (accessToken != null && accessTokenExpire > System.currentTimeMillis()) {
            return accessToken;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("requestId", UUID.randomUUID().toString());
        param.put("appId", appKey);
        long timestamp = System.currentTimeMillis();
        param.put("timestamp", timestamp);
        String sign = appKey + appSecret + timestamp;
        String signMd5 = WeAppPushUtil.getMD5String(sign).toLowerCase();
        param.put("sign", signMd5);
        try {
            String data;
            JSONObject jsonData;
            JSONObject json;
            String result = WeAppPushUtil.httpPost(access_tokenUrl, JSON.toJSONString(param), 30000, 30000, "application/json");
            System.out.println(result);
            if (result != null && (json = JSONObject.parseObject((String)result)) != null && json.containsKey((Object)"data") && (jsonData = JSONObject.parseObject((String)(data = json.getString("data")))).containsKey((Object)"accessToken")) {
                accessToken = jsonData.getString("accessToken");
                accessTokenExpire = System.currentTimeMillis() + (long)(jsonData.getIntValue("expiresIn") * 1000) - 120000L;
            }
        }
        catch (IOException e) {
            Log.error("getAccess_Token,error :{} ,e :{} ,access_tokenUrl:{} ", new Object[]{e.getMessage(), e, access_tokenUrl});
            throw e;
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String httpUrl, int connectTimeout, int readTimeout) throws IOException {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            URL realUrl = new URL(httpUrl);
            URLConnection connection = realUrl.openConnection();
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String httpUrl, String data, int connectTimeout, int readTimeout) throws ClientProtocolException, IOException {
        HttpProxyForPush httpProxy = HttpProxyForPush.getInstance();
        boolean isUserProxy = httpProxy.isUserProxy();
        CloseableHttpClient httpClient = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout).setConnectionRequestTimeout(connectTimeout).build();
        if (isUserProxy) {
            HttpHost proxy = new HttpHost(httpProxy.getProxyHost(), httpProxy.getProxyPort());
            if (httpProxy.isPropxyNeedAuth()) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxy.getHostName(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(httpProxy.getProxyUsername(), httpProxy.getProxyPassword()));
                httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy)).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(requestConfig).build();
            } else {
                httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy)).setDefaultRequestConfig(requestConfig).build();
            }
        } else {
            httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        }
        HttpPost post = new HttpPost(httpUrl);
        StringEntity entity = null;
        entity = new StringEntity(data, "UTF-8");
        post.setEntity((HttpEntity)entity);
        post.setHeader("Token", accessToken);
        post.setHeader("Content-Type", "application/json");
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)post);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostForHttp(String httpUrl, String data, int connectTimeout, int readTimeout, String Content_Type) throws IOException {
        String string;
        OutputStream outPut = null;
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        try {
            URL url = new URL(httpUrl);
            HttpProxyForPush httpProxy = HttpProxyForPush.getInstance();
            boolean isUserProxy = httpProxy.isUserProxy();
            if (isUserProxy) {
                InetSocketAddress addr = new InetSocketAddress(httpProxy.getProxyHost(), httpProxy.getProxyPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                urlConnection = (HttpURLConnection)url.openConnection(proxy);
                boolean isNeedAuth = httpProxy.isPropxyNeedAuth();
                if (isNeedAuth) {
                    String encoded = new String(Base64.encodeBase64((byte[])(httpProxy.getProxyUsername() + ":" + httpProxy.getProxyPassword()).getBytes()));
                    urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
            } else {
                urlConnection = (HttpURLConnection)url.openConnection();
            }
            urlConnection.setRequestProperty("Token", accessToken);
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            if (Content_Type != null && !Content_Type.isEmpty()) {
                urlConnection.setRequestProperty("Content-Type", Content_Type);
            }
            urlConnection.setConnectTimeout(30000);
            urlConnection.setReadTimeout(30000);
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes("UTF-8"));
            outPut.flush();
            in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            List lines = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            StringBuffer strBuf = new StringBuffer();
            for (String line : lines) {
                strBuf.append(line);
            }
            string = strBuf.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outPut);
            IOUtils.closeQuietly(in);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outPut);
        IOUtils.closeQuietly((InputStream)in);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String httpUrl, String data, int connectTimeout, int readTimeout, String Content_Type) throws IOException {
        String string;
        if (JiveGlobals.getBooleanProperty((String)"httpClientRequest", (boolean)false)) {
            return WeAppPushUtil.httpPost(httpUrl, data, connectTimeout, readTimeout);
        }
        if (httpUrl.startsWith("http://")) {
            return WeAppPushUtil.httpPostForHttp(httpUrl, data, connectTimeout, readTimeout, Content_Type);
        }
        OutputStream outPut = null;
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        try {
            URL url = new URL(httpUrl);
            HttpProxyForPush httpProxy = HttpProxyForPush.getInstance();
            boolean isUserProxy = httpProxy.isUserProxy();
            if (isUserProxy) {
                InetSocketAddress addr = new InetSocketAddress(httpProxy.getProxyHost(), httpProxy.getProxyPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                urlConnection = (HttpsURLConnection)url.openConnection(proxy);
                boolean isNeedAuth = httpProxy.isPropxyNeedAuth();
                if (isNeedAuth) {
                    String encoded = new String(Base64.encodeBase64((byte[])(httpProxy.getProxyUsername() + ":" + httpProxy.getProxyPassword()).getBytes()));
                    urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
            } else {
                urlConnection = (HttpsURLConnection)url.openConnection();
            }
            urlConnection.setRequestProperty("Token", accessToken);
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            if (JiveGlobals.getBooleanProperty((String)"Skip.certificate.validation", (boolean)false)) {
                WeAppPushUtil.trustAllHosts((HttpsURLConnection)urlConnection);
                ((HttpsURLConnection)urlConnection).setHostnameVerifier(DO_NOT_VERIFY);
            }
            if (Content_Type != null && !Content_Type.isEmpty()) {
                urlConnection.setRequestProperty("Content-Type", Content_Type);
            }
            urlConnection.setConnectTimeout(30000);
            urlConnection.setReadTimeout(30000);
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes("UTF-8"));
            outPut.flush();
            in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            List lines = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            StringBuffer strBuf = new StringBuffer();
            for (String line : lines) {
                strBuf.append(line);
            }
            string = strBuf.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outPut);
            IOUtils.closeQuietly(in);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outPut);
        IOUtils.closeQuietly((InputStream)in);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }

    public static String getRandomLowercase(int length) {
        StringBuffer udid = new StringBuffer();
        String model = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        char[] m = model.toCharArray();
        for (int j = 0; j < length; ++j) {
            char c = m[(int)(Math.random() * 62.0)];
            udid = udid.append(c);
        }
        return udid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWeAppPushConfig() {
        InputStream is = null;
        try {
            String appKeyStr;
            File file = new File(WEAPP_PUSH_CONFIG);
            if (!file.exists()) {
                return;
            }
            is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            pushUrl = prop.getProperty("pushUrl").trim();
            if (pushUrl != null) {
                pushUrl = pushUrl.trim();
            }
            if ((access_tokenUrl = prop.getProperty("access_tokenUrl").trim()) != null) {
                access_tokenUrl = access_tokenUrl.trim();
            }
            if ((appKeyStr = prop.getProperty("appKey")) != null) {
                appKeyStr = appKeyStr.trim();
            }
            appKey = Integer.parseInt(appKeyStr);
            appSecret = prop.getProperty("appSecret").trim();
            if (appSecret != null) {
                appSecret = appSecret.trim();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

