/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.jivesoftware.openfire.plugin.util.UDIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverIDUtil {
    private static final Logger Log = LoggerFactory.getLogger(ConverIDUtil.class);
    private static String udid = null;

    public static String genaralTargetId(String a, String b) {
        String targetid = "";
        if (a.startsWith("s_") || a.startsWith("a_") || b.startsWith("s_") || b.startsWith("a_")) {
            int temp = a.compareTo(b);
            targetid = temp <= 0 ? a + "," + b : b + "," + a;
        } else {
            try {
                targetid = Long.parseLong(a) < Long.parseLong(b) ? a + "," + b : b + "," + a;
            }
            catch (Exception e) {
                targetid = a.compareTo(b) <= 0 ? a + "," + b : b + "," + a;
            }
        }
        return targetid;
    }

    public static String getTargetId(String username, String content) {
        String targetid = "";
        String userid = username;
        if (username != null && username.contains("|")) {
            userid = JIDUtil.conNodeToID(username);
        }
        if (content != null && (content.contains("bing") || content.contains("ding") || content.contains("bind"))) {
            return "bing_" + userid;
        }
        if (content != null && content.contains("group_notice")) {
            return "group_notice:" + userid;
        }
        if (content.contains("|")) {
            String contentUserid = JIDUtil.conNodeToID(content);
            targetid = ConverIDUtil.genaralTargetId(userid, contentUserid);
        } else {
            targetid = content;
        }
        return targetid;
    }

    public static String getTargetIdByConversation(String userid, String conversationId) {
        String targetId = "";
        String targetUserId = "";
        if (udid == null) {
            udid = ConverIDUtil.getUDID();
        }
        if (conversationId.contains(",")) {
            String[] s = conversationId.split(",");
            for (int i = 0; i < s.length; ++i) {
                if (userid.equals(s[i])) continue;
                targetUserId = s[i];
                targetId = targetUserId + "|" + udid;
            }
        } else {
            targetId = conversationId;
        }
        return targetId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUDID() {
        if (udid == null) {
            ResultSet rs;
            PreparedStatement pstmt;
            Connection con;
            block7: {
                con = null;
                pstmt = null;
                rs = null;
                try {
                    con = DbConnectionManager.getConnection();
                    pstmt = con.prepareStatement("select * from mobileProperty where name ='rongAppUDIDNew'");
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String propvalue = rs.getString("propvalue");
                        if (propvalue != null) {
                            udid = propvalue.toLowerCase();
                        }
                        break block7;
                    }
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    String UDID = UDIDUtil.getRandomLowercase(6);
                    pstmt = con.prepareStatement("insert into mobileProperty (name,propValue) values (?,?)");
                    pstmt.setString(1, "rongAppUDIDNew");
                    pstmt.setString(2, UDID);
                    pstmt.execute();
                    udid = UDID.toLowerCase();
                }
                catch (Exception e) {
                    try {
                        Log.error("getUDID,error={}", (Object)e.getMessage());
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                        throw throwable;
                    }
                    DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                }
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        return udid;
    }
}

