/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationUserUtil {
    private static Set<String> notNeedUserNameTargetTypes = null;
    private static final Logger Log = LoggerFactory.getLogger(ConversationUserUtil.class);
    private static final String hostFilterFilePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "nousernametargettypes.properties";

    public static boolean isNeedUserName(String targetType) {
        Set<String> targetTypes = ConversationUserUtil.getNeedUserNameTargetTypes();
        Log.debug("isNeedUserName,targetTypes:{},targetType:{}", (Object)JSON.toJSONString(targetTypes), (Object)targetType);
        return targetTypes == null || !targetTypes.contains(targetType);
    }

    private static Set<String> getNeedUserNameTargetTypes() {
        if (notNeedUserNameTargetTypes != null) {
            return notNeedUserNameTargetTypes;
        }
        BufferedReader reader = null;
        try {
            String line = null;
            File file = new File(hostFilterFilePath);
            if (!file.exists()) {
                Log.warn("file {} is not exist .", (Object)hostFilterFilePath);
                notNeedUserNameTargetTypes = new HashSet<String>();
            } else {
                reader = new BufferedReader(new FileReader(file));
                notNeedUserNameTargetTypes = new HashSet<String>();
                while ((line = reader.readLine()) != null) {
                    if (line == null || line.isEmpty()) continue;
                    notNeedUserNameTargetTypes.add(line);
                }
            }
        }
        catch (Exception e) {
            Log.error("getNeedUserNameTargetTypes error .:{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return notNeedUserNameTargetTypes;
    }
}

